/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.implementation;

import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.implementation.ImplementationView;
import org.jetbrains.plugins.ruby.model.implementation.ImplementationViewSearchParameters;
import org.jetbrains.plugins.ruby.model.implementation.SymbolImplementationViewElement;
import org.jetbrains.plugins.ruby.model.implementation.SymbolImplementationViewSessionFactory;

final class SymbolImplementationViewSession
implements ImplementationViewSession {
    private final Project myProject;
    @Nullable
    private final Editor myEditor;
    @Nullable
    private final VirtualFile myFile;
    private final Pointer<? extends Symbol> mySymbolPointer;
    private final ImplementationViewElement myImplementationViewElement;

    SymbolImplementationViewSession(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @NotNull Symbol symbol, @NotNull ImplementationViewElement implementationViewElement) {
        if (project == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(1);
        }
        if (implementationViewElement == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file;
        this.mySymbolPointer = symbol.createPointer();
        this.myImplementationViewElement = implementationViewElement;
    }

    public void dispose() {
    }

    public boolean elementRequiresIncludeSelf() {
        return true;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        ImplementationViewSessionFactory implementationViewSessionFactory = (ImplementationViewSessionFactory)ImplementationViewSessionFactory.EP_NAME.findExtensionOrFail(SymbolImplementationViewSessionFactory.class);
        if (implementationViewSessionFactory == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(3);
        }
        return implementationViewSessionFactory;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        List<ImplementationViewElement> list = List.of(this.myImplementationViewElement);
        if (list == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nullable
    public String getText() {
        return this.myImplementationViewElement.getName();
    }

    public boolean needUpdateInBackground() {
        return true;
    }

    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(@NotNull ProgressIndicator indicator, final @NotNull Processor<? super ImplementationViewElement> processor) {
        if (indicator == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(7);
        }
        ImplementationViewSearchParameters parameters = new ImplementationViewSearchParameters(this.myProject, (SearchScope)GlobalSearchScope.allScope((Project)this.myProject), this.mySymbolPointer);
        CommonProcessors.CollectProcessor<ImplementationViewElement> collector = new CommonProcessors.CollectProcessor<ImplementationViewElement>(this){

            public boolean process(@NotNull ImplementationViewElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.process((Object)element) && processor.process((Object)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/model/implementation/SymbolImplementationViewSession$1", "process"));
            }
        };
        SearchService.getInstance().searchParameters((SearchParameters)parameters).forEach(arg_0 -> this.lambda$searchImplementationsInBackground$0(indicator, (CommonProcessors.CollectProcessor)collector, arg_0));
        List<ImplementationViewElement> list = List.copyOf(collector.getResults());
        if (list == null) {
            SymbolImplementationViewSession.$$$reportNull$$$0(8);
        }
        return list;
    }

    private /* synthetic */ boolean lambda$searchImplementationsInBackground$0(ProgressIndicator indicator, CommonProcessors.CollectProcessor collector, ImplementationView implementationView) {
        indicator.checkCanceled();
        if (!collector.process((Object)new SymbolImplementationViewElement(this.myProject, implementationView))) {
            indicator.cancel();
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationViewElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/implementation/SymbolImplementationViewSession";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/implementation/SymbolImplementationViewSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "searchImplementationsInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchImplementationsInBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }
}

