/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.completion;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public enum SymbolLookupElementLocation {
    OTHER,
    LIBRARY,
    SDK,
    PROJECT,
    SAME_MODULE,
    SAME_DIRECTORY,
    OPENED_IN_EDITOR,
    SAME_FILE;


    @Nullable
    public SearchScope restrictSearchScope(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull PsiElement invocationPoint) {
        if (project == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(1);
        }
        if (invocationPoint == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(2);
        }
        switch (this.ordinal()) {
            case 0: {
                return searchScope;
            }
            case 1: {
                return ProjectScope.getLibrariesScope((Project)project).intersectWith(searchScope);
            }
            case 2: {
                ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
                Sdk sdk = RubySdkUtil.findRubySdk(invocationPoint);
                if (sdk != null) {
                    roots.addAll(List.of(RubySdkUtil.getSdkRoots(sdk)));
                }
                ContainerUtil.addIfNotNull(roots, (Object)LocalFileSystem.getInstance().findFileByNioFile(RubySdkUtil.getRubysigsRoot()));
                if (roots.isEmpty()) {
                    return null;
                }
                return GlobalSearchScopes.directoriesScope((Project)project, (boolean)true, (VirtualFile[])roots.toArray(VirtualFile.EMPTY_ARRAY)).intersectWith(searchScope);
            }
            case 3: {
                return ProjectScope.getContentScope((Project)project).intersectWith(searchScope);
            }
            case 4: {
                if (ProjectUtil.getModules((Project)project).length <= 1) {
                    return null;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)invocationPoint);
                if (module == null) {
                    return null;
                }
                return GlobalSearchScope.moduleScope((Module)module).intersectWith(searchScope);
            }
            case 5: {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)invocationPoint);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile parent = virtualFile.getParent();
                if (parent == null) {
                    return null;
                }
                if (!parent.isDirectory() || parent.getChildren().length == 1) {
                    return null;
                }
                return GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)parent, (boolean)false).intersectWith(searchScope);
            }
            case 6: {
                VirtualFile[] files = FileEditorManager.getInstance((Project)project).getOpenFiles();
                if (files.length == 0) {
                    return null;
                }
                if (files.length == 1) {
                    return searchScope.contains(files[0]) ? GlobalSearchScope.fileScope((Project)project, (VirtualFile)files[0]) : null;
                }
                return GlobalSearchScopes.openFilesScope((Project)project).intersectWith(searchScope);
            }
            case 7: {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)invocationPoint);
                if (virtualFile == null || !searchScope.contains(virtualFile)) {
                    return null;
                }
                return GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile);
            }
        }
        return null;
    }

    @NotNull
    public static List<SymbolLookupElementLocation> getAllLocations() {
        List<SymbolLookupElementLocation> list = List.of(SAME_FILE, OPENED_IN_EDITOR, SAME_DIRECTORY, SAME_MODULE, PROJECT, SDK, LIBRARY, OTHER);
        if (list == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<SymbolLookupElementLocation> getHighPriorityLocations() {
        List<SymbolLookupElementLocation> list = List.of(SAME_FILE, OPENED_IN_EDITOR, SDK);
        if (list == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<SymbolLookupElementLocation> getGeneralLocations() {
        List<SymbolLookupElementLocation> list = List.of(SAME_FILE, SAME_MODULE, PROJECT, SDK, OTHER);
        if (list == null) {
            SymbolLookupElementLocation.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/completion/SymbolLookupElementLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/completion/SymbolLookupElementLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighPriorityLocations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "restrictSearchScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

