/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.completion;

import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class LimitedResultSet
extends CompletionResultSet {
    private final CompletionResultSet myDelegate;
    private final CompletionSorter mySorter;
    private final AtomicInteger myCount;
    private final int myLimit;

    private LimitedResultSet(@NotNull CompletionResultSet delegate, @NotNull CompletionSorter sorter, AtomicInteger count, int limit) {
        if (delegate == null) {
            LimitedResultSet.$$$reportNull$$$0(0);
        }
        if (sorter == null) {
            LimitedResultSet.$$$reportNull$$$0(1);
        }
        super(delegate.getPrefixMatcher(), delegate.getConsumer(), delegate.contributor);
        this.myDelegate = delegate;
        this.mySorter = sorter;
        this.myCount = count;
        this.myLimit = limit;
    }

    public void addElement(@NotNull LookupElement element) {
        CompletionResult matched;
        if (element == null) {
            LimitedResultSet.$$$reportNull$$$0(2);
        }
        if ((matched = CompletionResult.wrap((LookupElement)element, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter)) != null) {
            this.passResult(matched);
        }
    }

    public void passResult(@NotNull CompletionResult result) {
        if (result == null) {
            LimitedResultSet.$$$reportNull$$$0(3);
        }
        this.myDelegate.passResult(result);
        if (this.myCount.incrementAndGet() >= this.myLimit) {
            this.stopHere();
        }
    }

    public void addLookupAdvertisement(@NotNull String text) {
        if (text == null) {
            LimitedResultSet.$$$reportNull$$$0(4);
        }
        this.myDelegate.addLookupAdvertisement(text);
    }

    @NotNull
    public CompletionResultSet caseInsensitive() {
        CompletionResultSet completionResultSet = this.myDelegate.caseInsensitive();
        if (completionResultSet == null) {
            LimitedResultSet.$$$reportNull$$$0(5);
        }
        return completionResultSet;
    }

    public void restartCompletionOnPrefixChange(@NotNull ElementPattern<String> prefixCondition) {
        if (prefixCondition == null) {
            LimitedResultSet.$$$reportNull$$$0(6);
        }
        this.myDelegate.restartCompletionOnPrefixChange(prefixCondition);
    }

    public void restartCompletionWhenNothingMatches() {
        this.myDelegate.restartCompletionWhenNothingMatches();
    }

    @NotNull
    public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
        if (matcher == null) {
            LimitedResultSet.$$$reportNull$$$0(7);
        }
        return new LimitedResultSet(this.myDelegate.withPrefixMatcher(matcher), this.mySorter, this.myCount, this.myLimit);
    }

    @NotNull
    public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            LimitedResultSet.$$$reportNull$$$0(8);
        }
        return new LimitedResultSet(this.myDelegate.withPrefixMatcher(prefix), this.mySorter, this.myCount, this.myLimit);
    }

    @NotNull
    public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
        if (sorter == null) {
            LimitedResultSet.$$$reportNull$$$0(9);
        }
        return new LimitedResultSet(this.myDelegate.withRelevanceSorter(sorter), sorter, this.myCount, this.myLimit);
    }

    @NotNull
    public static LimitedResultSet wrap(@NotNull CompletionResultSet delegate, @NotNull CompletionSorter sorter, int limit) {
        if (delegate == null) {
            LimitedResultSet.$$$reportNull$$$0(10);
        }
        if (sorter == null) {
            LimitedResultSet.$$$reportNull$$$0(11);
        }
        return new LimitedResultSet(delegate, sorter, new AtomicInteger(), limit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/completion/LimitedResultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixCondition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/completion/LimitedResultSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "caseInsensitive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "passResult";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLookupAdvertisement";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restartCompletionOnPrefixChange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withPrefixMatcher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withRelevanceSorter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

