/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.model.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DumbAwareCache<K, V>
implements Cache<K, V> {
    private final Project myProject;
    private final Cache<K, V> myDelegate;

    public DumbAwareCache(@NotNull Project project, @NotNull Cache<K, V> delegate) {
        if (project == null) {
            DumbAwareCache.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            DumbAwareCache.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDelegate = delegate;
    }

    @NotNull
    public ConcurrentMap<K, V> asMap() {
        ConcurrentMap concurrentMap = this.myDelegate.asMap();
        if (concurrentMap == null) {
            DumbAwareCache.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    public void cleanUp() {
        this.myDelegate.cleanUp();
    }

    public long estimatedSize() {
        return this.myDelegate.estimatedSize();
    }

    public V get(@NotNull K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        if (key == null) {
            DumbAwareCache.$$$reportNull$$$0(3);
        }
        if (mappingFunction == null) {
            DumbAwareCache.$$$reportNull$$$0(4);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            Object existing = this.myDelegate.getIfPresent(key);
            return (V)(existing != null ? existing : mappingFunction.apply(key));
        }
        return (V)this.myDelegate.get(key, mappingFunction);
    }

    @NotNull
    public Map<K, V> getAll(@NotNull Iterable<? extends K> keys, @NotNull Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends V>> mappingFunction) {
        if (keys == null) {
            DumbAwareCache.$$$reportNull$$$0(5);
        }
        if (mappingFunction == null) {
            DumbAwareCache.$$$reportNull$$$0(6);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            LinkedHashMap<? extends K, ? extends V> result = new LinkedHashMap<K, V>(this.myDelegate.getAllPresent(keys));
            LinkedHashSet<K> missing = new LinkedHashSet<K>();
            for (K key : keys) {
                if (result.containsKey(key)) continue;
                missing.add(key);
            }
            result.putAll(mappingFunction.apply(missing));
            Map map = Collections.unmodifiableMap(result);
            if (map == null) {
                DumbAwareCache.$$$reportNull$$$0(7);
            }
            return map;
        }
        Map map = this.myDelegate.getAll(keys, mappingFunction);
        if (map == null) {
            DumbAwareCache.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public Map<K, V> getAllPresent(@NotNull Iterable<? extends K> keys) {
        if (keys == null) {
            DumbAwareCache.$$$reportNull$$$0(9);
        }
        Map map = this.myDelegate.getAllPresent(keys);
        if (map == null) {
            DumbAwareCache.$$$reportNull$$$0(10);
        }
        return map;
    }

    @Nullable
    public V getIfPresent(@NotNull K key) {
        if (key == null) {
            DumbAwareCache.$$$reportNull$$$0(11);
        }
        return (V)this.myDelegate.getIfPresent(key);
    }

    public void invalidate(@NotNull K key) {
        if (key == null) {
            DumbAwareCache.$$$reportNull$$$0(12);
        }
        this.myDelegate.invalidate(key);
    }

    public void invalidateAll() {
        this.myDelegate.invalidateAll();
    }

    public void invalidateAll(@NotNull Iterable<? extends K> keys) {
        if (keys == null) {
            DumbAwareCache.$$$reportNull$$$0(13);
        }
        this.myDelegate.invalidateAll(keys);
    }

    @NotNull
    public Policy<K, V> policy() {
        Policy policy = this.myDelegate.policy();
        if (policy == null) {
            DumbAwareCache.$$$reportNull$$$0(14);
        }
        return policy;
    }

    public void put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            DumbAwareCache.$$$reportNull$$$0(15);
        }
        if (value == null) {
            DumbAwareCache.$$$reportNull$$$0(16);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        this.myDelegate.put(key, value);
    }

    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            DumbAwareCache.$$$reportNull$$$0(17);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        this.myDelegate.putAll(map);
    }

    @NotNull
    public CacheStats stats() {
        CacheStats cacheStats = this.myDelegate.stats();
        if (cacheStats == null) {
            DumbAwareCache.$$$reportNull$$$0(18);
        }
        return cacheStats;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 10, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/model/cache/DumbAwareCache";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingFunction";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/model/cache/DumbAwareCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPresent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "policy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllPresent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIfPresent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invalidateAll";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 10, 14, 18 -> new IllegalStateException(string);
        };
    }
}

