/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.words.RAbstractWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class WarblerPsiUtil {
    private static final Logger LOG = Logger.getInstance(WarblerPsiUtil.class);

    private WarblerPsiUtil() {
    }

    @NotNull
    public static String getSimpleDotReferenceName(@NotNull RDotReference dotReference) {
        if (dotReference == null) {
            WarblerPsiUtil.$$$reportNull$$$0(0);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < dotReference.getChildren().length; ++i) {
            if (!(dotReference.getChildren()[i] instanceof RIdentifier)) continue;
            result.append(dotReference.getChildren()[i].getText()).append('.');
        }
        if (!result.isEmpty()) {
            result.deleteCharAt(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            WarblerPsiUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String @NotNull [] parseStringArray(@NotNull RAbstractWords words) {
        PsiElement child;
        if (words == null) {
            WarblerPsiUtil.$$$reportNull$$$0(2);
        }
        if ((child = words.getFirstChild()) != null && child.getNextSibling() != null) {
            String[] stringArray = child.getNextSibling().getText().split(" ");
            if (stringArray == null) {
                WarblerPsiUtil.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            WarblerPsiUtil.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static String @NotNull [] parseStringArray(@NotNull RArrayIndexing words) {
        if (words == null) {
            WarblerPsiUtil.$$$reportNull$$$0(5);
        }
        List indexes = words.getIndexes();
        String[] result = new String[indexes.size()];
        for (int i = 0; i < indexes.size(); ++i) {
            RPsiElement index = (RPsiElement)indexes.get(i);
            if (index instanceof RBaseString) {
                String s;
                result[i] = s = ((PsiElement)((RBaseString)index).getPsiContent().get(0)).getText();
                continue;
            }
            LOG.error("RArrayIndexing contains child that can't be casted to RBaseString");
        }
        if (result == null) {
            WarblerPsiUtil.$$$reportNull$$$0(6);
        }
        return result;
    }

    @Nullable
    public static PsiElement findElementInPsiTree(@NotNull PsiElement element, @NotNull Class<?> clazz) {
        if (element == null) {
            WarblerPsiUtil.$$$reportNull$$$0(7);
        }
        if (clazz == null) {
            WarblerPsiUtil.$$$reportNull$$$0(8);
        }
        if (clazz.isAssignableFrom(element.getClass())) {
            return element;
        }
        for (PsiElement child : element.getChildren()) {
            PsiElement found = WarblerPsiUtil.findElementInPsiTree(child, clazz);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotReference";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/jruby/warbler/utils/WarblerPsiUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/utils/WarblerPsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleDotReferenceName";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStringArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleDotReferenceName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStringArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElementInPsiTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

