/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog;

import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import icons.RubyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.jruby.warbler.actions.ToggleWebInfConfigAction;
import org.jetbrains.plugins.ruby.jruby.warbler.model.WarblerActionModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.WarblerActionModelChangeListener;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerConfigProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.settings.WarblerSettings;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.dialog.WarblerDialogListener;
import org.jetbrains.plugins.ruby.jruby.warbler.ui.tree.WarblerNodeRenderer;

public class WarblerDialog
extends DialogWrapper {
    private JCheckBox myExecutableCheckBox;
    private JCheckBox myPrecompiledCheckBox;
    private JCheckBox myGemJarCheckBox;
    private JPanel pnlTree;
    private JPanel myContent;
    private JTextField txtFileName;
    private JPanel pnlError;
    private JCheckBox myTraceCheckbox;
    private final InstallGemPanel panel;
    private FileSystemTree fileSystemTree;
    private WarblerActionModel model;
    private final List<WarblerDialogListener> warblerDialogListenerList;

    public WarblerDialog(@NotNull WarblerActionModel model) {
        if (model == null) {
            WarblerDialog.$$$reportNull$$$0(0);
        }
        super(model.getModule().getProject(), true);
        this.$$$setupUI$$$();
        this.warblerDialogListenerList = ContainerUtil.createLockFreeCopyOnWriteList();
        this.setModel(model);
        this.setTitle(RBundle.message((String)"warbler.dialog.title"));
        this.panel = new InstallGemPanel();
        this.pnlError.add((Component)this.panel, "Center");
        model.addWarblerActionModelChangeListener(new WarbleActionModelChangeListenerImpl());
        this.addInputListeners();
        this.init();
        this.hideOrDisplayEnvironmentError();
        this.myTraceCheckbox.setSelected(WarblerSettings.getInstance((Module)model.getModule()).myWarblerTraceMode);
    }

    public void addWarblerDialogListener(WarblerDialogListener listener) {
        this.warblerDialogListenerList.add(listener);
    }

    protected void addInputListeners() {
        TextFieldKeyListener fl = new TextFieldKeyListener();
        this.txtFileName.addKeyListener(fl);
        CheckboxStateChangedListener checkboxStateChangedListener = new CheckboxStateChangedListener();
        this.myExecutableCheckBox.addChangeListener(checkboxStateChangedListener);
        this.myPrecompiledCheckBox.addChangeListener(checkboxStateChangedListener);
        this.myGemJarCheckBox.addChangeListener(checkboxStateChangedListener);
        this.myTraceCheckbox.addChangeListener(checkboxStateChangedListener);
    }

    protected void setModel(@NotNull WarblerActionModel model) {
        if (model == null) {
            WarblerDialog.$$$reportNull$$$0(1);
        }
        this.model = model;
        this.myExecutableCheckBox.setSelected(model.getConfig().isExecutable());
        this.myPrecompiledCheckBox.setSelected(model.getConfig().isPrecompiled());
        this.myGemJarCheckBox.setSelected(model.getConfig().isGemJar());
        this.txtFileName.setText(model.getConfig().getFileName());
        this.hideOrDisplayConfigError();
    }

    protected void hideOrDisplayEnvironmentError() {
        if (this.model.getEnvironmentProblem() != null) {
            this.panel.setVisible(true);
            this.panel.setCaptions(this.model.getEnvironmentProblem().getMessage(), this.model.getEnvironmentProblem().getFixActionCaption());
            this.myContent.setEnabled(false);
            this.getOKAction().setEnabled(false);
        } else {
            this.panel.setVisible(false);
            this.myContent.setEnabled(true);
            this.getOKAction().setEnabled(true);
        }
    }

    protected void hideOrDisplayConfigError() {
        if (this.model.getConfigProblem() != null) {
            this.setErrorText(this.model.getConfigProblem().getMessage());
        } else {
            this.setErrorText(null);
        }
    }

    public JPanel getPnlTree() {
        return this.pnlTree;
    }

    public JPanel getContent() {
        return this.myContent;
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        this.getPnlTree().add((Component)this.createFileTreeControl(), "Center");
        result.add((Component)this.getContent(), "Center");
        return result;
    }

    @NotNull
    public JPanel createFileTreeControl() {
        Tree tree = this.createFileSystemTreeControl();
        JPanel result = new JPanel(new BorderLayout());
        ToggleWebInfConfigAction markAsWAction = new ToggleWebInfConfigAction(tree, this.model.getConfig().getWebInfConfigModel());
        markAsWAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(87, 8)), (JComponent)tree);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)markAsWAction);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        result.add((Component)new ToolbarPanel((JComponent)scrollPane, (ActionGroup)actionGroup, "WarblerFileTreeToolbar", (JComponent)tree), "Center");
        JPanel jPanel = result;
        if (jPanel == null) {
            WarblerDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private Tree createFileSystemTreeControl() {
        Project project = this.model.getModule().getProject();
        WarblerNodeRenderer warblerNodeRenderer = new WarblerNodeRenderer(this.model.getConfig());
        CheckboxTree tree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)warblerNodeRenderer, null, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        fileChooserDescriptor2.setShowFileSystemRoots(false);
        fileChooserDescriptor2.setRoots(new VirtualFile[]{project.getBaseDir()});
        VirtualFile file = project.getBaseDir();
        Runnable init = () -> {
            this.fileSystemTree.updateTree();
            if (file != null) {
                this.fileSystemTree.select(file, null);
            }
        };
        this.fileSystemTree = new FileSystemTreeImpl(this, project, fileChooserDescriptor2, (Tree)tree, null, init, null){};
        this.fileSystemTree.showHiddens(true);
        this.fileSystemTree.getTree().setCellRenderer((TreeCellRenderer)((Object)warblerNodeRenderer));
        CheckboxTree checkboxTree = tree;
        if (checkboxTree == null) {
            WarblerDialog.$$$reportNull$$$0(3);
        }
        return checkboxTree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/jruby/warbler/ui/dialog/WarblerDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/ui/dialog/WarblerDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTreeControl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileSystemTreeControl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        this.myContent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:398px:grow", "center:31px:noGrow,top:4dlu:noGrow,center:32px:noGrow,top:4dlu:noGrow,center:32px:noGrow,top:4dlu:noGrow,center:d:grow"));
        ((Component)jPanel3).setEnabled(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myExecutableCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/RBundle", WarblerDialog.class).getString("warbler.dialog.feature.executable"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPrecompiledCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", WarblerDialog.class).getString("warbler.dialog.feature.precompiled"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGemJarCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", WarblerDialog.class).getString("warbler.dialog.feature.gemJar"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.pnlTree = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow", "center:d:noGrow,top:4dlu:noGrow,center:d:noGrow"));
        jPanel3.add((Component)jPanel5, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", WarblerDialog.class).getString("warbler.dialog.label.outputFileName"));
        jPanel5.add((Component)jLabel, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.txtFileName = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new CellConstraints(3, 3, 2, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.pnlError = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new CellConstraints(1, 1, 4, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myTraceCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", WarblerDialog.class).getString("warbler.dialog.mode.trace"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class InstallGemPanel
    extends JPanel {
        private final JLabel myNotAttachedLabel;
        private final HyperlinkLabel lblInstall;

        private InstallGemPanel() {
            super(new BorderLayout());
            this.myNotAttachedLabel = new JLabel();
            this.myNotAttachedLabel.setIcon(RubyIcons.Ruby.Ruby);
            this.setBackground(LightColors.YELLOW);
            this.add((Component)this.myNotAttachedLabel, "Center");
            JPanel linksPanel = new JPanel(new FlowLayout());
            linksPanel.setBackground(LightColors.YELLOW);
            this.lblInstall = this.createActionLabel();
            linksPanel.add((Component)this.lblInstall);
            this.add((Component)linksPanel, "East");
        }

        private HyperlinkLabel createActionLabel() {
            HyperlinkLabel label = new HyperlinkLabel("", LightColors.YELLOW);
            label.addHyperlinkListener((HyperlinkListener)new HyperlinkListenerImpl());
            return label;
        }

        public void setCaptions(@NlsContexts.Label String problemCaption, @NlsContexts.LinkLabel String fixCaption) {
            this.myNotAttachedLabel.setText(problemCaption);
            this.lblInstall.setHyperlinkText(fixCaption);
        }
    }

    class WarbleActionModelChangeListenerImpl
    implements WarblerActionModelChangeListener {
        WarbleActionModelChangeListenerImpl() {
        }

        @Override
        public void environmentProblemChanged(WarblerEnvironmentProblem currentEnvironmentProblem) {
            WarblerDialog.this.hideOrDisplayEnvironmentError();
        }

        @Override
        public void configProblemChanged(WarblerConfigProblem currentConfigProblem) {
            WarblerDialog.this.hideOrDisplayConfigError();
        }
    }

    class TextFieldKeyListener
    implements KeyListener {
        TextFieldKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == WarblerDialog.this.txtFileName) {
                WarblerDialog.this.model.getConfig().setFileName(WarblerDialog.this.txtFileName.getText());
            }
        }
    }

    class CheckboxStateChangedListener
    implements ChangeListener {
        CheckboxStateChangedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == WarblerDialog.this.myExecutableCheckBox) {
                WarblerDialog.this.model.getConfig().setExecutable(WarblerDialog.this.myExecutableCheckBox.isSelected());
            } else if (e.getSource() == WarblerDialog.this.myPrecompiledCheckBox) {
                WarblerDialog.this.model.getConfig().setPrecompiled(WarblerDialog.this.myPrecompiledCheckBox.isSelected());
            } else if (e.getSource() == WarblerDialog.this.myGemJarCheckBox) {
                WarblerDialog.this.model.getConfig().setGemJar(WarblerDialog.this.myGemJarCheckBox.isSelected());
            } else if (e.getSource() == WarblerDialog.this.myTraceCheckbox) {
                WarblerDialog.this.model.getConfig().setTrace(WarblerDialog.this.myTraceCheckbox.isSelected());
                WarblerSettings.getInstance((Module)WarblerDialog.this.model.getModule()).myWarblerTraceMode = WarblerDialog.this.myTraceCheckbox.isSelected();
            }
        }
    }

    class HyperlinkListenerImpl
    implements HyperlinkListener {
        HyperlinkListenerImpl() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && WarblerDialog.this.model.getEnvironmentProblem() != null) {
                for (WarblerDialogListener listener : WarblerDialog.this.warblerDialogListenerList) {
                    listener.fixActionPerformed(WarblerDialog.this.model.getEnvironmentProblem().getType());
                }
            }
        }
    }
}

