/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.model;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.jruby.warbler.model.WarblerActionModelChangeListener;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerConfigProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblem;

public class WarblerActionModel {
    private final Module module;
    private final DataContext dataContext;
    private WarblerEnvironmentProblem environmentProblem;
    private WarblerConfigProblem configProblem;
    private final WarblerConfigModel config;
    private final List<WarblerActionModelChangeListener> warblerActionModelChangeListenerList;

    public WarblerActionModel(@NotNull Module module, @NotNull DataContext dataContext, @NotNull WarblerConfigModel config) {
        if (module == null) {
            WarblerActionModel.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            WarblerActionModel.$$$reportNull$$$0(1);
        }
        if (config == null) {
            WarblerActionModel.$$$reportNull$$$0(2);
        }
        this.warblerActionModelChangeListenerList = ContainerUtil.createLockFreeCopyOnWriteList();
        this.module = module;
        this.dataContext = dataContext;
        this.config = config;
    }

    public Module getModule() {
        return this.module;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public WarblerEnvironmentProblem getEnvironmentProblem() {
        return this.environmentProblem;
    }

    public void setEnvironmentProblem(WarblerEnvironmentProblem environmentProblem) {
        this.environmentProblem = environmentProblem;
        for (WarblerActionModelChangeListener listener : this.warblerActionModelChangeListenerList) {
            listener.environmentProblemChanged(environmentProblem);
        }
    }

    public WarblerConfigModel getConfig() {
        return this.config;
    }

    public void addWarblerActionModelChangeListener(@NotNull WarblerActionModelChangeListener listener) {
        if (listener == null) {
            WarblerActionModel.$$$reportNull$$$0(3);
        }
        this.warblerActionModelChangeListenerList.add(listener);
    }

    public WarblerConfigProblem getConfigProblem() {
        return this.configProblem;
    }

    public void setConfigProblem(WarblerConfigProblem configProblem) {
        this.configProblem = configProblem;
        for (WarblerActionModelChangeListener listener : this.warblerActionModelChangeListenerList) {
            listener.configProblemChanged(configProblem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/model/WarblerActionModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addWarblerActionModelChangeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

