/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.helpers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerConfigProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblemEnum;

public final class WarblerValidatorHelper {
    private WarblerValidatorHelper() {
    }

    @Nullable
    public static WarblerEnvironmentProblem checkEnvironment(@NotNull Module module) {
        Sdk sdk;
        if (module == null) {
            WarblerValidatorHelper.$$$reportNull$$$0(0);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || !StringUtil.toLowerCase((String)sdk.getName()).contains("jruby")) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.jruby.sdk.not.found"), RBundle.message((String)"warbler.validation.error.jruby.sdk.not.found.fix.title"), WarblerEnvironmentProblemEnum.WRONG_SDK);
        }
        GemInfo gemInfo = RubyGemSearchUtil.findGem(module, sdk, "rails");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.rails.not.found"), RBundle.message((String)"warbler.validation.error.rails.not.found.fix.title"), WarblerEnvironmentProblemEnum.RAILS_NOT_FOUND);
        }
        gemInfo = RubyGemSearchUtil.findGem(module, sdk, "warbler");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.warbler.not.found"), RBundle.message((String)"warbler.validation.error.warbler.not.found.fix.title"), WarblerEnvironmentProblemEnum.WARBLER_NOT_FOUND);
        }
        return null;
    }

    @Nullable
    public static WarblerConfigProblem checkConfig(@NotNull WarblerConfigModel config) {
        if (config == null) {
            WarblerValidatorHelper.$$$reportNull$$$0(1);
        }
        if (!StandardFileSystems.local().isValidName(config.getFileName())) {
            return new WarblerConfigProblem(RBundle.message((String)"warbler.validation.error.fileName"));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerValidatorHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

