/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.StringOrSymbolReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;

public class I18nTranslateReference
extends StringOrSymbolReference {
    @NotNull
    public static final String KEY_SEPARATOR = ".";
    @NotNull
    public static final List<String> OPTIONS = List.of("cascade", "count", "deep_interpolation", "default", "exception_handler", "fallback", "fallback_in_progress", "format", "locale", "object", "raise", "resolve", "scope", "separator", "throw");
    private static final InsertHandler<RubyLookupElement> INSERT_HANDLER = new InsertHandler<RubyLookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull RubyLookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            int startOffset = context.getStartOffset();
            if (startOffset <= 0 || document.getCharsSequence().charAt(startOffset - 1) != ':') {
                return;
            }
            RSymbol symbol = RubyElementFactoryCore.createSymbol((PsiElement)context.getFile(), (String)item.getLookupString());
            String text = symbol.getContent().getText();
            if (text.startsWith("'")) {
                document.replaceString(startOffset, context.getTailOffset(), (CharSequence)text);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    @NotNull
    private final Module myModule;
    @NotNull
    private final NullableLazyValue<String> myScopeProvider;

    I18nTranslateReference(@NotNull RPossibleCall possibleCall, @NotNull PsiElement element, @NotNull Module module) {
        if (possibleCall == null) {
            I18nTranslateReference.$$$reportNull$$$0(0);
        }
        if (element == null) {
            I18nTranslateReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            I18nTranslateReference.$$$reportNull$$$0(2);
        }
        super((PsiElement)possibleCall, element);
        this.myScopeProvider = NullableLazyValue.atomicLazyNullable(() -> this.computeScope());
        this.myModule = module;
    }

    @NotNull
    public RPossibleCall getElement() {
        RPossibleCall rPossibleCall = (RPossibleCall)this.myElement;
        if (rPossibleCall == null) {
            I18nTranslateReference.$$$reportNull$$$0(3);
        }
        return rPossibleCall;
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.notNullize((String)RubyPsiUtilCore.getElementText((PsiElement)this.getStringOrSymbol()), (String)"*INVALID*");
        if (string == null) {
            I18nTranslateReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String elementText;
        if (newElementName == null) {
            I18nTranslateReference.$$$reportNull$$$0(5);
        }
        String prefix = (elementText = this.getCanonicalText()).contains(KEY_SEPARATOR) ? elementText.substring(0, elementText.lastIndexOf(KEY_SEPARATOR) + 1) : "";
        return I18nTranslateReference.rename(this.getStringOrSymbol(), prefix + newElementName);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            I18nTranslateReference.$$$reportNull$$$0(6);
        }
        return super.isReferenceTo(element) && I18nProvider.forElement(element).canBeTranslationReferenceTarget(element);
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            I18nTranslateReference.$$$reportNull$$$0(7);
        }
        if (context == null) {
            I18nTranslateReference.$$$reportNull$$$0(8);
        }
        if (result == null) {
            I18nTranslateReference.$$$reportNull$$$0(9);
        }
        I18nDictionary dictionary = this.getDictionary();
        String scope = this.isScoped() ? this.getScope() + KEY_SEPARATOR : null;
        String defaultLocale = RubyI18nFoldingLocaleSettings.getInstance(this.getProject()).getLocale();
        for (String key : dictionary.getAllKeys()) {
            String type = I18nTranslateReference.getLookupTypeFromLocales(defaultLocale, dictionary.getLocalesByKey(key));
            String lookupString = scope != null && key.startsWith(scope) ? key.substring(scope.length()) : key;
            if (!RubyCompletionProviderUtil.lookupStringShouldBeProcessed(lookupString, result)) continue;
            result.addElement(I18nTranslateReference.createLookupElement(lookupString, type));
        }
    }

    @Override
    protected ResolveResult @NotNull [] multiResolveInner(boolean incompleteCode) {
        I18nDictionary dictionary = this.getDictionary();
        List<String> keys = this.getFullKeys();
        ArrayList<I18nResolveResult> results = new ArrayList<I18nResolveResult>();
        for (String key : keys) {
            for (LocaleEntry localeEntry : dictionary.getLocaleEntriesByKey(key)) {
                PsiElement record = localeEntry.getRecord(key);
                if (record == null) continue;
                results.add(new I18nResolveResult(record, localeEntry));
            }
        }
        ResolveResult[] resolveResultArray = results.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            I18nTranslateReference.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    @NotNull
    public List<String> getFullKeys() {
        String key = StringUtil.trimStart((String)this.getCanonicalText(), (String)KEY_SEPARATOR);
        List<String> list = Collections.singletonList(this.isScoped() ? this.getScope() + KEY_SEPARATOR + key : key);
        if (list == null) {
            I18nTranslateReference.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public I18nDictionary getDictionary() {
        I18nDictionary i18nDictionary = I18nProvider.getDictionary(this.myModule);
        if (i18nDictionary == null) {
            I18nTranslateReference.$$$reportNull$$$0(12);
        }
        return i18nDictionary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        I18nTranslateReference reference = (I18nTranslateReference)o;
        return this.myModule.equals((Object)reference.myModule);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myModule.hashCode();
        return result;
    }

    @Nullable
    public String getScope() {
        return (String)this.myScopeProvider.getValue();
    }

    public boolean isScoped() {
        String prefix = this.getScope();
        return prefix != null && !prefix.isEmpty();
    }

    @Nullable
    private String computeScope() {
        return StringUtil.nullize((String)String.join((CharSequence)KEY_SEPARATOR, I18nTranslateCallType.getScopeOption(this.getElement())));
    }

    @NotNull
    protected static LookupElement createLookupElement(@NotNull String key, @NotNull String type) {
        if (key == null) {
            I18nTranslateReference.$$$reportNull$$$0(13);
        }
        if (type == null) {
            I18nTranslateReference.$$$reportNull$$$0(14);
        }
        return new RubyLookupElement(key, null, type, false, PlatformIcons.PROPERTY_ICON, RailsIcons.I18N_PROPERTY_ICON, INSERT_HANDLER);
    }

    @NotNull
    protected static String getLookupTypeFromLocales(@NotNull String defaultLocale, @NotNull Collection<String> locales) {
        if (defaultLocale == null) {
            I18nTranslateReference.$$$reportNull$$$0(15);
        }
        if (locales == null) {
            I18nTranslateReference.$$$reportNull$$$0(16);
        }
        List sortedLocales = ContainerUtil.sorted(locales, Comparator.comparing(defaultLocale::equals).reversed().thenComparing(Comparator.naturalOrder()));
        if (sortedLocales.size() <= 2) {
            String string = String.join((CharSequence)" and ", sortedLocales);
            if (string == null) {
                I18nTranslateReference.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = (String)sortedLocales.get(0) + " and " + (sortedLocales.size() - 1) + " others";
        if (string == null) {
            I18nTranslateReference.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 12, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocale";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/references/I18nTranslateReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeys";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionary";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupTypeFromLocales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLookupTypeFromLocales";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 12, 17, 18 -> new IllegalStateException(string);
        };
    }
}

