/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.locales;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.locales.I18nRubyUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;

public class I18nRubyAdapter {
    private final RFile myFile;

    public I18nRubyAdapter(RFile file) {
        this.myFile = file;
    }

    @NotNull
    public PsiFile getPsiFile() {
        RFile rFile = this.myFile;
        if (rFile == null) {
            I18nRubyAdapter.$$$reportNull$$$0(0);
        }
        return rFile;
    }

    @Nullable
    public String getLocale() {
        RAssoc topLevelHash = this.getLocaleHash();
        if (topLevelHash == null) {
            return null;
        }
        return topLevelHash.getKeyText();
    }

    public static boolean isTranslationElement(PsiElement element) {
        return (Boolean)ReadAction.compute(() -> {
            if (!(element.isValid() && element instanceof RAssoc && I18nProvider.isLocaleFile(element.getContainingFile()))) {
                return false;
            }
            RPsiElement value = ((RAssoc)element).getValue();
            return value == null || value instanceof RStringLiteral;
        });
    }

    @Nullable
    private RAssoc getLocaleHash() {
        for (RPsiElement statement : this.myFile.getCompoundStatement().getStatements()) {
            if (!(statement instanceof RAssocList)) continue;
            return (RAssoc)ContainerUtil.getFirstItem((List)((RAssocList)statement).getAssocElements());
        }
        return null;
    }

    @Nullable
    public String getValue(String key) {
        RPsiElement value;
        RAssoc record = this.getRecord(key);
        if (record != null && (value = record.getValue()) instanceof RStringLiteral) {
            return ((RStringLiteral)value).getContent();
        }
        return null;
    }

    @Nullable
    public RAssoc getRecord(String k) {
        String[] key = k.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : k.split("\\.");
        RAssoc hash = this.getLocaleHash();
        block0: for (String aKey : key) {
            if (hash == null) {
                return null;
            }
            RPsiElement value = hash.getValue();
            hash = null;
            if (!(value instanceof RAssocList)) continue;
            for (RAssoc assoc : ((RAssocList)value).getAssocElements()) {
                if (!aKey.equals(assoc.getKeyText())) continue;
                hash = assoc;
                continue block0;
            }
        }
        return hash;
    }

    public RAssoc createI18nRecord(String k, String value) {
        RAssoc record = this.getRecord(k);
        if (record != null) {
            return record;
        }
        String[] key = k.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : k.split("\\.");
        String formatedValue = StringUtil.wrapWithDoubleQuote((String)value.trim().replaceAll("\\s+", " "));
        return I18nRubyUtil.createI18nRecord(this.getLocaleHash(), key, formatedValue);
    }

    @NotNull
    @NlsSafe
    public static String getFullKey(RAssoc keyValue) {
        RAssoc parent;
        StringBuilder builder2 = new StringBuilder();
        RAssoc element = keyValue;
        while (element != null && (parent = (RAssoc)PsiTreeUtil.getParentOfType((PsiElement)element, RAssoc.class)) != null) {
            if (!builder2.isEmpty()) {
                builder2.insert(0, '.');
            }
            builder2.insert(0, element.getKeyText());
            element = parent;
        }
        String string = builder2.toString();
        if (string == null) {
            I18nRubyAdapter.$$$reportNull$$$0(1);
        }
        return string;
    }

    public List<String> getAllKeys(String prefix) {
        RAssoc record = this.getRecord(prefix);
        if (record == null) {
            return Collections.emptyList();
        }
        RPsiElement psiValue = record.getValue();
        ArrayList<String> list = new ArrayList<String>();
        I18nRubyAdapter.addKeysRec(prefix, (PsiElement)psiValue, list);
        return list;
    }

    private static void addKeysRec(String prefix, PsiElement element, List<String> list) {
        if (element instanceof RAssocList) {
            for (PsiElement child : ((RAssocList)element).getElements()) {
                I18nRubyAdapter.addKeysRec(prefix, child, list);
            }
        }
        if (element instanceof RAssoc) {
            RAssoc assoc = (RAssoc)element;
            RPsiElement psiValue = assoc.getValue();
            Object key = assoc.getKeyText();
            if (!prefix.isEmpty()) {
                key = prefix + "." + (String)key;
            }
            if (psiValue instanceof RStringLiteral) {
                list.add((String)key);
            } else {
                I18nRubyAdapter.addKeysRec((String)key, (PsiElement)psiValue, list);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/locales/I18nRubyAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

