/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.inspection.quickfixes;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.inspection.quickfixes.RubyI18nPropertyValuesEditor;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.rails.RailsIcons;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class I18nCreatePropertyDialog
extends DialogWrapper {
    @NotNull
    private static final String LAST_USED_LOCALE_FILE_KEY = "ruby.i18n.create.property.last_used_locale_file";
    @NotNull
    private static final String LAST_USED_LOCALE_KEY = "ruby.i18n.create.property.last_used_locale";
    @Nullable
    private Project myProject;
    @Nullable
    private I18nDictionary myDictionary;
    @NotNull
    private Map<String, LocaleEntry> myPresentationToLocaleEntries;
    @NotNull
    private final RubyI18nPropertyValuesEditor myPropertyValuesEditor;
    @NotNull
    private final List<String> myInitialKeys;
    @Nullable
    private final String myInitialTranslation;
    private JPanel myPanel;
    private JComponent myPropertyKeyField;
    private JLabel myVariablesLabel;
    private JTextField myVariablesField;
    private JPanel myPropertyValuesPanel;

    public I18nCreatePropertyDialog(@NotNull Project project, @NotNull I18nDictionary dictionary, @NotNull Map<String, LocaleEntry> presentationToLocaleEntries, @NotNull List<String> initialKeys, @Nullable String initialTranslation, @Nullable List<String> initialVariables) {
        if (project == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(0);
        }
        if (dictionary == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(1);
        }
        if (presentationToLocaleEntries == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(2);
        }
        if (initialKeys == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.myProject = project;
        this.myDictionary = dictionary;
        this.myPresentationToLocaleEntries = presentationToLocaleEntries;
        this.myInitialKeys = initialKeys;
        this.myInitialTranslation = initialTranslation;
        this.$$$setupUI$$$();
        this.myPropertyValuesEditor = new RubyI18nPropertyValuesEditor(this.myPresentationToLocaleEntries.keySet(), initialTranslation);
        if (initialVariables != null && !initialVariables.isEmpty()) {
            this.myVariablesField.setText(String.join((CharSequence)", ", initialVariables));
        } else {
            this.myVariablesLabel.setVisible(false);
            this.myVariablesField.setVisible(false);
        }
        this.myPropertyValuesEditor.addRow(this.getSuggestedLocale());
        this.setModal(true);
        this.setTitle(RBundle.message((String)"dialog.rails.i18n.create.property.title"));
        this.init();
        this.myPropertyValuesPanel.add(this.myPropertyValuesEditor.createComponent());
    }

    @NotNull
    public String getPropertyKey() {
        if (this.myPropertyKeyField instanceof EditorTextComponent) {
            String string = ((EditorTextComponent)this.myPropertyKeyField).getText().trim();
            if (string == null) {
                I18nCreatePropertyDialog.$$$reportNull$$$0(4);
            }
            return string;
        }
        String key = (String)ObjectUtils.tryCast((Object)((JComboBox)this.myPropertyKeyField).getSelectedItem(), String.class);
        assert (key != null);
        String string = key.trim();
        if (string == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public @Unmodifiable @NotNull Map<String, String> getLocaleTranslations() {
        Map map = ContainerUtil.map2Map(this.myPropertyValuesEditor.getPropertyValues(), propertyValue -> new Pair((Object)propertyValue.getLocale(), (Object)propertyValue.getTranslation().trim()));
        if (map == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public List<String> getVariables() {
        List<String> list = Arrays.asList(this.myVariablesField.getText().split("\\s*,\\s*"));
        if (list == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(7);
        }
        return list;
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myPropertyKeyField.isEnabled()) {
            return this.myPropertyKeyField;
        }
        return this.myPropertyValuesEditor.getTable();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void dispose() {
        super.dispose();
        this.myProject = null;
        this.myDictionary = null;
        this.myPresentationToLocaleEntries = Collections.emptyMap();
    }

    protected void doOKAction() {
        if (this.isOKActionEnabled()) {
            RubyI18nPropertyValuesEditor.MyPropertyValue propertyValue = (RubyI18nPropertyValuesEditor.MyPropertyValue)ContainerUtil.getFirstItem(this.myPropertyValuesEditor.getPropertyValues());
            if (this.myProject != null && propertyValue != null) {
                String localeFile = (String)ObjectUtils.nullizeByCondition((Object)propertyValue.getLocale(), savedLocale -> !this.isNewPropertyDialog());
                String locale = (String)ObjectUtils.nullizeByCondition((Object)propertyValue.getLocale(), savedLocale -> this.isNewPropertyDialog());
                PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_LOCALE_FILE_KEY, localeFile);
                PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_USED_LOCALE_KEY, locale);
            }
        }
        super.doOKAction();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        Map<String, String> localeTranslations = this.getLocaleTranslations();
        if (localeTranslations.isEmpty()) {
            return new ValidationInfo(RBundle.message((String)"dialog.rails.i18n.create.property.no.translations"));
        }
        String key = this.getPropertyKey();
        for (String localeName : localeTranslations.keySet()) {
            LocaleEntry localeEntry = this.myPresentationToLocaleEntries.get(localeName);
            if (localeEntry == null || localeEntry.getRecord(key) == null) continue;
            return new ValidationInfo(RBundle.message((String)"dialog.rails.i18n.create.property.locale.contains.key", (Object[])new Object[]{key, localeEntry.getRelativeFilePath()}));
        }
        return null;
    }

    @NotNull
    protected String getHelpId() {
        return "reference.create.property.dialog";
    }

    private void createUIComponents() {
        if (this.isNewPropertyDialog()) {
            List keys = this.myDictionary != null ? this.myDictionary.getAllKeys() : Collections.emptyList();
            String key = I18nCreatePropertyDialog.getSuggestedKey(this.myInitialTranslation);
            this.myPropertyKeyField = TextFieldWithAutoCompletion.create((Project)this.myProject, keys, (Icon)RailsIcons.I18N_PROPERTY_ICON, (boolean)false, (String)key);
            ((TextFieldWithAutoCompletion)this.myPropertyKeyField).selectAll();
        } else {
            this.myPropertyKeyField = new ComboBox((Object[])this.myInitialKeys.toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        }
    }

    @Nullable
    private String getSuggestedLocale() {
        if (this.myProject == null || this.myDictionary == null) {
            return null;
        }
        String lastUsedLocaleFile = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_LOCALE_FILE_KEY);
        String lastUsedLocale = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_USED_LOCALE_KEY);
        String defaultLocale = RubyI18nFoldingLocaleSettings.getInstance(this.myProject).getLocale();
        Comparator<LocaleEntry> localeComparator = I18nCreatePropertyDialog.getSuggestedLocaleComparator(this.myDictionary, lastUsedLocaleFile, lastUsedLocale, defaultLocale, this.myInitialKeys);
        return this.myPresentationToLocaleEntries.entrySet().stream().sorted(Map.Entry.comparingByValue(localeComparator).thenComparing(Map.Entry.comparingByKey())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private boolean isNewPropertyDialog() {
        return this.myInitialKeys.isEmpty();
    }

    public static @Unmodifiable Map<String, LocaleEntry> createPresentationToLocaleEntries(@NotNull List<? extends LocaleEntry> localeEntries) {
        if (localeEntries == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(8);
        }
        return ContainerUtil.map2Map(localeEntries, localeEntry -> new Pair((Object)I18nCreatePropertyDialog.getPresentation(localeEntry), localeEntry));
    }

    @NotNull
    public static String getSuggestedKey(@Nullable String translation) {
        String key = NamingConventions.toUnderscoreCase((String)translation).replaceAll("[^a-z0-9]", "_").replaceAll("_+", "_");
        String string = StringUtil.shortenTextWithEllipsis((String)StringUtil.trim((String)key, c -> c != '_'), (int)50, (int)0, (String)"");
        if (string == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String getPresentation(@NotNull LocaleEntry localeEntry) {
        if (localeEntry == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(10);
        }
        String string = localeEntry.getPresentableName() + " [" + localeEntry.getRelativeFilePath() + "]";
        if (string == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static Comparator<LocaleEntry> getSuggestedLocaleComparator(@NotNull I18nDictionary dictionary, @Nullable String lastUsedLocaleFile, @Nullable String lastUsedLocale, @NotNull String defaultLocale, @NotNull List<String> keys) {
        if (dictionary == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(12);
        }
        if (defaultLocale == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(13);
        }
        if (keys == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(14);
        }
        Set similarLocaleEntries = keys.stream().flatMap(key -> dictionary.getLocaleEntriesByKeyPrefix(StringUtil.substringBeforeLast((String)key, (String)".")).stream()).collect(Collectors.toSet());
        ToIntFunction<LocaleEntry> ranker = localeEntry -> {
            String locale = localeEntry.getLocale();
            if (locale == null) {
                return -1;
            }
            int rank = 0;
            if (similarLocaleEntries.contains(localeEntry)) {
                rank += 4;
            }
            if (keys.isEmpty() && I18nCreatePropertyDialog.getPresentation(localeEntry).equals(lastUsedLocaleFile)) {
                rank += 2;
            } else if (!keys.isEmpty() && locale.equals(lastUsedLocale)) {
                rank += 2;
            }
            if (locale.equals(defaultLocale)) {
                ++rank;
            }
            return rank;
        };
        Comparator<LocaleEntry> comparator = Comparator.comparingInt(ranker).reversed();
        if (comparator == null) {
            I18nCreatePropertyDialog.$$$reportNull$$$0(15);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationToLocaleEntries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialKeys";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localeEntries";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localeEntry";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocale";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/inspection/quickfixes/I18nCreatePropertyDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleTranslations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedLocaleComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationToLocaleEntries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedLocaleComparator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 11, 15 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/RBundle", I18nCreatePropertyDialog.class).getString("dialog.rails.i18n.create.property.info"), (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RBundle", I18nCreatePropertyDialog.class).getString("dialog.rails.i18n.create.property.key"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPropertyValuesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setFocusable(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myVariablesLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", I18nCreatePropertyDialog.class).getString("dialog.rails.i18n.create.property.variables"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVariablesField = jTextField = new JTextField();
        jTextField.setEditable(true);
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComponent jComponent = this.myPropertyKeyField;
        jPanel2.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

