/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.I18nFoldingSettings;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nResolveResult;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public final class I18nFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private static final Key<String> KEY = Key.create((String)"RAILS_I18N_VALUE");

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(1);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)root);
        final I18nDictionary dictionary = (I18nDictionary)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> I18nDictionary.forModule(module));
        if (!I18nProvider.isI18nSupportEnabled(module) || dictionary == null) {
            if (FoldingDescriptor.EMPTY_ARRAY == null) {
                I18nFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY_ARRAY;
        }
        final RubyI18nFoldingLocaleSettings settings = RubyI18nFoldingLocaleSettings.getInstance(root.getProject());
        final String locale = (String)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> I18nFoldingBuilder.getLocale(module, settings));
        final ArrayList descriptors = new ArrayList();
        RubyRecursiveElementVisitor visitor = new RubyRecursiveElementVisitor(this){

            public void visitRCall(@NotNull RCall rCall) {
                if (rCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(rCall.getCallType() instanceof I18nTranslateCallType)) {
                    super.visitRCall(rCall);
                    return;
                }
                for (PsiReference reference : rCall.getReferences()) {
                    String translation;
                    I18nTranslateReference translateRef = (I18nTranslateReference)reference;
                    PsiElement resolveElement = (PsiElement)ObjectUtils.doIfNotNull((Object)I18nFoldingBuilder.findResolveResult(translateRef, locale), ResolveResult::getElement);
                    if (resolveElement == null || StringUtil.isEmptyOrSpaces((String)(translation = I18nProvider.forElement(resolveElement).getTranslation(resolveElement)))) continue;
                    rCall.putUserData(KEY, (Object)StringUtil.shortenTextWithEllipsis((String)translation, (int)50, (int)0, (boolean)true));
                    descriptors.add(I18nFoldingBuilder.createFoldingDescriptor(rCall, new Object[]{settings, resolveElement.getContainingFile()}));
                    return;
                }
                String defaultTranslation = I18nTranslateCallType.getDefaultTranslationOption((RPossibleCall)rCall);
                if (StringUtil.isEmptyOrSpaces((String)defaultTranslation)) {
                    return;
                }
                rCall.putUserData(KEY, (Object)StringUtil.shortenTextWithEllipsis((String)defaultTranslation, (int)50, (int)0, (boolean)true));
                HashSet dependencies = ContainerUtil.newHashSet((Object[])new Object[]{settings});
                dictionary.getLocaleEntriesByLocale(locale).stream().map(LocaleEntry::getVirtualFile).forEach(dependencies::add);
                descriptors.add(I18nFoldingBuilder.createFoldingDescriptor(rCall, dependencies.toArray()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCall", "org/jetbrains/plugins/ruby/i18n/folding/I18nFoldingBuilder$1", "visitRCall"));
            }
        };
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> root.accept((PsiElementVisitor)visitor));
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    @NotNull
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(4);
        }
        String string = "\"" + (String)node.getPsi().getUserData(KEY) + "\"";
        if (string == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(6);
        }
        return I18nFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    @NotNull
    private static FoldingDescriptor createFoldingDescriptor(@NotNull RCall call, Object ... dependencies) {
        if (call == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (dependencies == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(8);
        }
        FoldingDescriptor descriptor = new FoldingDescriptor(call.getNode(), call.getTextRange(), null, (Set)ContainerUtil.newHashSet((Object[])dependencies));
        descriptor.setCanBeRemovedWhenCollapsed(true);
        FoldingDescriptor foldingDescriptor = descriptor;
        if (foldingDescriptor == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(9);
        }
        return foldingDescriptor;
    }

    @NotNull
    private static String getLocale(@NotNull Module module, @NotNull RubyI18nFoldingLocaleSettings settings) {
        String locale;
        Collection<LocaleEntry> localeEntries;
        List locales;
        if (module == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (!(locales = ContainerUtil.mapNotNull(localeEntries = I18nProvider.getAllLocaleEntries(module), LocaleEntry::getLocale)).contains(locale = settings.getLocale()) && !locales.isEmpty()) {
            locale = (String)locales.get(0);
        }
        String string = locale;
        if (string == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static ResolveResult findResolveResult(@NotNull I18nTranslateReference translateRef, @NotNull String locale) {
        if (translateRef == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (locale == null) {
            I18nFoldingBuilder.$$$reportNull$$$0(14);
        }
        Object[] resolveResults = translateRef.multiResolve(false);
        return (ResolveResult)ContainerUtil.find((Object[])resolveResults, result -> ((I18nResolveResult)((Object)result)).getLocaleEntry().getLocale().equals(locale));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/folding/I18nFoldingBuilder";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "translateRef";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/folding/I18nFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFoldingDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocale";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findResolveResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9, 12 -> new IllegalStateException(string);
        };
    }
}

