/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.actions.intention.i18n;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.I18nTranslateCallType;
import org.jetbrains.plugins.ruby.i18n.actions.intention.i18n.RailsI18nConfigAdapter;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.folding.RubyI18nFoldingLocaleSettings;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyI18nChangePreviewLocaleIntention
extends BaseElementAtCaretIntentionAction
implements DumbAware {
    @NotNull
    public String getText() {
        String string = RBundle.message((String)"ruby.intentions.i18n.change.preview.locale");
        if (string == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.intentions.i18n.change.preview.locale");
        if (string == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        RCall call;
        if (project == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(4);
        }
        if ((call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)element, RCall.class)) == null || !(call.getCallType() instanceof I18nTranslateCallType)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module != null && RubyI18nChangePreviewLocaleIntention.getAllLocales(module).count() > 1L;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Module module;
        if (project == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        RubyI18nFoldingLocaleSettings settings = RubyI18nFoldingLocaleSettings.getInstance(project);
        String currentLocale = settings.getLocale();
        List<LocaleDescriptor> descriptors = RubyI18nChangePreviewLocaleIntention.getAllLocaleDescriptors(module, currentLocale);
        JBPopup popup = RubyI18nChangePreviewLocaleIntention.createLocalePopup(descriptors);
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private static JBPopup createLocalePopup(@NotNull List<LocaleDescriptor> descriptors) {
        if (descriptors == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(8);
        }
        ColoredListCellRenderer<LocaleDescriptor> renderer = new ColoredListCellRenderer<LocaleDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends LocaleDescriptor> list, LocaleDescriptor descriptor, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                SimpleTextAttributes nameAttributes = descriptor.isCurrent() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SimpleTextAttributes infoAttributes = descriptor.isCurrent() ? SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                this.append(descriptor.getPresentableName(), nameAttributes);
                String additionalInfo = descriptor.getAdditionalInfo();
                if (additionalInfo != null) {
                    this.append(" [", infoAttributes);
                    this.append(additionalInfo, infoAttributes);
                    this.append("]", infoAttributes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RubyI18nChangePreviewLocaleIntention$1", "customizeCellRenderer"));
            }
        };
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(descriptors).setSelectedValue((Object)((LocaleDescriptor)ContainerUtil.find(descriptors, descriptor -> descriptor.isCurrent())), true).setRenderer((ListCellRenderer)renderer).setNamerForFiltering(descriptor -> descriptor.getPresentableName() + StringUtil.notNullize((String)descriptor.getAdditionalInfo())).setItemChosenCallback(Runnable::run).createPopup();
        if (jBPopup == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(9);
        }
        return jBPopup;
    }

    @Nullable
    private static RCall findCall(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(11);
        }
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        return (RCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, RCall.class, (boolean)false);
    }

    @NotNull
    private static Stream<String> getAllLocales(@NotNull Module module) {
        if (module == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(12);
        }
        I18nDictionary dictionary = (I18nDictionary)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> I18nProvider.getDictionary(module));
        Stream<String> stream = dictionary.getAllLocales().stream().filter(Objects::nonNull);
        if (stream == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    private static List<LocaleDescriptor> getAllLocaleDescriptors(@NotNull Module module, @NotNull String currentLocale) {
        if (module == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(14);
        }
        if (currentLocale == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(15);
        }
        ArrayList<LocaleDescriptor> descriptors = new ArrayList<LocaleDescriptor>();
        if (TrustedProjects.isProjectTrusted((Project)module.getProject()) && RailsUtil.isRailsGemAttached(module)) {
            descriptors.add(new LocaleDescriptor(RBundle.message((String)"ruby.intentions.i18n.change.preview.locale.rails.default"), () -> RailsI18nConfigAdapter.queryDefaultLocale(module, (Consumer<? super String>)((Consumer)defaultLocale -> RubyI18nChangePreviewLocaleIntention.setLocale(defaultLocale, module)))));
        }
        RubyI18nChangePreviewLocaleIntention.getAllLocales(module).map(tag -> {
            String presentableName = LocaleEntry.getPresentableName(tag);
            boolean current = tag.equals(currentLocale);
            return new LocaleDescriptor(presentableName, (String)tag, current, () -> RubyI18nChangePreviewLocaleIntention.setLocale(tag, module));
        }).sorted().forEachOrdered(descriptors::add);
        ArrayList<LocaleDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static void setLocale(@NotNull String locale, @NotNull Module module) {
        if (locale == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(17);
        }
        if (module == null) {
            RubyI18nChangePreviewLocaleIntention.$$$reportNull$$$0(18);
        }
        ReadAction.run(() -> {
            if (module.isDisposed()) {
                return;
            }
            Project project = module.getProject();
            RubyI18nFoldingLocaleSettings settings = RubyI18nFoldingLocaleSettings.getInstance(project);
            settings.setLocale(locale);
            DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)"RubyI18nChangePreviewLocaleIntention.setLocale");
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RubyI18nChangePreviewLocaleIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLocale";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RubyI18nChangePreviewLocaleIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalePopup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocales";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocaleDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLocalePopup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocales";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocaleDescriptors";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setLocale";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 17, 18 -> new IllegalArgumentException(string);
        };
    }

    private static final class LocaleDescriptor
    implements Comparable<LocaleDescriptor>,
    Runnable {
        @NotNull
        @Nls
        private final String myPresentableName;
        @Nullable
        @NlsSafe
        private final String myAdditionalInfo;
        private final boolean myCurrent;
        @NotNull
        private final Runnable myOnSelected;

        private LocaleDescriptor(@NotNull @Nls String presentableName, @NotNull Runnable onSelected) {
            if (presentableName == null) {
                LocaleDescriptor.$$$reportNull$$$0(0);
            }
            if (onSelected == null) {
                LocaleDescriptor.$$$reportNull$$$0(1);
            }
            this(presentableName, null, false, onSelected);
        }

        private LocaleDescriptor(@NotNull @Nls String presentableName, @Nullable String additionalInfo, boolean current, @NotNull Runnable onSelected) {
            if (presentableName == null) {
                LocaleDescriptor.$$$reportNull$$$0(2);
            }
            if (onSelected == null) {
                LocaleDescriptor.$$$reportNull$$$0(3);
            }
            this.myPresentableName = presentableName;
            this.myAdditionalInfo = additionalInfo;
            this.myCurrent = current;
            this.myOnSelected = onSelected;
        }

        @Nullable
        @NlsSafe
        public String getAdditionalInfo() {
            return this.myAdditionalInfo;
        }

        @NotNull
        @Nls
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                LocaleDescriptor.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void run() {
            this.myOnSelected.run();
        }

        @Override
        public int compareTo(@NotNull LocaleDescriptor other) {
            if (other == null) {
                LocaleDescriptor.$$$reportNull$$$0(5);
            }
            return Comparator.comparing(LocaleDescriptor::getPresentableName).thenComparing(Comparator.nullsFirst(Comparator.comparing(LocaleDescriptor::getAdditionalInfo))).compare(this, other);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onSelected";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RubyI18nChangePreviewLocaleIntention$LocaleDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RubyI18nChangePreviewLocaleIntention$LocaleDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

