/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.actions.intention.i18n;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

final class RailsI18nConfigAdapter {
    private static final Logger LOG = Logger.getInstance(RailsI18nConfigAdapter.class);

    RailsI18nConfigAdapter() {
    }

    public static void queryDefaultLocale(final @NotNull Module module, final @NotNull Consumer<? super String> defaultLocaleConsumer) {
        Sdk sdk;
        if (module == null) {
            RailsI18nConfigAdapter.$$$reportNull$$$0(0);
        }
        if (defaultLocaleConsumer == null) {
            RailsI18nConfigAdapter.$$$reportNull$$$0(1);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null) {
            return;
        }
        Project project = module.getProject();
        Task.Backgroundable task = new Task.Backgroundable(project, RBundle.message((String)"ruby.intentions.i18n.rails.config.adapter.title")){

            public void run(@NotNull ProgressIndicator indicator) {
                String defaultLocale;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((defaultLocale = RailsI18nConfigAdapter.queryDefaultLocale(sdk, module)) == null) {
                    return;
                }
                defaultLocaleConsumer.consume((Object)defaultLocale);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RailsI18nConfigAdapter$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private static VirtualFile getRailsApplicationRoot(@NotNull Module module) {
        RailsApp railsApp;
        if (module == null) {
            RailsI18nConfigAdapter.$$$reportNull$$$0(2);
        }
        if ((railsApp = RailsApp.fromModule(module)) == null) {
            return null;
        }
        return railsApp.getRailsApplicationRoot();
    }

    @Nullable
    private static String queryDefaultLocale(@NotNull Sdk sdk, @NotNull Module module) {
        if (sdk == null) {
            RailsI18nConfigAdapter.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RailsI18nConfigAdapter.$$$reportNull$$$0(4);
        }
        try {
            VirtualFile workingDir = RailsI18nConfigAdapter.getRailsApplicationRoot(module);
            if (workingDir == null) {
                LOG.warn("Cannot query for default locale from non-Rails module");
                return null;
            }
            ProcessOutput output2 = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "rails").withModule(module)).withArguments("runner", "puts I18n.default_locale")).withWorkingDir(workingDir)).executeScript();
            if (output2 == null) {
                LOG.warn("Error querying for default locale from Rails");
                return null;
            }
            if (!output2.checkSuccess(LOG)) {
                return null;
            }
            List lines = output2.getStdoutLines();
            if (!lines.isEmpty()) {
                return ((String)lines.get(0)).trim();
            }
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLocaleConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/actions/intention/i18n/RailsI18nConfigAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queryDefaultLocale";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRailsApplicationRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

