/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.EmptyCallType;

public class I18nTranslateCallType
extends EmptyCallType {
    @NotNull
    private static final String OPTION_DEFAULT = "default";
    @NotNull
    private static final String OPTION_SCOPE = "scope";

    I18nTranslateCallType(@NonNls String commandName) {
        super(commandName);
    }

    public boolean isCompatible(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            I18nTranslateCallType.$$$reportNull$$$0(0);
        }
        return !possibleCall.getArguments().isEmpty();
    }

    @NotNull
    public static List<String> getScopeOption(@NotNull RPossibleCall possibleCall) {
        List<? extends RPsiElement> elements;
        if (possibleCall == null) {
            I18nTranslateCallType.$$$reportNull$$$0(1);
        }
        if ((elements = RubyInterpretUtil.getOptionValueElements(possibleCall, OPTION_SCOPE)) == null || !I18nTranslateCallType.isSimpleScopeOption(possibleCall)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                I18nTranslateCallType.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = ContainerUtil.map(elements, RubyInterpretUtil::evaluateStringOrSymbolElement);
        if (list == null) {
            I18nTranslateCallType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static String getDefaultTranslationOption(@NotNull RPossibleCall possibleCall) {
        List<? extends RPsiElement> elements;
        RPsiElement element;
        if (possibleCall == null) {
            I18nTranslateCallType.$$$reportNull$$$0(4);
        }
        return (element = (RPsiElement)ContainerUtil.getLastItem(elements = RubyInterpretUtil.getOptionValueElements(possibleCall, OPTION_DEFAULT))) instanceof RStringLiteral ? RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)element) : null;
    }

    public static @Unmodifiable @NotNull List<PsiElement> getDefaultKeysOptionElements(@NotNull RPossibleCall possibleCall) {
        List<? extends RPsiElement> elements;
        if (possibleCall == null) {
            I18nTranslateCallType.$$$reportNull$$$0(5);
        }
        if ((elements = RubyInterpretUtil.getOptionValueElements(possibleCall, OPTION_DEFAULT)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                I18nTranslateCallType.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ContainerUtil.filter(elements, RSymbol.class::isInstance);
        if (list == null) {
            I18nTranslateCallType.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static boolean isSimpleScopeOption(@NotNull RPossibleCall possibleCall) {
        List<? extends RPsiElement> elements;
        if (possibleCall == null) {
            I18nTranslateCallType.$$$reportNull$$$0(8);
        }
        return (elements = RubyInterpretUtil.getOptionValueElements(possibleCall, OPTION_SCOPE)) == null || elements.stream().allMatch(RubyPsiUtil::isSimpleStringOrSymbol);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nTranslateCallType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nTranslateCallType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeysOptionElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getScopeOption";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTranslationOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultKeysOptionElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleScopeOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

