/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nCachedDictionaryProvider;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.findUsages.RubyI18nFindUsagesHandler;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.refactoring.safeDelete.RubyI18nSafeDeleteSupport;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.module.RubyModuleSettings;

public abstract class I18nProvider {
    public static final I18nProvider NULL_PROVIDER = new I18nProvider(){

        @Override
        @Nullable
        public LocaleEntry createLocaleEntry(@NotNull PsiFile psiFile, @NotNull String localesRootPath) {
            if (psiFile == null) {
                1.$$$reportNull$$$0(0);
            }
            if (localesRootPath == null) {
                1.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        public boolean isTranslationElement(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(2);
            }
            return false;
        }

        @Override
        @Nullable
        public String getTranslation(@Nullable PsiElement element) {
            return null;
        }

        @Override
        @Nullable
        public String getKeyText(@Nullable PsiElement element) {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getKeyElement(@Nullable PsiElement element) {
            return null;
        }

        @Override
        @Nullable
        public String getFullKey(@Nullable PsiElement element) {
            return null;
        }

        @Override
        @NotNull
        public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(3);
            }
            FindUsagesHandler findUsagesHandler = FindUsagesHandler.NULL_HANDLER;
            if (findUsagesHandler == null) {
                1.$$$reportNull$$$0(4);
            }
            return findUsagesHandler;
        }

        @Override
        public boolean canBeTranslationReferenceTarget(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(5);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localesRootPath";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFindUsagesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createLocaleEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isTranslationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFindUsagesHandler";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeTranslationReferenceTarget";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    };
    public static final LanguageExtension<I18nProvider> EXTENSION = new LanguageExtension("org.jetbrains.plugins.ruby.i18n.i18nProvider");
    private static final String LOCALES = "locales";
    private static final String I18N = "i18n";

    @Nullable
    public abstract LocaleEntry createLocaleEntry(@NotNull PsiFile var1, @NotNull String var2);

    @NotNull
    public @Unmodifiable List<?> getDictionaryDependencies(@NotNull Module module) {
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(0);
        }
        Project project = module.getProject();
        List list = ContainerUtil.append(RubyModificationTrackers.getRailsSettingsModificationTrackers(project, module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        if (list == null) {
            I18nProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    public abstract boolean isTranslationElement(@NotNull PsiElement var1);

    @Nullable
    public abstract String getTranslation(@Nullable PsiElement var1);

    @Nullable
    public abstract String getKeyText(@Nullable PsiElement var1);

    @Nullable
    public abstract PsiElement getKeyElement(@Nullable PsiElement var1);

    @Nullable
    public abstract String getFullKey(@Nullable PsiElement var1);

    public abstract boolean canBeTranslationReferenceTarget(@NotNull PsiElement var1);

    @NotNull
    public RubyI18nSafeDeleteSupport createSafeDeleteSupport() {
        RubyI18nSafeDeleteSupport rubyI18nSafeDeleteSupport = RubyI18nSafeDeleteSupport.NULL_SUPPORT;
        if (rubyI18nSafeDeleteSupport == null) {
            I18nProvider.$$$reportNull$$$0(2);
        }
        return rubyI18nSafeDeleteSupport;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element) {
        if (element == null) {
            I18nProvider.$$$reportNull$$$0(3);
        }
        return new RubyI18nFindUsagesHandler(element);
    }

    @NotNull
    public static I18nProvider forElement(@NotNull PsiElement element) {
        I18nProvider provider;
        if (element == null) {
            I18nProvider.$$$reportNull$$$0(4);
        }
        I18nProvider i18nProvider = (provider = (I18nProvider)EXTENSION.forLanguage(element.getLanguage())) == null ? NULL_PROVIDER : provider;
        if (i18nProvider == null) {
            I18nProvider.$$$reportNull$$$0(5);
        }
        return i18nProvider;
    }

    @NotNull
    public static Collection<LocaleEntry> getAllLocaleEntries(@NotNull Module module) {
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(6);
        }
        Collection<LocaleEntry> collection = I18nProvider.getDictionary(module).getAllLocaleEntries();
        if (collection == null) {
            I18nProvider.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static List<LocaleEntry> getAllLocaleFiles(@NotNull List<? extends VirtualFile> localeRoots, @NotNull Module module) {
        if (localeRoots == null) {
            I18nProvider.$$$reportNull$$$0(8);
        }
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(9);
        }
        if (localeRoots.isEmpty()) {
            List<LocaleEntry> list = Collections.emptyList();
            if (list == null) {
                I18nProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<LocaleEntry> localeFiles = new ArrayList<LocaleEntry>();
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        for (VirtualFile virtualFile : localeRoots) {
            ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().iterateContentUnderDirectory(virtualFile, fileOrDir -> {
                if (!fileOrDir.isDirectory()) {
                    PsiFile psiFile = psiManager.findFile(fileOrDir);
                    if (psiFile == null) {
                        return true;
                    }
                    I18nProvider provider = I18nProvider.forElement((PsiElement)psiFile);
                    ContainerUtil.addIfNotNull((Collection)localeFiles, (Object)provider.createLocaleEntry(psiFile, localeRoot.getPath()));
                }
                return true;
            });
        }
        ArrayList<LocaleEntry> arrayList = localeFiles;
        if (arrayList == null) {
            I18nProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public static boolean isLocaleFile(@NotNull PsiFile file) {
        if (file == null) {
            I18nProvider.$$$reportNull$$$0(12);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            boolean isLocaleFile;
            Project project = file.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            boolean bl = isLocaleFile = module != null && I18nProvider.isLocaleFileImpl(module, file);
            if (module == null || DumbService.isDumb((Project)project)) {
                return CachedValueProvider.Result.create((Object)isLocaleFile, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            }
            ArrayList dependencies = new ArrayList(RubyModificationTrackers.getRailsSettingsModificationTrackers(project, module));
            dependencies.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            return CachedValueProvider.Result.create((Object)isLocaleFile, dependencies);
        });
    }

    @NotNull
    public static List<VirtualFile> getLocalesRoot(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                I18nProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ArrayList<String> i18nFolders = new ArrayList<String>(RubyModuleSettings.getInstance(module).getI18nFolders());
        if (i18nFolders.isEmpty()) {
            if (RailsFacetUtil.hasRailsSupport(module)) {
                for (VirtualFile railsLocalesFolder : RailsPaths.getInstance(module).findFiles("config/locales")) {
                    result.add(railsLocalesFolder);
                    i18nFolders.add(railsLocalesFolder.getPath());
                }
            } else {
                for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile localesFile;
                    VirtualFile i18nFile = file.findChild(I18N);
                    if (i18nFile != null) {
                        result.add(i18nFile);
                        i18nFolders.add(i18nFile.getPath());
                    }
                    if ((localesFile = file.findChild(LOCALES)) == null) continue;
                    result.add(localesFile);
                    i18nFolders.add(localesFile.getPath());
                }
            }
            RubyModuleSettings.getInstance(module).setI18nFolders(i18nFolders);
        } else {
            TempFileSystem fileSystem = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance() : LocalFileSystem.getInstance();
            for (String i18nFolder : i18nFolders) {
                VirtualFile i18nFile = fileSystem.findFileByPath(i18nFolder);
                if (i18nFile == null) continue;
                result.add(i18nFile);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            I18nProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static I18nDictionary createDictionary(@NotNull Module module) {
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(15);
        }
        List<VirtualFile> localesRoots = I18nProvider.getLocalesRoot(module);
        final List<LocaleEntry> entries = I18nProvider.getAllLocaleFiles(localesRoots, module);
        final MultiMap localeToEntryMap = MultiMap.createSet();
        final MultiMap keyToEntryMap = MultiMap.createSet();
        final MultiMap keyToLocaleMap = MultiMap.createSet();
        for (LocaleEntry localeEntry : entries) {
            String locale = localeEntry.getLocale();
            if (locale == null) continue;
            localeToEntryMap.putValue((Object)locale, (Object)localeEntry);
            localeEntry.getAllKeys().forEach(key -> {
                keyToEntryMap.putValue(key, (Object)localeEntry);
                keyToLocaleMap.putValue(key, (Object)locale);
            });
        }
        return new I18nDictionary(){

            @Override
            @NotNull
            public Collection<String> getAllLocales() {
                Set set = localeToEntryMap.keySet();
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            public Collection<String> getAllKeys() {
                Set set = keyToLocaleMap.keySet();
                if (set == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getAllLocaleEntries() {
                Collection collection = entries;
                if (collection == null) {
                    2.$$$reportNull$$$0(2);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<String> getLocalesByKey(@Nullable String key) {
                Collection collection = keyToLocaleMap.get((Object)key);
                if (collection == null) {
                    2.$$$reportNull$$$0(3);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByKey(@Nullable String key) {
                Collection collection = keyToEntryMap.get((Object)key);
                if (collection == null) {
                    2.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByKeyPrefix(@Nullable String keyPrefix) {
                if (keyPrefix == null) {
                    Set<LocaleEntry> set = Collections.emptySet();
                    if (set == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return set;
                }
                Collection collection = this.getAllKeys().stream().filter(key -> key.startsWith(keyPrefix)).flatMap(key -> keyToEntryMap.get(key).stream()).collect(Collectors.toSet());
                if (collection == null) {
                    2.$$$reportNull$$$0(6);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<LocaleEntry> getLocaleEntriesByLocale(@Nullable String locale) {
                Collection collection = localeToEntryMap.get((Object)locale);
                if (collection == null) {
                    2.$$$reportNull$$$0(7);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllLocales";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllKeys";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllLocaleEntries";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocalesByKey";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByKey";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByKeyPrefix";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocaleEntriesByLocale";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isI18nSupportEnabled(@Nullable Module module) {
        return module != null && !I18nProvider.getLocalesRoot(module).isEmpty();
    }

    public static I18nDictionary getDictionary(@NotNull Module module) {
        Project project;
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(16);
        }
        return DumbService.isDumb((Project)(project = module.getProject())) ? (I18nDictionary)new I18nCachedDictionaryProvider(module).compute().getValue() : (I18nDictionary)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new I18nCachedDictionaryProvider(module));
    }

    private static boolean isLocaleFileImpl(@NotNull Module module, @NotNull PsiFile file) {
        VirtualFile vFile;
        if (module == null) {
            I18nProvider.$$$reportNull$$$0(17);
        }
        if (file == null) {
            I18nProvider.$$$reportNull$$$0(18);
        }
        if ((vFile = file.getVirtualFile()) == null) {
            return false;
        }
        for (VirtualFile localeFile : I18nProvider.getLocalesRoot(module)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)localeFile, (VirtualFile)vFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 7, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localeRoots";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionaryDependencies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeDeleteSupport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocaleEntries";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLocaleFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalesRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocaleEntries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllLocaleFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isLocaleFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDictionary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDictionary";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLocaleFileImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 7, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

