/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.plugins.ruby.i18n.dictionary.I18nDictionary;
import org.jetbrains.plugins.ruby.i18n.locales.LocaleEntry;
import org.jetbrains.plugins.ruby.i18n.references.I18nTranslateReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class I18nDocumentationProvider
extends AbstractDocumentationProvider {
    @Nls
    public String generateDoc(PsiElement targetElement, @Nullable PsiElement originalElement) {
        I18nProvider provider = I18nProvider.forElement(targetElement);
        if (provider.isTranslationElement(targetElement)) {
            return I18nDocumentationProvider.getDocumentation(provider, targetElement, originalElement);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (object instanceof RubyLookupElement) {
            RubyLookupElement lookupElement = (RubyLookupElement)object;
            if (module != null) {
                String key = lookupElement.getLookupString();
                I18nDictionary dictionary = I18nProvider.getDictionary(module);
                Collection<LocaleEntry> locales = dictionary.getLocaleEntriesByKey(key);
                if (!locales.isEmpty()) {
                    return locales.iterator().next().getRecord(key);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getDocumentation(@NotNull I18nProvider provider, @NotNull PsiElement element, @Nullable PsiElement originalElement) {
        I18nDictionary dictionary;
        if (provider == null) {
            I18nDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (element == null) {
            I18nDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((dictionary = I18nDictionary.forElement(element)) == null) {
            return null;
        }
        Set<String> keys = I18nDocumentationProvider.getFullKeys(provider, element, originalElement);
        if (keys.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(RBundle.message((String)"rails.i18n.property.key")).append(" ");
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            RubyDocumentationMarkupUtil.appendBoldCode(sb, it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("<hr>");
        sb.append("<h2>");
        sb.append(RBundle.message((String)"doc.rails.i18n.available.translations")).append(":");
        sb.append("</h2>");
        List localeEntries = keys.stream().flatMap(key -> dictionary.getLocaleEntriesByKey((String)key).stream()).collect(Collectors.toList());
        MultiMap localeEntriesByName = ContainerUtil.groupBy(localeEntries, LocaleEntry::getPresentableName);
        for (Map.Entry entry : localeEntriesByName.entrySet()) {
            List<String> translations = keys.stream().flatMap(key -> ((Collection)entry.getValue()).stream().map(localeEntry -> localeEntry.getRecord((String)key))).filter(Objects::nonNull).map(provider::getTranslation).filter(StringUtil::isNotEmpty).sorted().toList();
            if (translations.isEmpty()) continue;
            RubyDocumentationMarkupUtil.appendBold(sb, (String)entry.getKey());
            sb.append("<br>");
            translations.forEach(translation -> sb.append((String)translation).append("<br>"));
        }
        return sb.toString();
    }

    @NotNull
    private static Set<String> getFullKeys(@NotNull I18nProvider provider, @NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (provider == null) {
            I18nDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (element == null) {
            I18nDocumentationProvider.$$$reportNull$$$0(3);
        }
        TreeSet<String> keys = new TreeSet<String>();
        RCall call = RubyPsiUtil.getCoveringRCall(originalElement);
        if (call != null) {
            for (PsiReference reference : call.getReferences()) {
                if (!(reference instanceof I18nTranslateReference) || !PsiTreeUtil.isAncestor((PsiElement)((I18nTranslateReference)reference).getStringOrSymbol(), (PsiElement)originalElement, (boolean)false)) continue;
                keys.addAll(((I18nTranslateReference)reference).getFullKeys());
            }
        }
        if (keys.isEmpty()) {
            Optional.ofNullable(provider.getFullKey(element)).ifPresent(keys::add);
        }
        TreeSet<String> treeSet = keys;
        if (treeSet == null) {
            I18nDocumentationProvider.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/i18n/I18nDocumentationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/i18n/I18nDocumentationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFullKeys";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

