/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class ShowGemEnvironmentAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowGemEnvironmentAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        boolean isEnabled = sdk != null && GemManager.getInstance().isRegistered(sdk);
        e.getPresentation().setEnabled(isEnabled);
        e.getPresentation().setVisible(isEnabled || PlatformUtils.isRubyMine());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowGemEnvironmentAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowGemEnvironmentAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        final Module module = RModuleUtil.getInstance().getModule(dataContext);
        assert (module != null);
        final Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null);
        final String rubyMineEnvironmentInfo = ShowGemEnvironmentAction.collectRMGemsEnvironment(sdk, module);
        final Project project = module.getProject();
        Task.Backgroundable task = new Task.Backgroundable(this, project, RBundle.message((String)"gems.running.command.gem.environment.title")){

            public void run(@NotNull ProgressIndicator indicator) {
                String output2;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                output2 = (output2 = GemRunner.getRawEnvironment(module, sdk)) != null ? output2.replaceAll("RubyGems Environment:(\r)?\n", "") : null;
                output2 = output2 != null ? output2.replace("    - ", "  ") : null;
                String processedOutput = output2 = output2 != null ? output2.replace("  - ", "") : null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (processedOutput != null) {
                        Messages.showDialog((Project)project, (String)"", (String)RBundle.message((String)"gems.running.command.gem.environment.dialog.title"), (String)(processedOutput + rubyMineEnvironmentInfo), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (int)0, null);
                    } else {
                        Messages.showErrorDialog((String)RBundle.message((String)"gems.running.command.gem.environment.dialog.error.message"), (String)RBundle.message((String)"gems.running.command.gem.environment.dialog.title"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/util/ShowGemEnvironmentAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @NlsSafe
    private static String collectRMGemsEnvironment(@NotNull Sdk sdk, @NotNull Module module) {
        if (sdk == null) {
            ShowGemEnvironmentAction.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ShowGemEnvironmentAction.$$$reportNull$$$0(4);
        }
        StringBuilder buff = new StringBuilder();
        buff.append('\n');
        buff.append("----------------------");
        buff.append('\n');
        String rubyInterpreterPath = sdk.getHomePath();
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        buff.append("IDE: ").append(appInfo.getFullApplicationName()).append(", build #").append(appInfo.getBuild().asString()).append('\n');
        buff.append("OS: ").append(System.getProperty("os.name")).append(' ').append(SystemInfo.OS_VERSION).append('[').append(SystemInfo.OS_ARCH).append(']').append('\n');
        buff.append("Java: ").append(SystemInfo.JAVA_RUNTIME_VERSION).append('\n');
        buff.append("RubyMine SDK Environment:").append('\n');
        buff.append("Sdk: ").append(sdk.getName()).append('\n');
        buff.append("Sdk Version: ").append(sdk.getVersionString()).append('\n');
        buff.append("Ruby Interpreter: ").append(rubyInterpreterPath).append('\n');
        buff.append("RVM Sdk: ");
        buff.append(RubySdkUtil.getRubySdkAdditionalData(sdk).getVersionManagerSdkAdditionalData().getPresentableText());
        buff.append("Sdk Language Level: ").append(RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk).getShortName()).append('\n');
        buff.append("Sdk Load Path:").append('\n');
        VirtualFile[] roots = RubySdkUtil.getSdkRoots(sdk);
        if (roots.length == 0) {
            buff.append("<empty>").append('\n');
        } else {
            for (VirtualFile root : roots) {
                buff.append("     ").append(ShowGemEnvironmentAction.shortenPath(root.getPath())).append('\n');
            }
        }
        buff.append("Sdk Gem paths: ").append('\n');
        Collection<String> gemRootUrls = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
        if (gemRootUrls.isEmpty()) {
            buff.append("<empty>").append('\n');
        } else {
            for (String gemRootUrl : gemRootUrls) {
                buff.append("     ").append(ShowGemEnvironmentAction.shortenPath(gemRootUrl)).append('\n');
            }
        }
        buff.append("Gems used for '").append(module.getName()).append("':\n");
        for (GemInfo gem : RubyProjectGemSearchService.Companion.getAllGems(module)) {
            String url = gem.getUrl();
            buff.append("     ").append(gem.getName()).append(" (").append(gem.getVersion()).append(")\n         ").append(ShowGemEnvironmentAction.shortenPath(url)).append("\n");
        }
        return buff.toString();
    }

    private static String shortenPath(String url) {
        return url.replace("file://", "").replace(SystemProperties.getUserHome(), "~");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/ShowGemEnvironmentAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/ShowGemEnvironmentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectRMGemsEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

