/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.util.containers.SortedList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.workspace.storage.RubyGemBoxEntity;
import org.jetbrains.plugins.ruby.library.RubyLibraryProperties;
import org.jetbrains.plugins.ruby.utils.SmartCancellationChecker;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013J\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eR*\u0010\u0006\u001a\u001e\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService$SearchContext;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lorg/jetbrains/plugins/ruby/gem/GemInfo;", "findGem", "module", "Lcom/intellij/openapi/module/Module;", "dependency", "Lorg/jetbrains/plugins/ruby/gem/GemDependency;", "findGems", "predicate", "Ljava/util/function/Predicate;", "name", "", "version", "getAllGems", "SearchContext", "Companion", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubyProjectGemSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyProjectGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,283:1\n774#2:284\n865#2,2:285\n774#2:287\n865#2,2:288\n774#2:290\n865#2,2:291\n1869#2,2:304\n4225#3,11:293\n2275#4,2:306\n*S KotlinDebug\n*F\n+ 1 RubyProjectGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService\n*L\n111#1:284\n111#1:285,2\n122#1:287\n122#1:288,2\n170#1:290\n170#1:291,2\n212#1:304,2\n195#1:293,11\n85#1:306,2\n*E\n"})
public final class RubyProjectGemSearchService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<SearchContext, List<GemInfo>> cache;

    public RubyProjectGemSearchService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        MessageBusConnection applicationConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic<GemManager.GemSetListener> topic = GemManager.GEMSET_CHANGED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GEMSET_CHANGED_TOPIC");
        applicationConnection.subscribe(topic, arg_0 -> RubyProjectGemSearchService._init_$lambda$0(this, arg_0));
        MessageBusConnection projectConnection = project.getMessageBus().connect((Disposable)this);
        projectConnection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!event.getChanges(LibraryEntity.class).isEmpty() || !event.getChanges(RubyGemBoxEntity.class).isEmpty()) {
                    cache.invalidateAll();
                } else if (!event.getChanges(ModuleEntity.class).isEmpty()) {
                    cache.invalidateAll();
                }
            }
        });
        Topic topic2 = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        projectConnection.subscribe(topic2, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                cache.invalidateAll();
            }
        });
        Topic<GemManager.ModuleGemsListener> topic3 = GemManager.MODULE_GEMS_CHANGED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"MODULE_GEMS_CHANGED_TOPIC");
        projectConnection.subscribe(topic3, arg_0 -> RubyProjectGemSearchService._init_$lambda$1(this, arg_0));
        Topic<GemRequirementsHolder.RequirementsChangedListener> topic4 = GemRequirementsHolder.GEM_REQUIREMENTS_CHANGED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"GEM_REQUIREMENTS_CHANGED_TOPIC");
        projectConnection.subscribe(topic4, arg_0 -> RubyProjectGemSearchService._init_$lambda$2(this, arg_0));
        VirtualFileManager.getInstance().addAsyncFileListener(arg_0 -> RubyProjectGemSearchService._init_$lambda$3(this, arg_0), (Disposable)this);
        LowMemoryWatcher.register(() -> RubyProjectGemSearchService._init_$lambda$4(this), (Disposable)((Disposable)this));
    }

    @Nullable
    public final GemInfo findGem(@NotNull Module module, @NotNull GemDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return (GemInfo)CollectionsKt.firstOrNull(this.findGems(module, dependency));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull Module module, @NotNull GemDependency dependency) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Iterable $this$filter$iv = this.findGems(module, string);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo p0 = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!dependency.isSatisfied(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull Module module, @NotNull Predicate<GemInfo> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = this.getAllGems(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo p0 = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!predicate.test(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final GemInfo findGem(@NotNull Module module, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (GemInfo)CollectionsKt.firstOrNull(this.findGems(module, name));
    }

    @NotNull
    public final List<GemInfo> findGems(@NotNull Module module, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(module, name));
        if (cachedGems != null) {
            List<GemInfo> list = Collections.unmodifiableList(cachedGems);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }
        List<GemInfo> gems = this.findGems(module, arg_0 -> RubyProjectGemSearchService.findGems$lambda$1(name, arg_0));
        this.cache.put((Object)new SearchContext(module, name), gems);
        return gems;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GemInfo findGem(@NotNull Module module, @NotNull String name, @Nullable String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (module.isDisposed()) {
            return null;
        }
        if (version == null) {
            return this.findGem(module, name);
        }
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(module, name, version));
        if (cachedGems != null) {
            return (GemInfo)CollectionsKt.firstOrNull((List)cachedGems);
        }
        Iterable $this$filter$iv = this.findGems(module, name);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo it = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)version)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List gems = (List)destination$iv$iv;
        this.cache.put((Object)new SearchContext(module, name, version), (Object)gems);
        return (GemInfo)CollectionsKt.firstOrNull((List)gems);
    }

    @NotNull
    public final List<GemInfo> getAllGems(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(module));
        if (cachedGems != null) {
            List<GemInfo> list = Collections.unmodifiableList(cachedGems);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }
        SortedList gems = new SortedList(RubyGemSearchUtil.GEM_COMPARATOR);
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null) {
            SmartCancellationChecker checker = new SmartCancellationChecker(0, 1, null);
            OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
            Object[] $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : objectArray) {
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (LibraryOrderEntry entry : (List)destination$iv$iv) {
                GemInfo gemInfo;
                checker.checkCancelled();
                Library library = entry.getLibrary();
                LibraryEx libraryEx = library instanceof LibraryEx ? (LibraryEx)library : null;
                Object object = libraryEx != null ? libraryEx.getProperties() : null;
                RubyLibraryProperties properties = object instanceof RubyLibraryProperties ? (RubyLibraryProperties)((Object)object) : null;
                if (properties == null || (gemInfo = GemInfo.create(sdk, properties)) == null) continue;
                gems.add((Object)gemInfo);
            }
        }
        Iterable $this$forEach$iv = ModuleGemProvider.EP_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleGemProvider moduleGemProvider = (ModuleGemProvider)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            gems.addAll((Collection)moduleGemProvider.getGemsList(module));
        }
        this.cache.put((Object)new SearchContext(module), (Object)gems);
        List<GemInfo> list = Collections.unmodifiableList((List)gems);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    private static final void _init_$lambda$0(RubyProjectGemSearchService this$0, Set it) {
        this$0.cache.invalidateAll();
    }

    private static final void _init_$lambda$1(RubyProjectGemSearchService this$0, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cache.invalidateAll();
    }

    private static final void _init_$lambda$2(RubyProjectGemSearchService this$0, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cache.invalidateAll();
    }

    private static final AsyncFileListener.ChangeApplier _init_$lambda$3(RubyProjectGemSearchService this$0, List events) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            Sequence $this$none$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)events), RubyProjectGemSearchService::lambda$3$0);
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!(BundleConfig.isConfig(it) || BundlerUtil.isBundlerDir(it))) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(this$0){
            final /* synthetic */ RubyProjectGemSearchService this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterVfsChange() {
                RubyProjectGemSearchService.access$getCache$p(this.this$0).invalidateAll();
            }
        };
    }

    private static final VirtualFile lambda$3$0(VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFile();
    }

    private static final void _init_$lambda$4(RubyProjectGemSearchService this$0) {
        this$0.cache.invalidateAll();
    }

    private static final boolean findGems$lambda$1(String $name, GemInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    @JvmStatic
    @NotNull
    public static final RubyProjectGemSearchService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService;", "project", "Lcom/intellij/openapi/project/Project;", "findGem", "Lorg/jetbrains/plugins/ruby/gem/GemInfo;", "module", "Lcom/intellij/openapi/module/Module;", "dependency", "Lorg/jetbrains/plugins/ruby/gem/GemDependency;", "findGems", "", "predicate", "Ljava/util/function/Predicate;", "name", "", "version", "getAllGems", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nRubyProjectGemSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyProjectGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,283:1\n30#2,2:284\n*S KotlinDebug\n*F\n+ 1 RubyProjectGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService$Companion\n*L\n231#1:284,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RubyProjectGemSearchService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RubyProjectGemSearchService> serviceClass$iv = RubyProjectGemSearchService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RubyProjectGemSearchService)object;
        }

        @Nullable
        public final GemInfo findGem(@NotNull Module module, @NotNull GemDependency dependency) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGem(module, dependency);
        }

        @NotNull
        public final List<GemInfo> findGems(@NotNull Module module, @NotNull GemDependency dependency) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGems(module, dependency);
        }

        @NotNull
        public final List<GemInfo> findGems(@NotNull Module module, @NotNull Predicate<GemInfo> predicate) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGems(module, predicate);
        }

        @Nullable
        public final GemInfo findGem(@NotNull Module module, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGem(module, name);
        }

        @NotNull
        public final List<GemInfo> findGems(@NotNull Module module, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGems(module, name);
        }

        @Nullable
        public final GemInfo findGem(@NotNull Module module, @NotNull String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).findGem(module, name, version);
        }

        @NotNull
        public final List<GemInfo> getAllGems(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).getAllGems(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyProjectGemSearchService$SearchContext;", "", "module", "Lcom/intellij/openapi/module/Module;", "name", "", "version", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;)V", "(Lcom/intellij/openapi/module/Module;)V", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ruby.backend"})
    private static final class SearchContext {
        @NotNull
        private final Module module;
        @Nullable
        private final String name;
        @Nullable
        private final String version;

        public SearchContext(@NotNull Module module, @Nullable String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.name = name;
            this.version = version;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public SearchContext(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this(module, null, null);
        }

        public SearchContext(@NotNull Module module, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(module, name, null);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final SearchContext copy(@NotNull Module module, @Nullable String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new SearchContext(module, name, version);
        }

        public static /* synthetic */ SearchContext copy$default(SearchContext searchContext, Module module, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                module = searchContext.module;
            }
            if ((n & 2) != 0) {
                string = searchContext.name;
            }
            if ((n & 4) != 0) {
                string2 = searchContext.version;
            }
            return searchContext.copy(module, string, string2);
        }

        @NotNull
        public String toString() {
            return "SearchContext(module=" + this.module + ", name=" + this.name + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result = this.module.hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchContext)) {
                return false;
            }
            SearchContext searchContext = (SearchContext)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)searchContext.module)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)searchContext.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)searchContext.version);
        }
    }
}

