/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchService;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class RubyGemSearchUtil {
    public static final Comparator<GemInfo> GEM_COMPARATOR = Comparator.comparing(GemInfo::getName).thenComparing(GemInfo::getVersion, VersionComparatorUtil.COMPARATOR.reversed());

    private RubyGemSearchUtil() {
    }

    @Nullable
    public static GemInfo findGem(@NotNull Collection<? extends GemInfo> gems, @NotNull Predicate<GemInfo> predicate) {
        if (gems == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(0);
        }
        if (predicate == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(1);
        }
        return gems.stream().filter(predicate).min(GEM_COMPARATOR).orElse(null);
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName) {
        if (gemName == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(2);
        }
        return RubyGemSearchUtil.findGem(module, sdk, gemName, null);
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName, @Nullable String gemVersion) {
        if (gemName == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            return null;
        }
        List<Sdk> sdks = module != null ? RbenvGemsetManager.getCurrentGemsetSdks(sdk, module) : List.of(sdk);
        return (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(sdks, gemName, gemVersion));
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module, @Nullable Sdk sdk, @NotNull GemDependency dependency) {
        if (dependency == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            return null;
        }
        List<Sdk> sdks = module != null ? RbenvGemsetManager.getCurrentGemsetSdks(sdk, module) : List.of(sdk);
        return (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(sdks, dependency::isSatisfied));
    }

    @Nullable
    public static GemInfo findGem(@Nullable Module module, @Nullable Sdk sdk, @NotNull Predicate<GemInfo> predicate) {
        if (predicate == null) {
            RubyGemSearchUtil.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            return null;
        }
        List<Sdk> sdks = module != null ? RbenvGemsetManager.getCurrentGemsetSdks(sdk, module) : List.of(sdk);
        return (GemInfo)ContainerUtil.getFirstItem(RubyGemSearchService.getInstance().findGems(sdks, predicate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "gems";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "predicate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "gemName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dependency";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/gem/util/RubyGemSearchUtil";
        objectArray[2] = "findGem";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

