/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.util.containers.SortedList;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.workspace.storage.ExtensionsKt;
import org.jetbrains.plugins.ruby.gem.workspace.storage.RubyGemBoxEntity;
import org.jetbrains.plugins.ruby.library.RubyLibraryProperties;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\bJ\u0006\u0010\u0017\u001a\u00020\u0018R*\u0010\u0004\u001a\u001e\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService$SearchContext;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lorg/jetbrains/plugins/ruby/gem/GemInfo;", "findGems", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "dependency", "Lorg/jetbrains/plugins/ruby/gem/GemDependency;", "sdks", "predicate", "Ljava/util/function/Predicate;", "name", "", "findGem", "version", "getAllGems", "invalidateCache", "", "SearchContext", "Companion", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubyGemSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n774#2:181\n865#2,2:182\n774#2:184\n865#2,2:185\n774#2:187\n865#2,2:188\n774#2:190\n865#2,2:191\n1#3:193\n*S KotlinDebug\n*F\n+ 1 RubyGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService\n*L\n57#1:181\n57#1:182,2\n65#1:184\n65#1:185,2\n80#1:187\n80#1:188,2\n127#1:190\n127#1:191,2\n*E\n"})
public final class RubyGemSearchService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<SearchContext, List<GemInfo>> cache;

    public RubyGemSearchService() {
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        LibraryTablesRegistrar.getInstance().getLibraryTable().addListener(new LibraryTable.Listener(){

            public void afterLibraryAdded(Library newLibrary) {
                Intrinsics.checkNotNullParameter((Object)newLibrary, (String)"newLibrary");
                cache.invalidateAll();
            }

            public void afterLibraryRenamed(Library library, String oldName) {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                cache.invalidateAll();
            }

            public void afterLibraryRemoved(Library library) {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                cache.invalidateAll();
            }
        }, (Disposable)this);
        LowMemoryWatcher.register(() -> RubyGemSearchService._init_$lambda$0(this), (Disposable)((Disposable)this));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull Sdk sdk, @NotNull GemDependency dependency) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Iterable $this$filter$iv = this.findGems(sdk, string);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo p0 = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!dependency.isSatisfied(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull List<? extends Sdk> sdks, @NotNull GemDependency dependency) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Iterable $this$filter$iv = this.findGems(sdks, string);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo p0 = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!dependency.isSatisfied(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<GemInfo> findGems(@NotNull Sdk sdk, @NotNull Predicate<GemInfo> predicate) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.findGems((List<? extends Sdk>)CollectionsKt.listOf((Object)sdk), predicate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull List<? extends Sdk> sdks, @NotNull Predicate<GemInfo> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable $this$filter$iv = this.getAllGems(sdks);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo p0 = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!predicate.test(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<GemInfo> findGems(@NotNull Sdk sdk, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.findGems((List<? extends Sdk>)CollectionsKt.listOf((Object)sdk), name);
    }

    @NotNull
    public final List<GemInfo> findGems(@NotNull List<? extends Sdk> sdks, @NotNull String name) {
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(sdks, name, null, 4, null));
        if (cachedGems != null) {
            List<GemInfo> list = Collections.unmodifiableList(cachedGems);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }
        List<GemInfo> gems = this.findGems(sdks, arg_0 -> RubyGemSearchService.findGems$lambda$2(name, arg_0));
        this.cache.put((Object)new SearchContext(sdks, name, null, 4, null), gems);
        return gems;
    }

    @Nullable
    public final GemInfo findGem(@NotNull Sdk sdk, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return (GemInfo)CollectionsKt.firstOrNull(this.findGems(CollectionsKt.listOf((Object)sdk), name, version));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemInfo> findGems(@NotNull List<? extends Sdk> sdks, @NotNull String name, @Nullable String version) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (version == null) {
            return this.findGems(sdks, name);
        }
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(sdks, name, version));
        if (cachedGems != null) {
            List<GemInfo> list = Collections.unmodifiableList(cachedGems);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }
        Iterable $this$filter$iv = this.findGems(sdks, name);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GemInfo it = (GemInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)version)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List gems = (List)destination$iv$iv;
        this.cache.put((Object)new SearchContext(sdks, name, version), (Object)gems);
        return gems;
    }

    @NotNull
    public final List<GemInfo> getAllGems(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return this.getAllGems(CollectionsKt.listOf((Object)sdk));
    }

    @NotNull
    public final List<GemInfo> getAllGems(@NotNull List<? extends Sdk> sdks) {
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        List cachedGems = (List)this.cache.getIfPresent((Object)new SearchContext(sdks, null, null, 6, null));
        if (cachedGems != null) {
            List<GemInfo> list = Collections.unmodifiableList(cachedGems);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
            return list;
        }
        SortedList gems = new SortedList(RubyGemSearchUtil.GEM_COMPARATOR);
        for (Sdk sdk : sdks) {
            ProgressManager.checkCanceled();
            Object object = sdk.getHomeDirectory();
            if (object == null || (object = object.toNioPath()) == null || (object = EelProviderUtil.getEelDescriptor((Path)object)) == null) {
                object = (EelDescriptor)LocalEelDescriptor.INSTANCE;
            }
            Object descriptor = object;
            ImmutableEntityStorage snapshot = GlobalWorkspaceModel.Companion.getInstance(descriptor.getMachine()).getCurrentSnapshot();
            Sequence gemBoxes = SequencesKt.filter((Sequence)snapshot.entities(RubyGemBoxEntity.class), arg_0 -> RubyGemSearchService.getAllGems$lambda$0(sdk, arg_0));
            Sequence libraries = SequencesKt.flatMapIterable((Sequence)gemBoxes, arg_0 -> RubyGemSearchService.getAllGems$lambda$1(snapshot, arg_0));
            CollectionsKt.addAll((Collection)((Collection)gems), (Sequence)SequencesKt.mapNotNull((Sequence)libraries, arg_0 -> RubyGemSearchService.getAllGems$lambda$2(sdk, arg_0)));
        }
        this.cache.put((Object)new SearchContext(sdks, null, null, 6, null), (Object)gems);
        List<GemInfo> list = Collections.unmodifiableList((List)gems);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    public final void invalidateCache() {
        this.cache.invalidateAll();
    }

    private static final void _init_$lambda$0(RubyGemSearchService this$0) {
        this$0.cache.invalidateAll();
    }

    private static final boolean findGems$lambda$2(String $name, GemInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    private static final boolean getAllGems$lambda$0(Sdk $sdk, RubyGemBoxEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SdkId sdkId = it.getSdkId();
        String string = $sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $sdk.getSdkType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return Intrinsics.areEqual((Object)sdkId, (Object)new SdkId(string, string2));
    }

    private static final Iterable getAllGems$lambda$1(ImmutableEntityStorage $snapshot, RubyGemBoxEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.libraries((EntityStorage)$snapshot);
    }

    private static final GemInfo getAllGems$lambda$2(Sdk $sdk, LibraryEntity library) {
        GemInfo gemInfo;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        RubyLibraryProperties rubyLibraryProperties = ExtensionsKt.getRubyLibraryProperties(library);
        if (rubyLibraryProperties != null) {
            RubyLibraryProperties it = rubyLibraryProperties;
            boolean bl = false;
            gemInfo = GemInfo.create($sdk, it);
        } else {
            gemInfo = null;
        }
        return gemInfo;
    }

    @JvmStatic
    @NotNull
    public static final RubyGemSearchService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService;", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nRubyGemSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,180:1\n42#2,3:181\n*S KotlinDebug\n*F\n+ 1 RubyGemSearchService.kt\norg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService$Companion\n*L\n177#1:181,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RubyGemSearchService getInstance() {
            boolean $i$f$service = false;
            Class<RubyGemSearchService> serviceClass$iv = RubyGemSearchService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RubyGemSearchService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/ruby/gem/util/RubyGemSearchService$SearchContext;", "", "sdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "name", "", "version", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getSdks", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ruby.backend"})
    private static final class SearchContext {
        @NotNull
        private final List<Sdk> sdks;
        @Nullable
        private final String name;
        @Nullable
        private final String version;

        public SearchContext(@NotNull List<? extends Sdk> sdks, @Nullable String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
            this.sdks = sdks;
            this.name = name;
            this.version = version;
        }

        public /* synthetic */ SearchContext(List list, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(list, string, string2);
        }

        @NotNull
        public final List<Sdk> getSdks() {
            return this.sdks;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final List<Sdk> component1() {
            return this.sdks;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final SearchContext copy(@NotNull List<? extends Sdk> sdks, @Nullable String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
            return new SearchContext(sdks, name, version);
        }

        public static /* synthetic */ SearchContext copy$default(SearchContext searchContext, List list, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                list = searchContext.sdks;
            }
            if ((n & 2) != 0) {
                string = searchContext.name;
            }
            if ((n & 4) != 0) {
                string2 = searchContext.version;
            }
            return searchContext.copy(list, string, string2);
        }

        @NotNull
        public String toString() {
            return "SearchContext(sdks=" + this.sdks + ", name=" + this.name + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result = ((Object)this.sdks).hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchContext)) {
                return false;
            }
            SearchContext searchContext = (SearchContext)other;
            if (!Intrinsics.areEqual(this.sdks, searchContext.sdks)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)searchContext.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)searchContext.version);
        }
    }
}

