/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;

public abstract class GemDependencyResolver {
    protected final Set<GemInfo> mySdkGems;
    protected final Set<GemDependency> myRequirements;
    protected boolean isResolved;
    protected Set<GemInfo> myResolveResult;

    public GemDependencyResolver(@NotNull Collection<? extends GemInfo> sdkGems, @NotNull @NotNull Set<@NotNull GemDependency> additionalRequirements) {
        if (sdkGems == null) {
            GemDependencyResolver.$$$reportNull$$$0(0);
        }
        if (additionalRequirements == null) {
            GemDependencyResolver.$$$reportNull$$$0(1);
        }
        SortedList<GemInfo> additionalGems = GemManager.buildGemsFromPathRequirements(additionalRequirements);
        this.mySdkGems = new LinkedHashSet<GemInfo>(ContainerUtil.sorted((Iterable)ContainerUtil.concat(sdkGems, additionalGems), RubyGemSearchUtil.GEM_COMPARATOR));
        this.myRequirements = Set.copyOf(additionalRequirements);
    }

    @NotNull
    public Set<GemInfo> resolveDependencies() {
        this.update();
        Set<GemInfo> set = this.myResolveResult != null ? Collections.unmodifiableSet(this.myResolveResult) : Collections.emptySet();
        if (set == null) {
            GemDependencyResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    protected abstract void doResolve();

    private void update() {
        if (!this.isResolved) {
            this.doResolve();
        }
    }

    @NotNull
    protected static List<GemDependency> asRequirements(@NotNull GemInfo gem) {
        if (gem == null) {
            GemDependencyResolver.$$$reportNull$$$0(3);
        }
        List<GemDependency> list = Arrays.asList(gem.getDependencies());
        if (list == null) {
            GemDependencyResolver.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkGems";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRequirements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/GemDependencyResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/GemDependencyResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asRequirements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asRequirements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

