/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;

public class DefaultGemDependencyResolver
extends GemDependencyResolver {
    private static final Logger LOG = Logger.getInstance(DefaultGemDependencyResolver.class);

    public DefaultGemDependencyResolver(@NotNull Collection<GemInfo> rootGems, @NotNull @NotNull Set<@NotNull GemDependency> additionalRequirements) {
        if (rootGems == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(0);
        }
        if (additionalRequirements == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(1);
        }
        super(rootGems, additionalRequirements);
    }

    @Override
    protected void doResolve() {
        HashMap<String, GemInfo> requiredGems = new HashMap<String, GemInfo>();
        SortedList result = new SortedList(RubyGemSearchUtil.GEM_COMPARATOR);
        LinkedList<GemDependency> queue = new LinkedList<GemDependency>(DefaultGemDependencyResolver.mergeRequirements(this.myRequirements));
        while (!queue.isEmpty()) {
            GemInfo gem;
            GemDependency requirement = (GemDependency)queue.poll();
            if (ContainerUtil.exists((Iterable)result, requirement::isSatisfied) || (gem = DefaultGemDependencyResolver.findGemByDependency(this.mySdkGems, requirement, (List<GemInfo>)result)) == null) continue;
            result.add(gem);
            GemInfo oldGem = requiredGems.put(gem.getName(), gem);
            if (oldGem != null && !gem.equals(oldGem)) {
                String msg = "Two different versions of gem is required (" + String.valueOf(oldGem) + ", " + String.valueOf(gem) + ") because of " + String.valueOf(requirement);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.debug(msg);
                } else {
                    LOG.warn(msg);
                }
            }
            queue.addAll(DefaultGemDependencyResolver.asRequirements(gem));
        }
        this.myResolveResult = Set.copyOf(result);
        this.isResolved = true;
    }

    private static Collection<GemDependency> mergeRequirements(Set<GemDependency> requirements) {
        MultiMap result = MultiMap.createSet();
        for (GemDependency requirement : requirements) {
            String name = requirement.getName();
            Collection deps = result.get((Object)name);
            boolean shouldAdd = true;
            if (!deps.isEmpty()) {
                for (GemDependency dep : deps.toArray(new GemDependency[0])) {
                    if (dep.canEat(requirement)) {
                        shouldAdd = false;
                        continue;
                    }
                    if (!requirement.canEat(dep)) continue;
                    deps.remove(dep);
                }
            }
            if (!shouldAdd) continue;
            result.putValue((Object)name, (Object)requirement);
        }
        return result.values();
    }

    @Nullable
    private static GemInfo findGemByDependency(@NotNull Set<GemInfo> sdkGems, @NotNull GemDependency dependency, @NotNull List<GemInfo> addedGems) {
        if (sdkGems == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(2);
        }
        if (dependency == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(3);
        }
        if (addedGems == null) {
            DefaultGemDependencyResolver.$$$reportNull$$$0(4);
        }
        GemInfo maxGem = (GemInfo)ContainerUtil.find(addedGems, dependency::isSatisfied);
        return maxGem != null ? maxGem : (GemInfo)ContainerUtil.find(sdkGems, dependency::isSatisfied);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGems";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRequirements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkGems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedGems";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/DefaultGemDependencyResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findGemByDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

