/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;

class ShowDescriptionAction
extends AnAction
implements DumbAware {
    private final SimpleTree myTree;
    private final WebBrowser myFirstActiveBrowser;

    private ShowDescriptionAction(@NotNull SimpleTree tree, @Nullable WebBrowser firstActiveBrowser) {
        if (tree == null) {
            ShowDescriptionAction.$$$reportNull$$$0(0);
        }
        super(() -> RBundle.message((String)"ruby.ide.sdk.configurable.show.gem.description.title"), firstActiveBrowser != null ? firstActiveBrowser.getIcon() : AllIcons.Actions.ShowImportStatements);
        this.myTree = tree;
        this.myFirstActiveBrowser = firstActiveBrowser;
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ctrl D"}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String gemURL;
        if (e == null) {
            ShowDescriptionAction.$$$reportNull$$$0(1);
        }
        if ((gemURL = this.getGemURL()) == null) {
            return;
        }
        BrowserLauncher.getInstance().browse(gemURL, this.myFirstActiveBrowser);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDescriptionAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(this.isEnabled());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDescriptionAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled() {
        return this.getGemURL() != null;
    }

    @Nullable
    private String getGemURL() {
        GemInfo gemInfo = RubySdkGemsConfigurableBase.getSelectedNodeGemInfo(this.myTree);
        String homepage = gemInfo == null ? null : gemInfo.getAdditionalInfo().homepage();
        return homepage != null && StringUtil.startsWith((CharSequence)homepage, (CharSequence)"http") ? homepage : null;
    }

    public static AnAction actionButton(@NotNull SimpleTree tree, @Nullable WebBrowser firstActiveBrowser) {
        if (tree == null) {
            ShowDescriptionAction.$$$reportNull$$$0(4);
        }
        return new ShowDescriptionAction(tree, firstActiveBrowser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/ShowDescriptionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/ShowDescriptionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionButton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

