/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.BrowseFolderDescriptor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import java.awt.Insets;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.ui.RubyWizardUtilKt;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherUtilKt;
import org.jetbrains.plugins.ruby.wizard.ui.RubySdkComboBox;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aE\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u001a#\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a]\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\b\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\r2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001b\u001a\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0010H\u0003\u001a\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u0005H\u0003\u001a2\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u00182\b\b\u0001\u0010#\u001a\u00020\u00052\b\b\u0001\u0010$\u001a\u00020\u00052\b\b\u0001\u0010%\u001a\u00020\u0005H\u0007\u001a\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00040+\u001a\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006/"}, d2={"COMMON_RUBY_PROJECT_NAME_REGEXP", "Lkotlin/text/Regex;", "RAILS_PROJECT_NAME_FIRST_NUMBER_REGEXP", "RAILS_PROJECT_NAME_RESERVED_WORDS", "", "", "RAILS_PROJECT_NAME_APP_NAMES", "addProjectNameLocationRows", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lkotlin/ExtensionFunctionType;", "projectName", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "projectLocation", "isCreatingNewProject", "", "isRailsProject", "getLocationComment", "Lorg/jetbrains/annotations/Nls;", "canonicalPathProperty", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "addProjectNameLocationSdkRows", "projectSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "showBundlerInfo", "withVisualPadding", "Lcom/intellij/openapi/ui/DialogPanel;", "validateName", "name", "isRailsProjectName", "validateLocation", "path", "validateSdk", "sdk", "title", "message", "popupMessage", "LOCAL_SDK_PREDICATE", "Ljava/util/function/Predicate;", "getLOCAL_SDK_PREDICATE", "()Ljava/util/function/Predicate;", "getRubySdksSupplier", "Lkotlin/Function0;", "refreshSdkIfNeeded", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "intellij.ruby.backend"})
public final class RubyWizardUtilKt {
    @NotNull
    private static final Regex COMMON_RUBY_PROJECT_NAME_REGEXP = new Regex("[a-zA-Z0-9-._ ]*");
    @NotNull
    private static final Regex RAILS_PROJECT_NAME_FIRST_NUMBER_REGEXP = new Regex("^\\d.*");
    @NotNull
    private static final List<String> RAILS_PROJECT_NAME_RESERVED_WORDS;
    @NotNull
    private static final List<String> RAILS_PROJECT_NAME_APP_NAMES;
    @NotNull
    private static final Predicate<Sdk> LOCAL_SDK_PREDICATE;

    @NotNull
    public static final Function1<Panel, Unit> addProjectNameLocationRows(@NotNull GraphProperty<String> projectName, @NotNull GraphProperty<String> projectLocation, boolean isCreatingNewProject, boolean isRailsProject) {
        Intrinsics.checkNotNullParameter(projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(projectLocation, (String)"projectLocation");
        return arg_0 -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0(projectName, isRailsProject, projectLocation, isCreatingNewProject, arg_0);
    }

    public static /* synthetic */ Function1 addProjectNameLocationRows$default(GraphProperty graphProperty, GraphProperty graphProperty2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return RubyWizardUtilKt.addProjectNameLocationRows((GraphProperty<String>)graphProperty, (GraphProperty<String>)graphProperty2, bl, bl2);
    }

    private static final String getLocationComment(ObservableProperty<String> canonicalPathProperty, boolean isCreatingNewProject) {
        String string = StringUtil.shortenPathWithEllipsis((String)UiUtils.getPresentablePath((String)((String)canonicalPathProperty.get())), (int)60);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenPathWithEllipsis(...)");
        String shortPath = string;
        Object[] objectArray = new Object[]{isCreatingNewProject ? 1 : 0, shortPath};
        String string2 = RBundle.message((String)"ruby.project.wizard.project.path.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public static final Function1<Panel, Unit> addProjectNameLocationSdkRows(@NotNull GraphProperty<String> projectName, @NotNull GraphProperty<String> projectLocation, @NotNull GraphProperty<Sdk> projectSdk, boolean showBundlerInfo, boolean isCreatingNewProject, boolean isRailsProject) {
        Intrinsics.checkNotNullParameter(projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(projectLocation, (String)"projectLocation");
        Intrinsics.checkNotNullParameter(projectSdk, (String)"projectSdk");
        return arg_0 -> RubyWizardUtilKt.addProjectNameLocationSdkRows$lambda$0(projectName, projectLocation, isCreatingNewProject, isRailsProject, projectSdk, showBundlerInfo, arg_0);
    }

    public static /* synthetic */ Function1 addProjectNameLocationSdkRows$default(GraphProperty graphProperty, GraphProperty graphProperty2, GraphProperty graphProperty3, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        return RubyWizardUtilKt.addProjectNameLocationSdkRows((GraphProperty<String>)graphProperty, (GraphProperty<String>)graphProperty2, (GraphProperty<Sdk>)graphProperty3, bl, bl2, bl3);
    }

    @NotNull
    public static final DialogPanel withVisualPadding(@NotNull DialogPanel $this$withVisualPadding) {
        Intrinsics.checkNotNullParameter((Object)$this$withVisualPadding, (String)"<this>");
        if (PlatformUtils.isRubyMine()) {
            $this$withVisualPadding.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(8, 10, 8, 10))));
        } else {
            $this$withVisualPadding.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)new JBInsets(15, 20, 20, 20))));
        }
        return $this$withVisualPadding;
    }

    @NlsContexts.DialogMessage
    private static final String validateName(String name, boolean isRailsProjectName) {
        Object[] objectArray;
        if (((CharSequence)name).length() == 0) {
            return RBundle.message((String)"ruby.project.wizard.name.missing.name");
        }
        if (isRailsProjectName) {
            objectArray = (Object[])name;
            if (RAILS_PROJECT_NAME_FIRST_NUMBER_REGEXP.matches((CharSequence)objectArray)) {
                return RBundle.message((String)"rails.wizard.project.rails.name.format.error.number");
            }
            if (RAILS_PROJECT_NAME_RESERVED_WORDS.contains(name)) {
                objectArray = new Object[]{name};
                return RBundle.message((String)"rails.wizard.project.rails.name.format.error.reserved.words", (Object[])objectArray);
            }
            if (RAILS_PROJECT_NAME_APP_NAMES.contains(name)) {
                objectArray = new Object[]{name};
                return RBundle.message((String)"rails.wizard.project.rails.name.format.error.app.name", (Object[])objectArray);
            }
        }
        if (!COMMON_RUBY_PROJECT_NAME_REGEXP.matches((CharSequence)(objectArray = (CharSequence)name))) {
            return RBundle.message((String)"ruby.project.wizard.name.format.error");
        }
        return null;
    }

    @NlsContexts.DialogMessage
    private static final String validateLocation(String path) {
        Path locationPath = null;
        try {
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            locationPath = path2;
        }
        catch (InvalidPathException e) {
            return RBundle.message((String)"ruby.project.wizard.location.path.illegal");
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project objectArray : projectArray) {
            Intrinsics.checkNotNull((Object)objectArray);
            Project project = objectArray;
            if (!ProjectUtil.isSameProject((Path)locationPath, (Project)project)) continue;
            Object[] objectArray2 = new Object[]{project.getName()};
            return RBundle.message((String)"ruby.project.wizard.location.directory.already.taken.error", (Object[])objectArray2);
        }
        File file = locationPath.toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return RBundle.message((String)"ruby.project.wizard.location.directory.not.writable.error");
            }
            if (file.list() == null) {
                return RBundle.message((String)"ruby.project.wizard.location.file.not.directory.error");
            }
            if (RailsUtil.containsRailsApp(path)) {
                return RBundle.message((String)"ruby.project.wizard.location.directory.contains.rails.app.error");
            }
        }
        return null;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public static final String validateSdk(@Nullable Sdk sdk, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogMessage @NotNull String popupMessage) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)popupMessage, (String)"popupMessage");
        if (sdk == null) {
            String[] stringArray = new String[]{CommonBundle.getOkButtonText()};
            Messages.showDialog((String)message, (String)title, (String[])stringArray, (int)0, (Icon)Messages.getWarningIcon());
            return popupMessage;
        }
        return null;
    }

    @NotNull
    public static final Predicate<Sdk> getLOCAL_SDK_PREDICATE() {
        return LOCAL_SDK_PREDICATE;
    }

    @NotNull
    public static final Function0<List<Sdk>> getRubySdksSupplier() {
        return RubyWizardUtilKt::getRubySdksSupplier$lambda$0;
    }

    public static final void refreshSdkIfNeeded(@NotNull WizardContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)context.getUserData((Key)SdkRefresher.isSdkRefreshRequestedKey), (Object)false)) {
            ApplicationKt.getApplication().executeOnPooledThread(RubyWizardUtilKt::refreshSdkIfNeeded$lambda$0);
            context.putUserData((Key)SdkRefresher.isSdkRefreshRequestedKey, (Object)true);
        }
    }

    private static final Unit addProjectNameLocationRows$lambda$0(GraphProperty $projectName, boolean $isRailsProject, GraphProperty $projectLocation, boolean $isCreatingNewProject, Panel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"<this>");
        String string = RBundle.message((String)"ruby.project.wizard.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        panel2.row(string, arg_0 -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$0($projectName, $isRailsProject, arg_0)).bottomGap(BottomGap.SMALL);
        String string2 = RBundle.message((String)"ruby.project.wizard.location");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        panel2.row(string2, arg_0 -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$1($projectName, $projectLocation, $isCreatingNewProject, arg_0)).bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit addProjectNameLocationRows$lambda$0$0(GraphProperty $projectName, boolean $isRailsProject, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.columns((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), (ObservableMutableProperty)((ObservableMutableProperty)$projectName)), (int)25).validationOnInput((arg_0, arg_1) -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$0$0($projectName, $isRailsProject, arg_0, arg_1)).validationOnApply((arg_0, arg_1) -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$0$1($projectName, $isRailsProject, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo addProjectNameLocationRows$lambda$0$0$0(GraphProperty $projectName, boolean $isRailsProject, ValidationInfoBuilder $this$validationOnInput, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = RubyWizardUtilKt.validateName((String)$projectName.get(), $isRailsProject);
        if (string == null) {
            return null;
        }
        return $this$validationOnInput.error(string);
    }

    private static final ValidationInfo addProjectNameLocationRows$lambda$0$0$1(GraphProperty $projectName, boolean $isRailsProject, ValidationInfoBuilder $this$validationOnApply, JBTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = RubyWizardUtilKt.validateName((String)$projectName.get(), $isRailsProject);
        if (string == null) {
            return null;
        }
        return $this$validationOnApply.error(string);
    }

    private static final Unit addProjectNameLocationRows$lambda$0$1(GraphProperty $projectName, GraphProperty $projectLocation, boolean $isCreatingNewProject, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$projectName.get()};
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withTitle(RBundle.message((String)"ruby.project.title.select.project.file.directory", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"withTitle(...)");
        BrowseFolderDescriptor fileChooserDescriptor3 = BrowseFolderDescriptor.Companion.withTextToPathConvertor((FileChooserDescriptor)BrowseFolderDescriptor.Companion.withPathToTextConvertor(fileChooserDescriptor2, (Function1)addProjectNameLocationRows.1.2.fileChooserDescriptor.1.INSTANCE), (Function1)addProjectNameLocationRows.1.2.fileChooserDescriptor.2.INSTANCE);
        ObservableMutableProperty locationProperty = PropertyOperationUtil.toUiPathProperty((ObservableMutableProperty)((ObservableMutableProperty)$projectLocation));
        Cell cell = new Cell[]{$projectName};
        ObservableProperty commentProperty = PropertyOperationUtil.joinSystemDependentPath((ObservableProperty)((ObservableProperty)$projectLocation), (ObservableProperty[])cell);
        Cell $this$addProjectNameLocationRows_u24lambda_u240_u241_u240 = cell = Cell.comment$default((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)((FileChooserDescriptor)fileChooserDescriptor3), null, null, (int)6, null), (ObservableMutableProperty)locationProperty).align((Align)AlignX.FILL.INSTANCE), (String)RubyWizardUtilKt.getLocationComment((ObservableProperty<String>)commentProperty, $isCreatingNewProject), (int)100, null, (int)4, null);
        boolean bl = false;
        $projectName.afterChange(arg_0 -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$1$0$0($this$addProjectNameLocationRows_u24lambda_u240_u241_u240, commentProperty, $isCreatingNewProject, arg_0));
        $projectLocation.afterChange(arg_0 -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$1$0$1($this$addProjectNameLocationRows_u24lambda_u240_u241_u240, commentProperty, $isCreatingNewProject, arg_0));
        cell.validationOnInput((arg_0, arg_1) -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$1$1($projectLocation, arg_0, arg_1)).validationOnApply((arg_0, arg_1) -> RubyWizardUtilKt.addProjectNameLocationRows$lambda$0$1$2($projectLocation, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit addProjectNameLocationRows$lambda$0$1$0$0(Cell $this_apply, ObservableProperty $commentProperty, boolean $isCreatingNewProject, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane jEditorPane = $this_apply.getComment();
        Intrinsics.checkNotNull((Object)jEditorPane);
        jEditorPane.setText(RubyWizardUtilKt.getLocationComment((ObservableProperty<String>)$commentProperty, $isCreatingNewProject));
        return Unit.INSTANCE;
    }

    private static final Unit addProjectNameLocationRows$lambda$0$1$0$1(Cell $this_apply, ObservableProperty $commentProperty, boolean $isCreatingNewProject, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JEditorPane jEditorPane = $this_apply.getComment();
        Intrinsics.checkNotNull((Object)jEditorPane);
        jEditorPane.setText(RubyWizardUtilKt.getLocationComment((ObservableProperty<String>)$commentProperty, $isCreatingNewProject));
        return Unit.INSTANCE;
    }

    private static final ValidationInfo addProjectNameLocationRows$lambda$0$1$1(GraphProperty $projectLocation, ValidationInfoBuilder $this$validationOnInput, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = RubyWizardUtilKt.validateLocation((String)$projectLocation.get());
        if (string == null) {
            return null;
        }
        return $this$validationOnInput.error(string);
    }

    private static final ValidationInfo addProjectNameLocationRows$lambda$0$1$2(GraphProperty $projectLocation, ValidationInfoBuilder $this$validationOnApply, TextFieldWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = RubyWizardUtilKt.validateLocation((String)$projectLocation.get());
        if (string == null) {
            return null;
        }
        return $this$validationOnApply.error(string);
    }

    private static final Unit addProjectNameLocationSdkRows$lambda$0(GraphProperty $projectName, GraphProperty $projectLocation, boolean $isCreatingNewProject, boolean $isRailsProject, GraphProperty $projectSdk, boolean $showBundlerInfo, Panel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"<this>");
        RubyWizardUtilKt.addProjectNameLocationRows((GraphProperty<String>)$projectName, (GraphProperty<String>)$projectLocation, $isCreatingNewProject, $isRailsProject).invoke((Object)panel2);
        Function1 sdkRow = arg_0 -> RubyWizardUtilKt.addProjectNameLocationSdkRows$lambda$0$0($projectSdk, $showBundlerInfo, arg_0);
        String string = RBundle.message((String)"ruby.project.wizard.tab.project.generator.ruby.sdk");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        panel2.row(string, arg_0 -> RubyWizardUtilKt.addProjectNameLocationSdkRows$lambda$0$1(sdkRow, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit addProjectNameLocationSdkRows$lambda$0$0(GraphProperty $projectSdk, boolean $showBundlerInfo, Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"<this>");
        row.cell((JComponent)((Object)new RubySdkComboBox(() -> RubyWizardUtilKt.addProjectNameLocationSdkRows$lambda$0$0$0(RubyWizardUtilKt.getRubySdksSupplier()), (ObservableMutableProperty<Sdk>)((ObservableMutableProperty)$projectSdk), $showBundlerInfo))).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> RubyWizardUtilKt.addProjectNameLocationSdkRows$lambda$0$0$1($projectSdk, arg_0, arg_1));
        row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final List addProjectNameLocationSdkRows$lambda$0$0$0(Function0 $tmp0) {
        return (List)$tmp0.invoke();
    }

    private static final ValidationInfo addProjectNameLocationSdkRows$lambda$0$0$1(GraphProperty $projectSdk, ValidationInfoBuilder $this$validationOnApply, RubySdkComboBox it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Sdk sdk = (Sdk)$projectSdk.get();
        String string = RBundle.message((String)"gem.wizard.project.ruby.sdk.not.selected.title");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = RBundle.message((String)"gem.wizard.project.ruby.sdk.not.selected.message");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = RBundle.message((String)"gem.wizard.project.ruby.sdk.not.selected");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = RubyWizardUtilKt.validateSdk(sdk, string, string2, string3);
        if (string4 == null) {
            return null;
        }
        return $this$validationOnApply.error(string4);
    }

    private static final Unit addProjectNameLocationSdkRows$lambda$0$1(Function1 $sdkRow, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $sdkRow.invoke((Object)$this$row);
        return Unit.INSTANCE;
    }

    private static final boolean LOCAL_SDK_PREDICATE$lambda$0(Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (!RubyRemoteInterpreterManager.isRemoteSdk(sdk)) {
            return true;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        return sdkAdditionalData instanceof RubyRemoteSdkAdditionalData && ((RubyRemoteSdkAdditionalData)sdkAdditionalData).isAvailableForNewProjects();
    }

    private static final List getRubySdksSupplier$lambda$0() {
        GlobalWorkspaceModel.Companion.getInstance((EelMachine)LocalEelMachine.INSTANCE);
        List sdks = new ArrayList();
        ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()).stream().filter(LOCAL_SDK_PREDICATE).forEach(arg_0 -> RubyWizardUtilKt.getRubySdksSupplier$lambda$0$1(arg_0 -> RubyWizardUtilKt.getRubySdksSupplier$lambda$0$0(sdks, arg_0), arg_0));
        ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JRubySdkType.getInstance()).stream().filter(LOCAL_SDK_PREDICATE).forEach(arg_0 -> RubyWizardUtilKt.getRubySdksSupplier$lambda$0$3(arg_0 -> RubyWizardUtilKt.getRubySdksSupplier$lambda$0$2(sdks, arg_0), arg_0));
        CollectionsKt.sortWith((List)sdks, RubyWizardUtilKt::getRubySdksSupplier$lambda$0$4);
        return Collections.unmodifiableList(sdks);
    }

    private static final Unit getRubySdksSupplier$lambda$0$0(List $sdks, Sdk e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $sdks.add(e);
        return Unit.INSTANCE;
    }

    private static final void getRubySdksSupplier$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getRubySdksSupplier$lambda$0$2(List $sdks, Sdk e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $sdks.add(e);
        return Unit.INSTANCE;
    }

    private static final void getRubySdksSupplier$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final int getRubySdksSupplier$lambda$0$4(Sdk a, Sdk b) {
        return VersionComparatorUtil.compare((String)a.getVersionString(), (String)b.getVersionString());
    }

    private static final void refreshSdkIfNeeded$lambda$0() {
        SdkRefresherUtilKt.refreshAllWhenReady(RubyWizardUtilKt::refreshSdkIfNeeded$lambda$0$0);
    }

    private static final boolean refreshSdkIfNeeded$lambda$0$0() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        return !(((Object[])projectArray).length == 0);
    }

    static {
        Object[] objectArray = new String[]{"application", "destroy", "plugin", "runner", "test"};
        RAILS_PROJECT_NAME_RESERVED_WORDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"Rails", "rails"};
        RAILS_PROJECT_NAME_APP_NAMES = CollectionsKt.listOf((Object[])objectArray);
        LOCAL_SDK_PREDICATE = RubyWizardUtilKt::LOCAL_SDK_PREDICATE$lambda$0;
    }
}

