/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyModuleSdkGemsConfigurable
extends RubySdkGemsConfigurableBase {
    @NotNull
    protected Module myModule;
    @NotNull
    protected final Consumer<? super Sdk> mySetSdkConsumer;
    @NotNull
    protected final Computable<? extends ModifiableRootModel> myModelComputable;
    @Nullable
    private String mySelectedSdkName;

    public RubyModuleSdkGemsConfigurable(@NotNull Module module) {
        if (module == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(0);
        }
        this(module, (Computable<? extends ModifiableRootModel>)((Computable)() -> GemModificationUtil.getModuleModifiableModel(module)), (Consumer<? super Sdk>)((Consumer)sdk -> RModuleUtil.getInstance().changeModuleSdk((Sdk)sdk, module)));
    }

    public RubyModuleSdkGemsConfigurable(@NotNull Module module, @NotNull Computable<? extends ModifiableRootModel> modelComputable, @NotNull Consumer<? super Sdk> setSdkConsumer) {
        if (module == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(1);
        }
        if (modelComputable == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(2);
        }
        if (setSdkConsumer == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(3);
        }
        this.mySetSdkConsumer = setSdkConsumer;
        this.myModule = module;
        this.myModelComputable = modelComputable;
        Sdk selectedSdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        this.mySelectedSdkName = selectedSdk == null ? null : selectedSdk.getName();
        this.init();
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    protected MultiMap<String, String> getSettingsMap() {
        return RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).copy();
    }

    @Override
    void saveSettingsMap(@NotNull MultiMap<String, String> map) {
        if (map == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(5);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, map);
    }

    @Override
    @Nullable
    protected Sdk getSdk() {
        return ModuleRootManager.getInstance((Module)this.myModule).getSdk();
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        String string = RBundle.message((String)"ruby.ide.sdk.configurable.no.module.sdk.marked", (Object[])new Object[]{this.myModule.getName()});
        if (string == null) {
            RubyModuleSdkGemsConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || !RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.myModule).equals((Object)this.mySdkGemsetsMap);
    }

    @Override
    public void disposeUIResources() {
        boolean needToSetSdk = this.mySelectedSdkName != null && this.isModified();
        super.disposeUIResources();
        if (needToSetSdk) {
            this.mySetSdkConsumer.consume((Object)ProjectJdkTable.getInstance().findJdk(this.mySelectedSdkName));
        }
    }

    @Override
    protected void doApply() throws ConfigurationException {
        super.doApply();
        this.mySelectedSdkName = null;
        Sdk selectedSdk = this.getCheckedSdk();
        if (selectedSdk == null) {
            return;
        }
        if (this.myIsDisposed) {
            ModuleRootModificationUtil.updateModel((Module)this.myModule, rootModel -> rootModel.setSdk(selectedSdk));
        } else {
            this.mySetSdkConsumer.consume((Object)selectedSdk);
        }
        RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.myModule, (MultiMap<String, String>)this.mySdkGemsetsMap.copy());
        Collection gemsets = this.mySdkGemsetsMap.get((Object)selectedSdk.getHomePath());
        if (RbenvGemsetManager.isRbenvSdk(selectedSdk)) {
            RbenvGemsetManager.applyRbenvGemsetsToConfig(this.myModule, gemsets);
        }
        RubySdkGemLibraryManager.getInstance().refresh();
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel commitModel = (ModifiableRootModel)this.myModelComputable.compute();
            if (GemManager.updateGemset(commitModel, selectedSdk)) {
                GemModificationUtil.commitModuleModifiableModel(commitModel);
            } else {
                GemModificationUtil.disposeModuleModifiableModel(commitModel);
            }
        });
    }

    @Override
    @Nullable
    protected Sdk getPreferableRVMSdk(@Nullable Sdk selectedSdk) {
        if (RVMSupportUtil.isLocalRootRVMSdk(selectedSdk)) {
            return selectedSdk;
        }
        Sdk sdkForModule = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        if (RVMSupportUtil.isLocalRootRVMSdk(sdkForModule)) {
            return sdkForModule;
        }
        return super.getPreferableRVMSdk(selectedSdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelComputable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSdkConsumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubyModuleSdkGemsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveSettingsMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

