/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;

public class RubyDefaultProjectSdkGemsConfigurable
extends RubySdkGemsConfigurableBase {
    @NotNull
    protected final Project myDefaultProject;

    public RubyDefaultProjectSdkGemsConfigurable(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            RubyDefaultProjectSdkGemsConfigurable.$$$reportNull$$$0(0);
        }
        this.myDefaultProject = defaultProject;
        this.init();
    }

    @Override
    protected MultiMap<String, String> getSettingsMap() {
        return RubySdkGemsetsSettings.getInstance().getOrCreateDefaultProjectSdkGemsetsMap().copy();
    }

    @Override
    void saveSettingsMap(@NotNull MultiMap<String, String> map) {
        if (map == null) {
            RubyDefaultProjectSdkGemsConfigurable.$$$reportNull$$$0(1);
        }
        RubySdkGemsetsSettings.getInstance().setDefaultProjectSdkGemsetsMap(map);
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.myDefaultProject;
        if (project == null) {
            RubyDefaultProjectSdkGemsConfigurable.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    @Nullable
    protected Sdk getSdk() {
        return ProjectRootManager.getInstance((Project)this.myDefaultProject).getProjectSdk();
    }

    @Override
    @NotNull
    protected String getErrorMessage() {
        String string = RBundle.message((String)"ruby.ide.sdk.configurable.no.default.project.sdk.marked");
        if (string == null) {
            RubyDefaultProjectSdkGemsConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || !RubySdkGemsetsSettings.getInstance().getOrCreateDefaultProjectSdkGemsetsMap().equals((Object)this.mySdkGemsetsMap);
    }

    @Override
    protected void doApply() throws ConfigurationException {
        super.doApply();
        Sdk selectedSdk = this.getCheckedSdk();
        SdkConfigurationUtil.setDirectoryProjectSdk((Project)this.myDefaultProject, (Sdk)selectedSdk);
        if (!this.myDefaultProject.isDefault()) {
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            SdkConfigurationUtil.setDirectoryProjectSdk((Project)defaultProject, (Sdk)selectedSdk);
        }
        RubySdkGemsetsSettings.getInstance().setDefaultProjectSdkGemsetsMap((MultiMap<String, String>)this.mySdkGemsetsMap.copy());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/ui/RubyDefaultProjectSdkGemsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/ui/RubyDefaultProjectSdkGemsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveSettingsMap";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

