/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.ui.RadioButtonNode;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;

public class RadioButtonTreeHelper {
    private final EventDispatcher<RubySdkGemsConfigurableBase.RadiobuttonTreeListener> myEventDispatcher;

    public RadioButtonTreeHelper(EventDispatcher<RubySdkGemsConfigurableBase.RadiobuttonTreeListener> radioEventDispatcher) {
        this.myEventDispatcher = radioEventDispatcher;
    }

    public void initTree(@NotNull Tree tree, JComponent mainComponent, RubySdkGemsConfigurableBase.RubySdkTreeCellRendererBase cellRenderer) {
        if (tree == null) {
            RadioButtonTreeHelper.$$$reportNull$$$0(0);
        }
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        this.setupKeyListener(tree, mainComponent);
        this.setupMouseListener(tree, mainComponent, cellRenderer);
    }

    public void setNodeState(Tree tree, RadioButtonNode node, boolean checked) {
        this.changeNodeState(node, checked);
        tree.repaint();
        TreeModel model = tree.getModel();
        model.valueForPathChanged(new TreePath(node.getPath()), node.getUserObject());
    }

    private void toggleNode(Tree tree, RadioButtonNode node) {
        if (!node.isChecked()) {
            this.setNodeState(tree, node, !node.isChecked());
        }
    }

    private void changeNodeState(RadioButtonNode node, boolean checked) {
        if (node.isChecked() != checked) {
            ((RubySdkGemsConfigurableBase.RadiobuttonTreeListener)this.myEventDispatcher.getMulticaster()).beforeNodeStateChanged(node);
            node.setChecked(checked);
            ((RubySdkGemsConfigurableBase.RadiobuttonTreeListener)this.myEventDispatcher.getMulticaster()).nodeStateChanged(node);
        }
    }

    private void setupKeyListener(final Tree tree, final JComponent mainComponent) {
        mainComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RadioButtonTreeHelper.isToggleEvent(e, mainComponent)) {
                    TreePath treePath = tree.getLeadSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    Object o = treePath.getLastPathComponent();
                    if (!(o instanceof RadioButtonNode)) {
                        return;
                    }
                    RadioButtonNode firstNode = (RadioButtonNode)o;
                    if (!firstNode.isEnabled()) {
                        return;
                    }
                    RadioButtonTreeHelper.this.toggleNode(tree, firstNode);
                    boolean checked = firstNode.isChecked();
                    TreePath[] selectionPaths = tree.getSelectionPaths();
                    for (int i = 0; selectionPaths != null && i < selectionPaths.length; ++i) {
                        TreePath selectionPath = selectionPaths[i];
                        Object o1 = selectionPath.getLastPathComponent();
                        if (!(o1 instanceof RadioButtonNode)) continue;
                        RadioButtonNode node = (RadioButtonNode)o1;
                        RadioButtonTreeHelper.this.setNodeState(tree, node, checked);
                    }
                    e.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/ui/RadioButtonTreeHelper$1", "keyPressed"));
            }
        });
    }

    private static boolean isToggleEvent(KeyEvent e, JComponent mainComponent) {
        return e.getKeyCode() == 32 && SpeedSearchSupply.getSupply((JComponent)mainComponent) == null;
    }

    private void setupMouseListener(final Tree tree, JComponent mainComponent, final RubySdkGemsConfigurableBase.RubySdkTreeCellRendererBase cellRenderer) {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((row = tree.getRowForLocation(e.getX(), e.getY())) < 0) {
                    return false;
                }
                Object o = tree.getPathForRow(row).getLastPathComponent();
                if (!(o instanceof RadioButtonNode)) {
                    return false;
                }
                RadioButtonNode node = (RadioButtonNode)o;
                Rectangle rowBounds = tree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myRadioButton.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = checkBounds.width = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    if (node.isEnabled() && !node.isChecked()) {
                        RadioButtonTreeHelper.this.toggleNode(tree, node);
                        tree.setSelectionRow(row);
                        return true;
                    }
                } else if (clickCount > 1 && clickCount % 2 == 0) {
                    ((RubySdkGemsConfigurableBase.RadiobuttonTreeListener)RadioButtonTreeHelper.this.myEventDispatcher.getMulticaster()).mouseDoubleClicked(node);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/ui/RadioButtonTreeHelper$2", "onClick"));
            }
        }.installOn((Component)mainComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/plugins/ruby/gem/ui/RadioButtonTreeHelper", "initTree"));
    }
}

