/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module.rbenv;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvElementVisitor;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvGemsetCreateFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvGemsetSaveQuickFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvLocalGemsetExclusionFix;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvLocalGemsetFix;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemset;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvLocalGemset;

public class RbenvGemsetVisitor
extends RbenvElementVisitor {
    private final ProblemsHolder myHolder;

    public RbenvGemsetVisitor(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    public void visitGemset(@NotNull RbenvGemset gemset) {
        Module module;
        if (gemset == null) {
            RbenvGemsetVisitor.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)gemset)) == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return;
        }
        String gemsetName = gemset.getName();
        if (!RbenvGemsetManager.hasGemset(sdk, gemsetName)) {
            this.myHolder.registerProblem((PsiElement)gemset, RBundle.message((String)"ruby.rbenv.gemset.inspection.fix.text", (Object[])new Object[]{gemsetName, sdk.getName()}), new LocalQuickFix[]{new RbenvGemsetCreateFix(module, gemsetName)});
        }
    }

    public void visitLocalGemset(@NotNull RbenvLocalGemset localGemset) {
        Module module;
        if (localGemset == null) {
            RbenvGemsetVisitor.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)localGemset)) == null) {
            return;
        }
        String localGemsetName = localGemset.getName();
        VirtualFile localGemsetFolder = RbenvGemsetManager.getLocalGemsetFolder(module, localGemsetName);
        if (localGemsetFolder == null) {
            this.myHolder.registerProblem((PsiElement)localGemset, RBundle.message((String)"ruby.rbenv.local.gemset.create.inspection.fix.text", (Object[])new Object[]{localGemsetName}), new LocalQuickFix[]{new RbenvLocalGemsetFix(module, localGemsetName)});
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        if (fileIndex.isExcluded(localGemsetFolder)) {
            return;
        }
        this.myHolder.registerProblem((PsiElement)localGemset, RBundle.message((String)"ruby.rbenv.local.gemset.inspection.fix.text", (Object[])new Object[]{localGemsetName}), new LocalQuickFix[]{new RbenvLocalGemsetExclusionFix(module, localGemsetFolder)});
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        Module module;
        if (psiFile == null) {
            RbenvGemsetVisitor.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return;
        }
        for (String gemset : RbenvGemsetManager.getCurrentGemsetsOnly(module)) {
            if (RbenvGemsetManager.hasGemset(sdk, gemset) || RbenvGemsetManager.hasLocalGemset(module, gemset)) continue;
            return;
        }
        List<String> gemsets = RbenvGemsetManager.getRbenvConfiguredGemsets(module, sdk);
        List<String> currentGemsets = RbenvGemsetManager.getRbenvCurrentGemsets(module);
        if (ContainerUtil.compareLexicographically((List)ContainerUtil.sorted(gemsets), (List)ContainerUtil.sorted(currentGemsets)) != 0) {
            this.myHolder.registerProblem((PsiElement)this.myHolder.getFile(), RBundle.message((String)"ruby.rbenv.gemset.refresh.libs.text"), new LocalQuickFix[]{new RbenvGemsetSaveQuickFix(module)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGemset";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/rbenv/RbenvGemsetVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGemset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLocalGemset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

