/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module.rbenv;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.module.rbenv.RbenvGemsetSaveQuickFix;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

final class RbenvGemsetCreateFix
extends RbenvGemsetSaveQuickFix {
    private final String myGemsetName;

    RbenvGemsetCreateFix(@NotNull Module module, @NotNull String gemsetName) {
        if (module == null) {
            RbenvGemsetCreateFix.$$$reportNull$$$0(0);
        }
        if (gemsetName == null) {
            RbenvGemsetCreateFix.$$$reportNull$$$0(1);
        }
        super(module);
        this.myGemsetName = gemsetName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.rbenv.gemset.inspection.fix.name", (Object[])new Object[]{this.myGemsetName});
        if (string == null) {
            RbenvGemsetCreateFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void applyFix() {
        final Sdk rootSdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        if (rootSdk == null) {
            return;
        }
        final String version = RbenvGemsetManager.getGemsetSdkVersion(rootSdk);
        if (version == null) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myModule.getProject(), RBundle.message((String)"ruby.rbenv.gemset.inspection.creating", (Object[])new Object[]{this.myGemsetName}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                RbenvGemsetManager.createGemset(rootSdk, RbenvGemsetCreateFix.this.myModule, RbenvGemsetCreateFix.this.myModule.getProject(), RbenvGemsetCreateFix.this.myGemsetName, version);
            }

            public void onFinished() {
                RbenvGemsetManager.refreshGemsetFolder(rootSdk, RbenvGemsetCreateFix.this.myGemsetName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/module/rbenv/RbenvGemsetCreateFix$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsetName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/module/rbenv/RbenvGemsetCreateFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/rbenv/RbenvGemsetCreateFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

