/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.GemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemDependencyProvider;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class ModuleGemInfrastructure {
    @NotNull
    private final Module myModule;

    public ModuleGemInfrastructure(@NotNull Module module) {
        if (module == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    public GemDependencyResolver getDependencyResolver(Collection<GemInfo> sdkGems, Set<@NotNull GemDependency> dependencies) {
        return this.getInfrastructure().getDependencyResolver(this.myModule, sdkGems, dependencies);
    }

    @Nullable
    public Boolean hasMissingGems(@Nullable Sdk sdk) {
        return this.getInfrastructure().hasMissingGems(sdk, this.myModule, false);
    }

    public void installMissing(@Nullable Sdk sdk, @NotNull Runnable callback, @NotNull AtomicBoolean runCallbackInNewTab) {
        if (callback == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(1);
        }
        if (runCallbackInNewTab == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(2);
        }
        ReadAction.nonBlocking(() -> Pair.create(GemUtil.getMissingDependencies(sdk, this.myModule, this.getRequirements()), (Object)this.getInfrastructure())).finishOnUiThread(ModalityState.defaultModalityState(), pair -> {
            Set toInstall = (Set)pair.getFirst();
            GemInfrastructure infrastructure = (GemInfrastructure)pair.getSecond();
            if (sdk != null) {
                infrastructure.runInstall(this.myModule, sdk, toInstall, callback, runCallbackInNewTab);
            } else {
                if (!toInstall.isEmpty()) {
                    GemUiUtil.showNoSdkInstallError(this.myModule.getProject());
                }
                callback.run();
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void updateModuleGemset() {
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        this.installMissing(sdk, () -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
        }, new AtomicBoolean(false));
    }

    @NotNull
    public static ModuleGemInfrastructure getInstance(@NotNull Module module) {
        if (module == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(3);
        }
        ModuleGemInfrastructure moduleGemInfrastructure = Objects.requireNonNull((ModuleGemInfrastructure)module.getService(ModuleGemInfrastructure.class));
        if (moduleGemInfrastructure == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(4);
        }
        return moduleGemInfrastructure;
    }

    @NotNull
    private GemInfrastructure getInfrastructure() {
        GemInfrastructure gemInfrastructure = (GemInfrastructure)ReadAction.compute(() -> {
            for (GemInfrastructure infrastructure : (GemInfrastructure[])GemInfrastructure.EP_NAME.getExtensions()) {
                if (!infrastructure.isApplicable(this.myModule)) continue;
                return infrastructure;
            }
            return GemInfrastructure.DEFAULT;
        });
        if (gemInfrastructure == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(5);
        }
        return gemInfrastructure;
    }

    @NotNull
    public Set<GemInfo> getModuleRequiredGems(@NotNull Collection<GemInfo> sdkGems) {
        if (sdkGems == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(6);
        }
        Set<GemDependency> dependencies = this.getRequirements();
        GemDependencyResolver resolver = this.getDependencyResolver(sdkGems, dependencies);
        Set<GemInfo> set = resolver.resolveDependencies();
        if (set == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public @NotNull Set<@NotNull GemDependency> getRequirements() {
        Set<GemDependency> set = ModuleGemDependencyProvider.EP_NAME.getExtensionList().stream().flatMap(provider -> provider.getGemDependencies(this.myModule).stream()).collect(Collectors.toSet());
        if (set == null) {
            ModuleGemInfrastructure.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public String getMissingGemMessage() {
        return this.getInfrastructure().getMissingGemMessage(this.myModule);
    }

    @TestOnly
    public boolean isDefaultGemInfrastructure() {
        return this.getInfrastructure() == GemInfrastructure.DEFAULT;
    }

    @TestOnly
    public boolean isBundlerGemInfrastructure() {
        return this.getInfrastructure() instanceof BundlerGemInfrastructure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runCallbackInNewTab";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/module/ModuleGemInfrastructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkGems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/ModuleGemInfrastructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfrastructure";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRequiredGems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installMissing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRequiredGems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

