/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.RubyMissingGemsNotificationService;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class GemUpdateUtil {
    private static final Logger LOG = Logger.getInstance(GemUpdateUtil.class);

    private GemUpdateUtil() {
    }

    public static void updateGemset(@NotNull Module module) {
        if (module == null) {
            GemUpdateUtil.$$$reportNull$$$0(0);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                return;
            }
            if (module.isDisposed()) {
                return;
            }
            GemManager.updateGemset(module, sdk);
            RbenvGemsetManager.refreshAttachedGemsetSdks(module);
            RMInspectionToolLaunchSettings inspectionToolLaunchSettings = RMInspectionToolLaunchSettings.getInstance();
            if (inspectionToolLaunchSettings.isActivated() && inspectionToolLaunchSettings.getVerboseLevel() > 0) {
                GemUpdateUtil.dumpAttachedGemsList(module);
            }
            application.executeOnPooledThread(() -> DaemonCodeAnalyzer.getInstance((Project)module.getProject()).restart((Object)"GemUpdateUtil.updateGemset"));
        });
    }

    public static void updateAndAttach(@NotNull Module module, @Nullable Boolean hasMissingGems) {
        if (module == null) {
            GemUpdateUtil.$$$reportNull$$$0(1);
        }
        if (module.isDisposed()) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            LOG.warn("No Sdk selected for " + String.valueOf(module));
            return;
        }
        Set<GemDependency> requirements = GemRequirementsHolder.getInstance(module).getRequirements();
        Project project = module.getProject();
        if (hasMissingGems != null && hasMissingGems.booleanValue() || hasMissingGems == null && !GemUtil.getMissingDependencies(sdk, module, requirements).isEmpty()) {
            RubyMissingGemsNotificationService.getInstance(project).notifyMissingGems();
        } else {
            RubyMissingGemsNotificationService.getInstance(project).tryExpire();
        }
        GemUpdateUtil.updateGemset(module);
    }

    public static boolean hasMissingGems(@NotNull Module module) {
        if (module == null) {
            GemUpdateUtil.$$$reportNull$$$0(2);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (Boolean.TRUE.equals(ModuleGemInfrastructure.getInstance(module).hasMissingGems(sdk))) {
            return true;
        }
        Set<GemDependency> requirements = GemRequirementsHolder.getInstance(module).getRequirements();
        Set<GemDependency> missing = GemUtil.getMissingDependencies(sdk, module, requirements);
        return !missing.isEmpty();
    }

    public static void dumpAttachedGemsList(@NotNull Module module) {
        if (module == null) {
            GemUpdateUtil.$$$reportNull$$$0(3);
        }
        System.out.println("\nFollowing gems were detected:\n");
        List<GemInfo> allGems = RubyProjectGemSearchService.Companion.getAllGems(module);
        if (allGems.isEmpty()) {
            System.out.println("    <no gems>");
        } else {
            for (GemInfo gemInfo : allGems) {
                System.out.println("    " + gemInfo.toString() + (gemInfo.isValid() ? "" : " [invalid]"));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "module";
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemUpdateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateGemset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAndAttach";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMissingGems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpAttachedGemsList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

