/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemDependency;

public final class GemRequirementsHolder {
    @Topic.ProjectLevel
    public static final Topic<RequirementsChangedListener> GEM_REQUIREMENTS_CHANGED_TOPIC = new Topic("Gem requirements changed", RequirementsChangedListener.class);
    private static final Logger LOG = Logger.getInstance(GemRequirementsHolder.class);
    private final Project myProject;
    private final Module myModule;
    private final MultiMap<VirtualFile, @NotNull GemDependency> mySource2Requirements;

    public GemRequirementsHolder(@NotNull Module module) {
        if (module == null) {
            GemRequirementsHolder.$$$reportNull$$$0(0);
        }
        this.mySource2Requirements = MultiMap.createConcurrentSet();
        this.myProject = module.getProject();
        this.myModule = module;
    }

    @NotNull
    public @NotNull Set<@NotNull GemDependency> getRequirements() {
        Set<GemDependency> set = Set.copyOf(this.mySource2Requirements.values());
        if (set == null) {
            GemRequirementsHolder.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void updateRequirements(@NotNull Collection<GemDependency> requirements, @NotNull VirtualFile sourceFile) {
        if (requirements == null) {
            GemRequirementsHolder.$$$reportNull$$$0(2);
        }
        if (sourceFile == null) {
            GemRequirementsHolder.$$$reportNull$$$0(3);
        }
        Set values = ConcurrentCollectionFactory.createConcurrentSet();
        values.addAll(requirements);
        this.mySource2Requirements.put((Object)sourceFile, (Collection)values);
        ((RequirementsChangedListener)this.myProject.getMessageBus().syncPublisher(GEM_REQUIREMENTS_CHANGED_TOPIC)).onRequirementsChanged(this.myModule);
    }

    public void removeRequirements(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            GemRequirementsHolder.$$$reportNull$$$0(4);
        }
        this.mySource2Requirements.remove((Object)sourceFile);
        ((RequirementsChangedListener)this.myProject.getMessageBus().syncPublisher(GEM_REQUIREMENTS_CHANGED_TOPIC)).onRequirementsChanged(this.myModule);
    }

    void clear() {
        this.mySource2Requirements.clear();
        ((RequirementsChangedListener)this.myProject.getMessageBus().syncPublisher(GEM_REQUIREMENTS_CHANGED_TOPIC)).onRequirementsChanged(this.myModule);
    }

    public void removeRequirementsFromDirectory(@NotNull VirtualFile directory) {
        if (directory == null) {
            GemRequirementsHolder.$$$reportNull$$$0(5);
        }
        if (!directory.isValid()) {
            LOG.warn("Invalid VirtualFile: " + String.valueOf(directory));
            return;
        }
        if (!directory.isDirectory()) {
            LOG.warn("Not a directory: " + String.valueOf(directory));
            return;
        }
        boolean requirementsChanged = false;
        for (VirtualFile knownSource : List.copyOf(this.mySource2Requirements.keySet())) {
            if (knownSource.isValid() && !VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)knownSource, (boolean)true)) continue;
            this.mySource2Requirements.remove((Object)knownSource);
            requirementsChanged = true;
        }
        if (requirementsChanged) {
            ((RequirementsChangedListener)this.myProject.getMessageBus().syncPublisher(GEM_REQUIREMENTS_CHANGED_TOPIC)).onRequirementsChanged(this.myModule);
        }
    }

    @NotNull
    public static GemRequirementsHolder getInstance(@NotNull Module module) {
        if (module == null) {
            GemRequirementsHolder.$$$reportNull$$$0(6);
        }
        GemRequirementsHolder gemRequirementsHolder = (GemRequirementsHolder)module.getService(GemRequirementsHolder.class);
        if (gemRequirementsHolder == null) {
            GemRequirementsHolder.$$$reportNull$$$0(7);
        }
        return gemRequirementsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateRequirements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeRequirements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRequirementsFromDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }

    public static interface RequirementsChangedListener {
        public void onRequirementsChanged(@NotNull Module var1);
    }
}

