/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.RunnableCallable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.GemScannerSuppressor;
import org.jetbrains.plugins.ruby.gem.module.GemUpdateUtil;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.security.RubyTrustedProjectService;
import org.jetbrains.plugins.ruby.util.ProjectQueues;

public final class GemRequirementsChangeWatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GemRequirementsChangeWatcher.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final ModuleRootManager myModuleRootManager;
    private final GemRequirementsHolder myHolder;
    private final Object myUnscannedLock;
    private volatile boolean isUpdateRunning;
    private final AtomicBoolean rescheduleUpdate;
    private final Set<VirtualFile> myUnscannedFiles;
    private final List<VirtualFile> myUnscannedDirectories;
    private final RailsApp myApp;
    @Nullable
    private VirtualFile myGemfile;
    private final PsiTreeChangeAdapter myAddGemRequirementUpdateListener;
    private MessageBusConnection myApplicationBusConnection;
    private MessageBusConnection myProjectBusConnection;
    private final AtomicBoolean myStarted;
    private volatile Disposable myDisposable;
    @NotNull
    private final ExecutorService mySequentialExecutor;

    public GemRequirementsChangeWatcher(@NotNull Module module) {
        if (module == null) {
            GemRequirementsChangeWatcher.$$$reportNull$$$0(0);
        }
        this.myUnscannedLock = new Object();
        this.rescheduleUpdate = new AtomicBoolean(false);
        this.myUnscannedFiles = new HashSet<VirtualFile>();
        this.myUnscannedDirectories = new ArrayList<VirtualFile>();
        this.myAddGemRequirementUpdateListener = new AddGemRequirementUpdateListener();
        this.myStarted = new AtomicBoolean(false);
        this.mySequentialExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"GemRequirementsChangeWatcherExecutor");
        this.myModule = module;
        this.myModuleRootManager = ModuleRootManager.getInstance((Module)this.myModule);
        this.myHolder = GemRequirementsHolder.getInstance(module);
        this.myApp = RailsApp.fromModule(this.myModule);
        Objects.requireNonNull(GemDetector.EXTENSION.getPoint()).addChangeListener(this::issueUpdate, (Disposable)this);
    }

    public void dispose() {
    }

    public static GemRequirementsChangeWatcher getInstance(Module module) {
        return (GemRequirementsChangeWatcher)module.getService(GemRequirementsChangeWatcher.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWatchers() {
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.myAddGemRequirementUpdateListener;
        synchronized (psiTreeChangeAdapter) {
            Disposable disposable;
            this.myDisposable = disposable = Disposer.newDisposable((Disposable)this);
            PsiManager.getInstance((Project)this.myModule.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myAddGemRequirementUpdateListener, disposable);
            LOG.assertTrue(this.myApplicationBusConnection == null);
            this.myApplicationBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableWatchers() {
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.myAddGemRequirementUpdateListener;
        synchronized (psiTreeChangeAdapter) {
            if (this.myDisposable != null) {
                Disposer.dispose((Disposable)this.myDisposable);
            }
            if (this.myProjectBusConnection != null) {
                Disposer.dispose((Disposable)this.myProjectBusConnection);
            }
            this.myProjectBusConnection = null;
            if (this.myApplicationBusConnection != null) {
                Disposer.dispose((Disposable)this.myApplicationBusConnection);
            }
            this.myApplicationBusConnection = null;
        }
    }

    private void addGemRequirementUpdate(PsiTreeChangeEvent event, boolean delete) {
        PsiFile file = GemRequirementsChangeWatcher.getFile(event);
        PsiElement parent = event.getParent();
        if (file != null) {
            if (delete && parent instanceof PsiDirectory && this.isMyUpdate((PsiFileSystemItem)parent)) {
                this.myHolder.removeRequirements(file.getVirtualFile());
            }
            if (!this.isMyUpdate((PsiFileSystemItem)file)) {
                return;
            }
            GemDetector detector = GemRequirementsChangeWatcher.getDetector(file);
            if (detector != null) {
                this.addFileScan(file.getVirtualFile());
            }
            return;
        }
        PsiDirectory directory = GemRequirementsChangeWatcher.getDirectory(event);
        if (directory != null && (delete && this.isMyUpdate((PsiFileSystemItem)parent) || this.isMyUpdate((PsiFileSystemItem)directory))) {
            if (!delete) {
                this.addDirectoryScan(directory.getVirtualFile());
            } else {
                this.myHolder.removeRequirementsFromDirectory(directory.getVirtualFile());
            }
        }
    }

    private boolean isMyUpdate(@Nullable PsiFileSystemItem fileOrDir) {
        if (fileOrDir == null || !fileOrDir.isValid()) {
            return false;
        }
        String name = fileOrDir.getName();
        VirtualFile virtualFile = fileOrDir.getVirtualFile();
        if (this.myGemfile != null && this.myGemfile.isValid() && !BundlerUtil.isGemfile(fileOrDir) && !GemUtil.isGemspecFile(virtualFile) && !BundlerUtil.isGemfileLockName(name)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)fileOrDir);
        if (module != this.myModule || !RModuleUtil.getInstance().hasRubySupport(module)) {
            return false;
        }
        return !this.isVendorFile(virtualFile);
    }

    private boolean isVendorFile(VirtualFile directory) {
        if (this.myApp == null) {
            return false;
        }
        return this.myApp.isVendorFile(directory);
    }

    @Nullable
    private Boolean detectAndAdd(@Nullable VirtualFile file) {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().holdsReadLock(), (Object)"no read access, scripts running ahead");
        GemDetector detector = GemRequirementsChangeWatcher.getDetector(file);
        return detector != null ? this.detectAndAdd(file, detector) : null;
    }

    @Nullable
    private Boolean detectAndAdd(@NotNull VirtualFile file, @NotNull GemDetector detector) {
        if (file == null) {
            GemRequirementsChangeWatcher.$$$reportNull$$$0(1);
        }
        if (detector == null) {
            GemRequirementsChangeWatcher.$$$reportNull$$$0(2);
        }
        Boolean hasMissing = null;
        Pair shouldScanAndSdk = (Pair)ReadAction.compute(() -> Pair.create((Object)this.shouldScanForRequirements(file, detector), (Object)RModuleUtil.getInstance().findRubySdkForModule(this.myModule)));
        if (((Boolean)shouldScanAndSdk.getFirst()).booleanValue()) {
            Sdk sdk = (Sdk)shouldScanAndSdk.getSecond();
            hasMissing = this.hasMissingGems(sdk);
            Set<GemDependency> reqs = detector.detect(this.myModule.getProject(), sdk, file);
            if (this.myModule.isDisposed()) {
                return null;
            }
            this.myHolder.updateRequirements(reqs, file);
        } else {
            this.myHolder.removeRequirements(file);
        }
        return hasMissing;
    }

    @Nullable
    private Boolean hasMissingGems(Sdk sdk) {
        RubyTrustedProjectService rubyTrustedProjectService = RubyTrustedProjectService.getInstance(this.myModule);
        if (!rubyTrustedProjectService.isTrusted()) {
            rubyTrustedProjectService.addTrustedProjectCallback(this.myModule, this, () -> this.issueUpdate());
        }
        return ModuleGemInfrastructure.getInstance(this.myModule).hasMissingGems(sdk);
    }

    @RequiresReadLock
    private boolean shouldScanForRequirements(@NotNull VirtualFile dependenciesFile, GemDetector detector) {
        if (dependenciesFile == null) {
            GemRequirementsChangeWatcher.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (this.myModule.isDisposed() || !dependenciesFile.isValid() || !this.myModuleRootManager.getFileIndex().isInContent(dependenciesFile) || !detector.accepts(dependenciesFile)) {
            return false;
        }
        if (this.myGemfile != null && this.myGemfile.isValid() && !dependenciesFile.equals(this.myGemfile) && !GemUtil.isGemspecFile(dependenciesFile)) {
            return false;
        }
        for (ModuleGemProvider provider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            if (!(provider instanceof DirectoryGemsProvider) || !((DirectoryGemsProvider)provider).isUnderDependenciesRoot(dependenciesFile, this.myModule)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null")
    public static GemDetector getDetector(PsiFile file) {
        return file != null ? (GemDetector)GemDetector.EXTENSION.forLanguage(file.getLanguage()) : null;
    }

    @Nullable
    private static GemDetector getDetector(VirtualFile file) {
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return (GemDetector)GemDetector.EXTENSION.forLanguage(((LanguageFileType)fileType).getLanguage());
    }

    @Nullable
    private static PsiFile getFile(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        PsiElement child = event.getChild();
        if (file == null && child instanceof PsiFile) {
            return (PsiFile)child;
        }
        return file;
    }

    @Nullable
    private static PsiDirectory getDirectory(PsiTreeChangeEvent event) {
        PsiElement candidate = event.getElement();
        PsiElement child = event.getChild();
        boolean isADirectory = candidate instanceof PsiDirectory;
        if (!isADirectory && child instanceof PsiDirectory) {
            return (PsiDirectory)child;
        }
        return isADirectory ? (PsiDirectory)candidate : null;
    }

    public void start() {
        if (this.myModule.isDisposed() || !RModuleUtil.getInstance().hasRubySupport(this.myModule) || !this.myStarted.compareAndSet(false, true)) {
            return;
        }
        if (GemRequirementsChangeWatcher.shouldUseWatchers()) {
            this.enableWatchers();
        }
        this.addScanner(() -> {
            this.myGemfile = BundlerUtil.getGemfile(this.myModule);
            this.scanForRequirements();
        });
    }

    private static boolean shouldUseWatchers() {
        return !RMInspectionToolLaunchSettings.getInstance().isActivated() && !RubyVMOptions.disableGemsScanner();
    }

    public void stop() {
        if (!this.myStarted.compareAndSet(true, false)) {
            return;
        }
        if (GemRequirementsChangeWatcher.shouldUseWatchers()) {
            this.disableWatchers();
        }
        this.addScanner(() -> {
            this.myGemfile = null;
            this.myHolder.clear();
            GemUpdateUtil.updateGemset(this.myModule);
        });
    }

    private void addScanner(@NotNull Runnable scanner) {
        if (scanner == null) {
            GemRequirementsChangeWatcher.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater(scanner);
            return;
        }
        this.mySequentialExecutor.execute(() -> DumbService.getInstance((Project)this.myModule.getProject()).repeatUntilPassesInSmartMode(() -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            scanner.run();
        }));
    }

    private void scanForRequirements() {
        if (this.myModule.isDisposed()) {
            return;
        }
        LOG.info("Initial scan started");
        long start = System.currentTimeMillis();
        this.myHolder.clear();
        Ref hasMissing = new Ref();
        if (this.myGemfile != null && this.myGemfile.isValid()) {
            hasMissing.set((Object)this.detectAndAdd(this.myGemfile));
        } else {
            VirtualFile[] contentRoots;
            for (VirtualFile contentRoot : contentRoots = this.myModuleRootManager.getContentRoots()) {
                GemRequirementsChangeWatcher.updateMissing((Ref<Boolean>)hasMissing, this.scanDirectory(contentRoot));
            }
        }
        LOG.info("Initial scan took: " + (System.currentTimeMillis() - start) + " ms");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected: " + String.valueOf(this.myHolder.getRequirements()));
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.myModule);
        Boolean hasMissingGems = hasMissing.isNull() ? this.hasMissingGems(sdk) : (Boolean)hasMissing.get();
        GemUpdateUtil.updateAndAttach(this.myModule, hasMissingGems);
    }

    private static void updateMissing(Ref<Boolean> hasMissing, Boolean aBoolean) {
        if (hasMissing.get() != null) {
            if (aBoolean != null) {
                hasMissing.set((Object)((Boolean)hasMissing.get() != false || aBoolean != false ? 1 : 0));
            }
        } else {
            hasMissing.set((Object)aBoolean);
        }
    }

    @Contract(value="null -> null")
    @Nullable
    private Boolean scanDirectory(@Nullable VirtualFile contentRoot) {
        if (contentRoot == null) {
            return null;
        }
        ArrayList filesToProcess = new ArrayList();
        ReadAction.nonBlocking((Callable)new RunnableCallable(() -> {
            if (this.myModule.isDisposed()) {
                return;
            }
            this.myModuleRootManager.getFileIndex().iterateContentUnderDirectory(contentRoot, fileOrDir -> {
                if (!fileOrDir.isValid() || fileOrDir.isDirectory() || GemRequirementsChangeWatcher.getDetector(fileOrDir) == null) {
                    return true;
                }
                filesToProcess.add(fileOrDir);
                return true;
            }, virtualFile -> !GemScannerSuppressor.isFileSuppressed(virtualFile, this.myModule));
        })).inSmartMode(this.myModule.getProject()).executeSynchronously();
        Ref hasMissing = new Ref();
        for (VirtualFile fileOrDir : filesToProcess) {
            if (((Boolean)ReadAction.compute(() -> this.myModule.isDisposed())).booleanValue()) {
                return null;
            }
            GemRequirementsChangeWatcher.updateMissing((Ref<Boolean>)hasMissing, this.detectAndAdd(fileOrDir));
        }
        return (Boolean)hasMissing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile[] pickUpScanTargets() {
        Object object = this.myUnscannedLock;
        synchronized (object) {
            VirtualFile[] scanTargets = new VirtualFile[this.myUnscannedFiles.size() + this.myUnscannedDirectories.size()];
            int i = 0;
            Iterator<VirtualFile> iterator = this.myUnscannedFiles.iterator();
            while (iterator.hasNext()) {
                VirtualFile file;
                scanTargets[i] = file = iterator.next();
                ++i;
            }
            iterator = this.myUnscannedDirectories.iterator();
            while (iterator.hasNext()) {
                VirtualFile directory;
                scanTargets[i] = directory = iterator.next();
                ++i;
            }
            this.myUnscannedFiles.clear();
            this.myUnscannedDirectories.clear();
            return scanTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileScan(VirtualFile file) {
        Object object = this.myUnscannedLock;
        synchronized (object) {
            if (this.isAlreadyScheduled(file)) {
                return;
            }
            this.myUnscannedFiles.add(file);
            this.issueUpdate();
        }
    }

    private boolean isAlreadyScheduled(VirtualFile file) {
        for (VirtualFile unscannedDirectory : this.myUnscannedDirectories) {
            if (!VfsUtilCore.isAncestor((VirtualFile)unscannedDirectory, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirectoryScan(VirtualFile directory) {
        Object object = this.myUnscannedLock;
        synchronized (object) {
            if (this.isAlreadyScheduled(directory) || this.isVendorFile(directory)) {
                return;
            }
            for (VirtualFile file : new ArrayList<VirtualFile>(this.myUnscannedFiles)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)file, (boolean)false)) continue;
                this.myUnscannedFiles.remove(file);
            }
            this.myUnscannedDirectories.add(directory);
            this.issueUpdate();
        }
    }

    private void issueUpdate() {
        if (!this.isUpdateRunning) {
            ProjectQueues.getInstance(this.myModule).queue("UpdateGemRequirementsQueue", new GemRequirementScan(), () -> new MergingUpdateQueue("UpdateGemRequirementsQueue", 5000, true, null).setRestartTimerOnAdd(true).usePassThroughInUnitTestMode());
        } else {
            this.rescheduleUpdate.set(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectAndAdd";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldScanForRequirements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addScanner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AddGemRequirementUpdateListener
    extends PsiTreeChangeAdapter {
        private AddGemRequirementUpdateListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.$$$reportNull$$$0(0);
            }
            GemRequirementsChangeWatcher.this.addGemRequirementUpdate(event, false);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.$$$reportNull$$$0(1);
            }
            GemRequirementsChangeWatcher.this.addGemRequirementUpdate(event, true);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.$$$reportNull$$$0(2);
            }
            GemRequirementsChangeWatcher.this.addGemRequirementUpdate(event, false);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.$$$reportNull$$$0(3);
            }
            GemRequirementsChangeWatcher.this.addGemRequirementUpdate(event, false);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.$$$reportNull$$$0(4);
            }
            GemRequirementsChangeWatcher.this.addGemRequirementUpdate(event, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$AddGemRequirementUpdateListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GemRequirementScan
    extends Update {
        GemRequirementScan() {
            super(GemRequirementsChangeWatcher.this.myUnscannedLock);
        }

        public void run() {
            if (GemRequirementsChangeWatcher.this.isUpdateRunning) {
                GemRequirementsChangeWatcher.this.rescheduleUpdate.set(true);
                return;
            }
            VirtualFile[] targets = GemRequirementsChangeWatcher.this.pickUpScanTargets();
            if (GemRequirementsChangeWatcher.this.myModule.getProject().isDisposed() || targets.length == 0) {
                return;
            }
            GemRequirementsChangeWatcher.this.addScanner(() -> {
                try {
                    GemRequirementsChangeWatcher.this.isUpdateRunning = true;
                    LOG.debug("Scanning " + targets.length + " targets");
                    Ref hasMissing = new Ref();
                    for (VirtualFile target : targets) {
                        boolean valid = (Boolean)ReadAction.compute(() -> target.isValid());
                        if (!valid) continue;
                        if (!target.isDirectory()) {
                            VirtualFile bundlerFile;
                            if (((Boolean)ReadAction.compute(() -> BundlerUtil.isGemfile(GemRequirementsChangeWatcher.this.myModule.getProject(), target))).booleanValue()) {
                                VirtualFile oldBundlerFile = GemRequirementsChangeWatcher.this.myGemfile;
                                GemRequirementsChangeWatcher.this.myGemfile = BundlerUtil.getGemfile(GemRequirementsChangeWatcher.this.myModule);
                                if (oldBundlerFile == null && GemRequirementsChangeWatcher.this.myGemfile != null && GemRequirementsChangeWatcher.this.myGemfile.isValid()) {
                                    GemRequirementsChangeWatcher.this.myHolder.clear();
                                }
                            }
                            VirtualFile file = (bundlerFile = GemRequirementsChangeWatcher.this.myGemfile) != null && GemUtil.isGemspecFile(target) ? bundlerFile : target;
                            GemRequirementsChangeWatcher.updateMissing((Ref<Boolean>)hasMissing, GemRequirementsChangeWatcher.this.detectAndAdd(file));
                            continue;
                        }
                        GemRequirementsChangeWatcher.updateMissing((Ref<Boolean>)hasMissing, GemRequirementsChangeWatcher.this.scanDirectory(target));
                    }
                    Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(GemRequirementsChangeWatcher.this.myModule);
                    Boolean hasMissingGems = hasMissing.isNull() ? GemRequirementsChangeWatcher.this.hasMissingGems(sdk) : (Boolean)hasMissing.get();
                    GemUpdateUtil.updateAndAttach(GemRequirementsChangeWatcher.this.myModule, hasMissingGems);
                }
                finally {
                    GemRequirementsChangeWatcher.this.isUpdateRunning = false;
                    if (GemRequirementsChangeWatcher.this.rescheduleUpdate.compareAndSet(true, false)) {
                        GemRequirementsChangeWatcher.this.issueUpdate();
                    }
                }
            });
        }
    }
}

