/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;

public final class GemImplicitRequireProvider
implements ImplicitRequireProvider {
    @Override
    @NotNull
    public Collection<VirtualFile> getLoadPath(@Nullable Module module, @NotNull VirtualFile file) {
        if (file == null) {
            GemImplicitRequireProvider.$$$reportNull$$$0(0);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            GemImplicitRequireProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getImplicitRequires(@NotNull Module module, PsiFile file) {
        if (module == null) {
            GemImplicitRequireProvider.$$$reportNull$$$0(2);
        }
        List<VirtualFile> list = GemImplicitRequireProvider.collectLoaderScripts(module, GemRequirementsHolder.getInstance(module).getRequirements());
        if (list == null) {
            GemImplicitRequireProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static List<VirtualFile> collectLoaderScripts(Module module, Collection<? extends GemDependency> requirements) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (GemDependency gemDependency : requirements) {
            VirtualFile folder;
            GemInfo gem = module != null ? RubyProjectGemSearchService.Companion.findGem(module, gemDependency) : null;
            if (gem == null || (folder = gem.getLibFolder()) == null) continue;
            String dependencyLibScript = gemDependency.getLibScript();
            if (!gemDependency.doRequire()) continue;
            String libScriptNameWE = dependencyLibScript != null ? dependencyLibScript : gemDependency.getName();
            VirtualFile scriptToRequire = folder.findFileByRelativePath(libScriptNameWE + ".rb");
            if (scriptToRequire == null && (scriptToRequire = folder.findFileByRelativePath(libScriptNameWE)) != null && scriptToRequire.isDirectory()) {
                scriptToRequire = null;
            }
            if (scriptToRequire == null) continue;
            result.add(scriptToRequire);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/module/GemImplicitRequireProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemImplicitRequireProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitRequires";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoadPath";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitRequires";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

