/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.isolate;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.gems.GemsWithSpecsProvider;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class IsolateGemsProvider
extends GemsWithSpecsProvider {
    private static final String DEFAULT_ISOLATION = "tmp/isolate";

    @Override
    protected VirtualFile getGemPathDirectory(Module module) {
        if (module.isDisposed()) {
            return null;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            return null;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            String version;
            VirtualFile isolation = root.findFileByRelativePath(DEFAULT_ISOLATION);
            if (isolation == null) continue;
            String sdkType = BundlerUtil.getSdkTypeStr(sdk);
            VirtualFile sdkDir = isolation.findChild(sdkType + "-" + (version = BundlerUtil.getGemSdkVersion(sdk)));
            return sdkDir != null ? sdkDir : isolation;
        }
        return null;
    }
}

