/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemReference;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.InstallGemQuickFix;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RemoveRequirementQuickFix;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;

public class GemReferenceVisitor
extends RubyInspectionVisitor {
    private boolean myDefinitelyHasMissingGems;
    private boolean hasMissingCalculated = false;

    public GemReferenceVisitor(ProblemsHolder holder) {
        super(holder);
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        super.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
    }

    @Override
    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            GemReferenceVisitor.$$$reportNull$$$0(0);
        }
        this.inspectElement(this, (PsiElement)rCall, false);
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            GemReferenceVisitor.$$$reportNull$$$0(1);
        }
        this.inspectElement(this, (PsiElement)rDStringLiteral, rDStringLiteral.hasExpressionSubstitutions());
    }

    public void visitRConstant(@NotNull RConstant constant) {
        GemDependency dependency;
        if (constant == null) {
            GemReferenceVisitor.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (!"RAILS_GEM_VERSION".equals(constant.getText())) {
            return;
        }
        RAssignmentExpression assign = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)constant);
        if (assign == null) {
            return;
        }
        RPsiElement value = assign.getValue();
        String text = value instanceof RStringLiteral ? TextUtil.removeQuoting((String)value.getText()) : null;
        GemDependency gemDependency = dependency = text != null ? GemDependency.create("rails", text) : null;
        if (dependency == null) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)constant);
        if (module != null && RailsFacetUtil.hasRailsSupport(module) && RubyProjectGemSearchService.Companion.findGem(module, dependency) == null) {
            GemReferenceVisitor.createWarning(this, (PsiElement)assign, "rails", dependency);
        }
    }

    public void inspectElement(RubyInspectionVisitor visitor, PsiElement psiElement, boolean isDynamicallyGeneratedValue) {
        GemDependency dep;
        GemReference gemReference = GemReferenceVisitor.findGemReference(psiElement);
        if (gemReference == null || isDynamicallyGeneratedValue || gemReference.hasDynamicSubstitutions() || ModuleUtilCore.findModuleForPsiElement((PsiElement)gemReference.getElement()) == null) {
            return;
        }
        this.calculateAndUpdateHasMissing(psiElement);
        PsiElement element = gemReference.resolve();
        GemDependency gemDependency = dep = element == null ? gemReference.getDependency(this.myDefinitelyHasMissingGems) : null;
        if (dep != null) {
            String gemName = gemReference.getGemName();
            GemReferenceVisitor.createWarning(visitor, psiElement, gemName, dep);
        }
    }

    protected static void createWarning(RubyInspectionVisitor visitor, PsiElement psiElement, String gemName, GemDependency requirement) {
        Sdk sdk;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile != null && !gemFile.equals(PsiUtilCore.getVirtualFile((PsiElement)psiElement))) {
            return;
        }
        Sdk sdk2 = sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        if (!requirement.canBeSatisfied()) {
            visitor.registerProblem(psiElement, RBundle.message((String)"gems.inspection.requirement.not.satisfiable", (Object[])new Object[]{gemName}), new RemoveRequirementQuickFix());
            return;
        }
        if (sdk != null) {
            boolean isGitOrFromPath;
            if (!requirement.isSupportedBySdk(sdk)) {
                if (psiElement.getParent() instanceof RModifierStatement || requirement.getPlatforms() != null) {
                    return;
                }
                visitor.registerProblem(psiElement, RBundle.message((String)"gems.inspection.gem.not.supported.by.sdk", (Object[])new Object[]{gemName, sdk.getName()}), new LocalQuickFix[0]);
                return;
            }
            GemInfo gem = RubyGemSearchUtil.findGem(module, sdk, requirement);
            if (gem != null) {
                return;
            }
            GemInfo gemByName = RubyGemSearchUtil.findGem(module, sdk, gemName);
            String errorMessage = gemByName == null ? RBundle.message((String)"gems.inspection.gem.not.available", (Object[])new Object[]{gemName, sdk.getName()}) : RBundle.message((String)"gems.inspection.gem.with.requirements.not.available", (Object[])new Object[]{gemName, sdk.getName()});
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (gemFile != null) {
                fixes.addAll(RubySdkConfigurator.notNullFrom(sdk).getBundleInstallQuickFixes(sdk, module));
            }
            boolean bl = isGitOrFromPath = requirement.isFromPath() || requirement.isGit();
            if (gemFile == null && !isGitOrFromPath) {
                fixes.add(new InstallGemQuickFix(sdk, module, requirement));
            }
            if (!fixes.isEmpty()) {
                visitor.registerProblem(psiElement, errorMessage, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                visitor.registerProblem(psiElement, RBundle.message((String)"gems.inspection.git.dependency.not.allowed"), new LocalQuickFix[0]);
            }
        } else {
            visitor.registerProblem(psiElement, RBundle.message((String)"gems.inspection.gem.no.sdk", (Object[])new Object[]{gemName}), new LocalQuickFix[0]);
        }
    }

    @Nullable
    public static GemReference findGemReference(PsiElement psiElement) {
        PsiReference[] references;
        ProgressManager.checkCanceled();
        RCall call = RubyPsiUtil.getCoveringRCall(psiElement);
        if (call == null || call.getCallType() != GemCallTypeProvider.GEM_CALL) {
            return null;
        }
        for (PsiReference reference : references = psiElement.getReferences()) {
            if (!(reference instanceof GemReference)) continue;
            return (GemReference)reference;
        }
        return null;
    }

    private void calculateAndUpdateHasMissing(PsiElement element) {
        if (this.hasMissingCalculated) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        VirtualFile gemFile = BundlerUtil.getGemfile(module);
        if (gemFile != null && gemFile.equals(element.getContainingFile().getVirtualFile())) {
            this.myDefinitelyHasMissingGems = BundlerGemInfrastructure.hasMissingGems(gemFile);
        }
        this.hasMissingCalculated = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDStringLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/inspection/GemReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDStringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

