/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.inspection;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemReference;
import org.jetbrains.plugins.ruby.gem.inspection.GemReferenceVisitor;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public abstract class BaseGemfileGemRefVisitor
extends RubyInspectionVisitor {
    public BaseGemfileGemRefVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            BaseGemfileGemRefVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            BaseGemfileGemRefVisitor.$$$reportNull$$$0(1);
        }
        this.inspectElement((PsiElement)rCall);
    }

    public void inspectElement(PsiElement psiElement) {
        PsiFile containingPsiFile = psiElement.getContainingFile();
        if (!BundlerUtil.isGemfile((PsiFileSystemItem)containingPsiFile)) {
            return;
        }
        if (!(containingPsiFile instanceof RFile)) {
            return;
        }
        GemReference gemReference = GemReferenceVisitor.findGemReference(psiElement);
        if (gemReference == null || gemReference.hasDynamicSubstitutions() || ModuleUtilCore.findModuleForPsiElement((PsiElement)gemReference.getElement()) == null) {
            return;
        }
        String gemName = gemReference.getGemName();
        GemDependency gemDependency = gemReference.getDependency(true);
        this.inspectGemDependency(psiElement, gemName, gemDependency, (RFile)containingPsiFile);
    }

    protected abstract void inspectGemDependency(PsiElement var1, @NotNull String var2, @Nullable GemDependency var3, @NotNull RFile var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/inspection/BaseGemfileGemRefVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

