/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.gem;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.Console;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.gem.GemListParser;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyScriptRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public final class GemRunner {
    public static final String CANCELLED = "Cancelled";
    public static final String USER_INSTALL = "--user-install";
    private static final Logger LOG = Logger.getInstance(GemRunner.class);
    @NonNls
    private static final String GEM_EXECUTABLE_NAME = "gem";
    @NonNls
    private static final String GEMBAT_EXECUTABLE_NAME = "gem.bat";
    @NonNls
    private static final String JGEM_EXECUTABLE_NAME = "jgem";
    @NonNls
    private static final String IGEM_EXECUTABLE_NAME = "igem";
    @NonNls
    private static final String GEM19_EXECUTABLE_NAME = "gem19";
    @NonNls
    private static final String GEM1DOT9_EXECUTABLE_NAME = "gem1.9";
    @NonNls
    private static final String GEM18_EXECUTABLE_NAME = "gem18";
    @NonNls
    private static final String GEM1DOT8_EXECUTABLE_NAME = "gem1.8";
    @NonNls
    private static final String MACGEM_EXECUTABLE_NAME = "macgem";
    @NonNls
    private static final String ERROR = "ERROR: ";
    @NonNls
    private static final Pattern INSTALLED = Pattern.compile("\\d*\\s*gem[s]?\\s*installed");
    private static final String RUBY19_VERSION_SIGNATURE = ".9";
    private static final String RUBY18_VERSION_SIGNATURE = ".8";
    private static final String MACRUBY_VERSION_SIGNATURE = "macruby";
    public static final String STRIP_NON_RUBY_CODE_OPTION = "-x";
    public static final int GEM_PATH_TIMEOUT = 30;
    private static final Pattern INVALID_GEMSPEC_PATTERN = Pattern.compile("Invalid gemspec in\\s\\[(.*)\\]: invalid (\\w+) format in specification.*");
    @NonNls
    private static final String BUNDLER_INTEGRATION_NOTIFICATION_GROUP_ID = "Bundler Integration";
    private static boolean ALLOW_PRE_RELEASE_IN_TESTS = false;
    public static final String JRUBY_LOG_EXCEPTIONS_OPTION = "-Xlog.exceptions";

    private GemRunner() {
    }

    @RequiresEdt
    public static void bundle(@Nullable Module module, @NotNull Sdk sdk, @Nullable String action, @Nullable String customAction, @Nullable VirtualFile customWorkingDirectory, @Nullable Runnable postFlightAction, @Nullable String additionalOptions) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GemRunner.bundle(module, sdk, action, customAction, customWorkingDirectory, postFlightAction, new AtomicBoolean(false), additionalOptions);
    }

    @RequiresEdt
    public static void bundle(@Nullable Module module, @NotNull Sdk sdk, @Nullable String action, @Nullable String customAction, @Nullable VirtualFile customWorkingDirectory, @Nullable Runnable postFlightAction, @NotNull AtomicBoolean postFlightActionNewTab, @Nullable String additionalOptions) {
        String script;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(1);
        }
        if (postFlightActionNewTab == null) {
            GemRunner.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (action == null) {
            script = GemRunner.getGemExecutableName(sdk, RubySdkAdditionalData.getInterpreterDir(sdk));
            action = customAction == null ? "bundle" : customAction;
        } else {
            script = BundlerUtil.getBundlerScriptPath(sdk, module);
        }
        if (StringUtil.isEmpty((String)script)) {
            String message = "Unable to find bundler script, can't run action: module=%s; sdk=%s; action=%s; customAction=%s; customWorkingDirectory=%s; additionalOptions=%s".formatted(module, sdk, action, customAction, customWorkingDirectory, additionalOptions);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
            Notifications.Bus.notify((Notification)new Notification(BUNDLER_INTEGRATION_NOTIFICATION_GROUP_ID, RBundle.message((String)"bundler.notification.error.title"), RBundle.message((String)"bundler.notification.error.message"), NotificationType.ERROR), (Project)(module == null ? null : module.getProject()));
            return;
        }
        ArrayList<String> scriptParams = new ArrayList<String>();
        if (additionalOptions != null && additionalOptions.contains("--path") && JRubySdkUtil.isJRubySDK(sdk) && !JRubySdkUtil.isJRubyGreaterThan17(sdk)) {
            scriptParams.add("-r");
            scriptParams.add("openssl");
        }
        scriptParams.add(RubySdkUtil.convertToRemote(sdk, module, RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(script)));
        scriptParams.add(action);
        if (!StringUtil.isEmpty((String)additionalOptions)) {
            Collections.addAll(scriptParams, ParametersList.parse((String)additionalOptions));
        }
        GemRunner.runBundler(module, sdk, postFlightAction, postFlightActionNewTab, customWorkingDirectory, ArrayUtilRt.toStringArray(scriptParams));
    }

    @Nullable
    public static String getRawEnvironment(@Nullable Module module, @NotNull Sdk sdk) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(3);
        }
        ProcessOutput output2 = GemRunner.run(sdk, module, null, Collections.singletonList("environment"), RBundle.message((String)"gems.reading.environment", (Object[])new Object[]{sdk}), 30);
        return GemRunner.checkGemEnvironmentOutputPresence(sdk, output2);
    }

    @Nullable
    public static String checkGemEnvironmentOutputPresence(@NotNull Sdk sdk, @Nullable ProcessOutput output2) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(4);
        }
        if (output2 == null) {
            return null;
        }
        String stdout = output2.getStdout();
        if (StringUtil.isEmpty((String)stdout)) {
            if (StringUtil.isNotEmpty((String)output2.getStderr())) {
                LOG.warn("Error getting raw environment for " + String.valueOf(sdk) + ": " + output2.getStderr());
            } else {
                LOG.warn("Environment is empty for " + String.valueOf(sdk));
            }
            return null;
        }
        return !stdout.contains("LoadError") ? stdout.trim() : null;
    }

    @Nullable
    public static String list(@Nullable Module module, @NotNull Sdk sdk, @Nullable String url, @Nullable BooleanSupplier shouldCancelFun, @NotNull String gemVersion) {
        String stdout;
        String title;
        boolean oldGems;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(5);
        }
        if (gemVersion == null) {
            GemRunner.$$$reportNull$$$0(6);
        }
        @NonNls ArrayList<String> args = new ArrayList<String>();
        args.add("list");
        args.add("--remote");
        args.addAll(GemRunner.getProxyParameters());
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.1.0") >= 0) {
            args.add("--all");
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() || ALLOW_PRE_RELEASE_IN_TESTS) {
            GemRunner.addPrereleaseOption(gemVersion, args);
        }
        boolean bl = oldGems = VersionComparatorUtil.compare((String)gemVersion, (String)"1.2.0") < 0;
        if (oldGems) {
            args.add("--details");
        }
        if (!StringUtil.isEmpty((String)url)) {
            args.add("--source");
            args.add(url);
            title = RBundle.message((String)"gems.gem.listing.remote.url", (Object[])new Object[]{url});
        } else {
            title = RBundle.message((String)"gems.gem.listing.remote");
        }
        ProcessOutput output2 = GemRunner.run(sdk, module, shouldCancelFun, args, title, -1);
        if (output2 == null) {
            return null;
        }
        String stderr = output2.getStderr();
        if (!StringUtil.isEmpty((String)stderr)) {
            if (GemRunner.prereleaseNotSupported(stderr)) {
                return GemRunner.list(module, sdk, url, shouldCancelFun, "1.3.3");
            }
            if (module != null && !module.isDisposed()) {
                @NlsSafe Object text = stderr.replace(ERROR, "");
                List<GemspecError> gemspecErrors = ((String)(text = ((String)text).replace("While executing gem ...", ""))).contains("Invalid gemspec") ? GemRunner.collectGemSpecErrors((String)text) : Collections.emptyList();
                text = ((String)text).replace("\n", "<br>");
                text = ((String)text).contains("stack level too deep (SystemStackError)") ? (String)text + "Please consider running <code>gem update --system</code>" : (String)text + "<br>Please check proxy settings and gem urls";
                Notifications.Bus.notify((Notification)new InvalidGemsNotification("Gem Manager", RBundle.message((String)"notification.title.failed.to.load.remote.gems", (Object[])new Object[]{url}), (String)text, NotificationType.WARNING, module.getProject(), gemspecErrors), (Project)module.getProject());
            }
        }
        if (StringUtil.isEmpty((String)(stdout = output2.getStdout()))) {
            return null;
        }
        return stdout;
    }

    @NotNull
    private static List<GemspecError> collectGemSpecErrors(String text) {
        ArrayList<GemspecError> result = new ArrayList<GemspecError>();
        for (String string : text.split("\\n")) {
            Matcher matcher = INVALID_GEMSPEC_PATTERN.matcher(string);
            if (!matcher.matches()) continue;
            result.add(new GemspecError(matcher.group(1), matcher.group(2)));
        }
        ArrayList<GemspecError> arrayList = result;
        if (arrayList == null) {
            GemRunner.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean prereleaseNotSupported(String stderr) {
        return stderr.contains("Prereleases not supported on legacy repositories") || stderr.contains("bad response") && stderr.contains("prerelease_specs");
    }

    private static void addPrereleaseOption(String gemVersion, List<String> args) {
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.3.4") >= 0) {
            args.add("--prerelease");
        }
    }

    @NotNull
    public static List<GemInfo> query(@Nullable Module module, @NotNull Sdk sdk, @Nullable String url, @Nullable BooleanSupplier shouldCancelFun, @Nullable String gemName) {
        String stdout;
        String title;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(8);
        }
        String gemsVersion = RubyGemsEnvironment.get(sdk).getRubyGemsVersion();
        @NonNls ArrayList<String> args = new ArrayList<String>();
        args.add("query");
        args.add("--remote");
        args.addAll(GemRunner.getProxyParameters());
        args.add("--details");
        args.add("--all");
        if (!ApplicationManager.getApplication().isUnitTestMode() || ALLOW_PRE_RELEASE_IN_TESTS) {
            GemRunner.addPrereleaseOption(gemsVersion, args);
        }
        args.add("--name-matches");
        args.add("^" + gemName + "$");
        if (!StringUtil.isEmpty((String)url)) {
            args.add("--source");
            args.add(url);
            title = RBundle.message((String)"gems.gem.listing.remote.url", (Object[])new Object[]{url});
        } else {
            title = RBundle.message((String)"gems.gem.listing.remote");
        }
        ProcessOutput output2 = GemRunner.run(sdk, module, shouldCancelFun, args, title, -1);
        if (output2 == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got null output from query module=" + String.valueOf(module) + "; sdk=" + String.valueOf(sdk) + "; arguments=" + String.valueOf(args));
            }
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemRunner.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got output from query module=" + String.valueOf(module) + "; sdk=" + String.valueOf(sdk) + "; arguments=" + String.valueOf(args) + "; \nexitCode=" + output2.getExitCode() + "; \nstdout=" + output2.getStdout() + "; \nstderr=" + output2.getStderr());
        }
        if (StringUtil.isEmpty((String)(stdout = output2.getStdout()))) {
            LOG.debug("Empty result");
            List<GemInfo> list = Collections.emptyList();
            if (list == null) {
                GemRunner.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<GemInfo> gemInfos = GemListParser.parse(stdout, url != null ? url : "", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsed as: " + String.valueOf(gemInfos));
        }
        List<GemInfo> list = gemInfos;
        if (list == null) {
            GemRunner.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static List<String> getProxyParameters() {
        String proxy = GemRunner.getCurrentHttpProxy();
        if (proxy == null) {
            return Collections.emptyList();
        }
        return Arrays.asList("--http-proxy", proxy);
    }

    @Nullable
    public static String getCurrentHttpProxy() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        if (instance == null || !instance.USE_HTTP_PROXY) {
            return null;
        }
        String host = instance.PROXY_HOST;
        int port = instance.PROXY_PORT;
        if (!StringUtil.isEmpty((String)host)) {
            StringBuilder hostname = new StringBuilder();
            hostname.append(URLUtil.containsScheme((String)host) ? "" : "http://");
            if (instance.PROXY_AUTHENTICATION) {
                hostname.append(instance.getProxyLogin());
                String password = instance.getPlainProxyPassword();
                if (!StringUtil.isEmpty((String)password)) {
                    hostname.append(":").append(password);
                }
                hostname.append("@");
            }
            hostname.append(host);
            if (port > 0) {
                hostname.append(":").append(port);
            }
            return hostname.toString();
        }
        return null;
    }

    @Nullable
    private static ProcessOutput run(@NotNull Sdk sdk, @Nullable Module module, @Nullable BooleanSupplier shouldCancelFun, @NotNull List<@NlsSafe String> args, @NotNull String progressTitle, int timeout) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(12);
        }
        if (args == null) {
            GemRunner.$$$reportNull$$$0(13);
        }
        if (progressTitle == null) {
            GemRunner.$$$reportNull$$$0(14);
        }
        try {
            String scriptPath;
            String binPath;
            boolean isCancellable = ProgressManager.getInstance().getProgressIndicator() != null || shouldCancelFun != null;
            ExecutionModes.SameThreadMode mode = new ExecutionModes.SameThreadMode(isCancellable, progressTitle, timeout);
            if (shouldCancelFun != null) {
                mode.setShouldCancelFun(shouldCancelFun);
            }
            if (!GemRunner.checkPaths(sdk, binPath = RubySdkAdditionalData.getInterpreterDir(sdk), scriptPath = GemRunner.getGemExecutableName(sdk, binPath))) {
                return null;
            }
            RubyRunner runner = RubySdkUtil.getRubySdkAdditionalData(sdk).getRunner(module);
            ArrayList arguments = Lists.newArrayListWithCapacity((int)(args.size() + 1));
            if (!GemRunner.isGemNativeBinary(sdk) && !ShimsBasedVersionManagerHandler.is(sdk)) {
                arguments.add(RubySdkAdditionalData.getInterpreterPathFor(sdk));
                if (GemRunner.shouldUseStripNonRubyTextOption(sdk)) {
                    arguments.add(STRIP_NON_RUBY_CODE_OPTION);
                }
            }
            arguments.add(RubySdkUtil.convertToRemote(sdk, module, RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(scriptPath)));
            arguments.addAll(args);
            return runner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, (List<String>)arguments).withExecutionMode((ExecutionMode)mode)).withModule(module)).withWorkingDirPath(RubySdkUtil.convertToRemote(sdk, module, binPath)));
        }
        catch (ProcessCanceledException e) {
            LOG.debug("process canceled", (Throwable)e);
        }
        catch (RemoteSdkException e) {
            LOG.warn((Throwable)e);
            Notifications.Bus.notify((Notification)new Notification("Gem Manager", PlatformUtils.isRubyMine() ? RBundle.message((String)"gems.gem.manager") : RBundle.message((String)"gems.ruby.gem.manager"), RBundle.message((String)"gems.gem.running.remote.error.message", (Object[])new Object[]{e.getMessage()}), NotificationType.WARNING), (Project)RModuleUtil.getInstance().getProject(module));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private static boolean checkPaths(@NotNull Sdk sdk, @NotNull String binPath, @NotNull String scriptPath) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(15);
        }
        if (binPath == null) {
            GemRunner.$$$reportNull$$$0(16);
        }
        if (scriptPath == null) {
            GemRunner.$$$reportNull$$$0(17);
        }
        return RubyRemoteInterpreterManager.isRemoteSdk(sdk) || new File(binPath).exists() && new File(scriptPath).exists() && RubySdkUtil.isRubyInterpreterExist(sdk);
    }

    private static boolean isGemNativeBinary(Sdk sdk) {
        return RubySdkUtil.isRubinius(sdk) && VersionComparatorUtil.compare((String)RubyVersionUtil.getRubiniusShortVersion(sdk.getVersionString()), (String)"2.0.0pre") >= 0;
    }

    @TestOnly
    public static void uninstall(@NotNull Sdk sdk, @NotNull Collection<GemInfo> gemsToUninstall, @NotNull List<String> additionalArguments) throws ExecutionException {
        ProcessOutput output2;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(18);
        }
        if (gemsToUninstall == null) {
            GemRunner.$$$reportNull$$$0(19);
        }
        if (additionalArguments == null) {
            GemRunner.$$$reportNull$$$0(20);
        }
        if (gemsToUninstall.isEmpty()) {
            return;
        }
        LOG.debug("Uninstalling " + String.valueOf(gemsToUninstall));
        List gemsSpecifications = ContainerUtil.map(gemsToUninstall, it -> String.join((CharSequence)":", it.getName(), it.getVersion()));
        List arguments = ContainerUtil.newArrayList((Object[])new String[]{"uninstall", "-a", STRIP_NON_RUBY_CODE_OPTION, "-I", "-V", "--backtrace"});
        arguments.addAll(additionalArguments);
        arguments.addAll(gemsSpecifications);
        if (!RubySdkAdditionalData.areGemsUserLocal(sdk)) {
            arguments = ContainerUtil.append((List)arguments, (Object[])new String[]{USER_INSTALL});
        }
        if ((output2 = ((RubyScriptExecutionContext)RubyScriptExecutionContext.create(GemRunner.getGemExecutableName(sdk, RubySdkAdditionalData.getInterpreterDir(sdk)), sdk).withArguments(arguments)).executeScript()) == null) {
            throw new ExecutionException("Output was null");
        }
        LOG.debug("Exit code: " + output2.getExitCode());
        output2.getStdoutLines().forEach(it -> LOG.debug("stdout: " + it));
        output2.getStderrLines().forEach(it -> LOG.debug("stderr: " + it));
        if (output2.getExitCode() != 0) {
            LOG.warn("There were issues while uninstalling gems: " + String.valueOf(gemsToUninstall) + "; output: " + String.valueOf(output2));
        }
    }

    public static Pair<Boolean, String> install(@Nullable Module module, @NotNull Sdk sdk, @NotNull GemDependency dependency, @NotNull GemInstallCommandOptions options) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(21);
        }
        if (dependency == null) {
            GemRunner.$$$reportNull$$$0(22);
        }
        if (options == null) {
            GemRunner.$$$reportNull$$$0(23);
        }
        Pair<List<String>, String> argsAndWorkDir = GemRunner.computeInstallOptionsAndWorkDir(module, sdk, dependency, options);
        List<String> command = GemRunner.createGemInvocationCommand(sdk, (List)argsAndWorkDir.first, module);
        if (command == null) {
            String sdkHomePath = RubySdkAdditionalData.getInterpreterPathFor(sdk);
            return Pair.create((Object)false, (Object)RBundle.message((String)"sdk.error.home.path.doesnt.exists", (Object[])new Object[]{sdkHomePath, sdk.getName()}));
        }
        RubyRunner runner = RunnerUtil.getRunner(sdk, module);
        String workingDir = (String)argsAndWorkDir.second;
        RubyCommandLine commandLine = runner.createCommandLine((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, command).withWorkingDirPath(RubySdkUtil.convertToRemote(sdk, module, workingDir == null ? RubySdkAdditionalData.getInterpreterDir(sdk) : workingDir)));
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText(RBundle.message((String)"gems.gem.installing.gem", (Object[])new Object[]{dependency.getDescription()}));
        progressIndicator.setText2(RBundle.message((String)"gems.gem.running.command", (Object[])new Object[]{commandLine.getCommandLineString()}));
        Ref resultRef = Ref.create((Object)Pair.create((Object)false, (Object)CANCELLED));
        GemRunner.runInstall(sdk, module, GemRunner.createProcessAdapter((Ref<Pair<Boolean, String>>)resultRef, progressIndicator), commandLine);
        LOG.debug("Result of installation ", new Object[]{dependency, " to ", sdk, " in ", module, " is ", resultRef.get()});
        return (Pair)resultRef.get();
    }

    @NotNull
    @NonNls
    private static Pair<List<String>, String> computeInstallOptionsAndWorkDir(@Nullable Module module, @NotNull Sdk sdk, @NotNull GemDependency dependency, GemInstallCommandOptions options) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(24);
        }
        if (dependency == null) {
            GemRunner.$$$reportNull$$$0(25);
        }
        String gemVersion = RubyGemsEnvironment.get(sdk).getRubyGemsVersion();
        String name = dependency.getCanonicalName();
        VirtualFile moduleRoot = RModuleUtil.getInstance().getFirstContentRoot(module);
        String workingDir = dependency.isRawGem() ? dependency.getRawGemDir() : (String)ObjectUtils.doIfNotNull((Object)moduleRoot, it -> it.getPath());
        @NonNls ArrayList<String> args = new ArrayList<String>();
        args.add(name);
        if (!dependency.isAny()) {
            args.add("--version");
            String version = dependency.getVersionString();
            args.add(RubySdkUtil.isMaglev(sdk) ? version.replace(" ", "") : version);
        }
        if (options.getNoDocument()) {
            if (VersionComparatorUtil.compare((String)gemVersion, (String)"3.0.0") >= 0) {
                args.add("--no-document");
            } else {
                args.add("--no-rdoc");
                args.add("--no-ri");
            }
        }
        if (!dependency.isRawGem()) {
            args.addAll(GemRunner.getProxyParameters());
        }
        if (options.getIgnoreDependencies()) {
            args.add("--ignore-dependencies");
        } else if (VersionComparatorUtil.compare((String)gemVersion, (String)"0.9.5") < 0) {
            args.add("--include-dependencies");
        }
        if (StringUtil.isNotEmpty((String)options.getInstallDir())) {
            args.add("--install-dir");
            args.add(options.getInstallDir());
        } else if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.3.6") >= 0 && !RubySdkAdditionalData.areGemsUserLocal(sdk)) {
            args.add(USER_INSTALL);
        }
        for (String source : options.getSources()) {
            args.add("--source");
            args.add(source);
        }
        if (options.getForce()) {
            args.add("--force");
        }
        Pair pair = Pair.create(args, (Object)workingDir);
        if (pair == null) {
            GemRunner.$$$reportNull$$$0(26);
        }
        return pair;
    }

    @NotNull
    private static ProcessListener createProcessAdapter(final @NotNull Ref<Pair<Boolean, String>> result, final @NotNull ProgressIndicator progressIndicator) {
        if (result == null) {
            GemRunner.$$$reportNull$$$0(27);
        }
        if (progressIndicator == null) {
            GemRunner.$$$reportNull$$$0(28);
        }
        final HashMap buffersMap = new HashMap();
        final HashMap debugBuffersMap = new HashMap();
        return new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.debug("Process started: " + String.valueOf(event.getProcessHandler()));
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (LOG.isDebugEnabled() && (result.isNull() || !((Boolean)((Pair)result.get()).first).booleanValue())) {
                    debugBuffersMap.forEach((key, sb) -> LOG.debug("Process output (%s): %s\n%s".formatted(key, event.getProcessHandler(), sb)));
                }
                LOG.debug("Process terminated (exit code ", new Object[]{event.getExitCode(), "): ", event.getProcessHandler()});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(3);
                }
                String outputTextChunk = event.getText();
                StringBuilder buffer = buffersMap.computeIfAbsent(outputType, key -> new StringBuilder());
                buffer.append(GemRunner.convertFromConsoleEncoding(outputTextChunk));
                if (LOG.isDebugEnabled()) {
                    StringBuilder sb = debugBuffersMap.computeIfAbsent(outputType, __ -> new StringBuilder());
                    sb.append(GemRunner.convertFromConsoleEncoding(outputTextChunk));
                    if (sb.length() >= 1000000 && sb.charAt(sb.length() - 1) == '\n') {
                        LOG.debug("Process partial output (%s): %s\n%s".formatted(outputType, event.getProcessHandler(), sb));
                        debugBuffersMap.remove(outputType);
                    }
                }
                if (!outputTextChunk.endsWith("\n")) {
                    return;
                }
                @NlsSafe String outputLine = buffer.toString();
                buffer.delete(0, buffer.length());
                Ref ref = result;
                synchronized (ref) {
                    Pair pair = (Pair)result.get();
                    if (INSTALLED.matcher(TextUtil.chomp((String)outputLine)).matches()) {
                        LOG.debug("Matched as INSTALLED: ", new Object[]{outputLine});
                        if (pair.second != null && !GemRunner.CANCELLED.equals(pair.second)) {
                            LOG.warn("Some errors happened during successful install: \n" + (String)pair.second);
                        }
                        result.set((Object)Pair.create((Object)true, null));
                    } else if (!((Boolean)pair.first).booleanValue() && !GemRunner.CANCELLED.equals(pair.second)) {
                        LOG.debug("Appending text to the result: ", new Object[]{outputLine});
                        result.set((Object)Pair.create((Object)false, (Object)((String)pair.second + " " + TextUtil.chomp((String)outputLine))));
                    } else if (outputLine.contains(GemRunner.ERROR)) {
                        LOG.debug("Matched as ERROR: ", new Object[]{outputLine});
                        result.set((Object)Pair.create((Object)((Boolean)pair.getFirst()), (Object)outputLine.replaceFirst(GemRunner.ERROR, "")));
                    }
                    if (!StringUtil.isEmpty((String)outputLine.trim())) {
                        progressIndicator.setText2(outputLine);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void runInstall(@NotNull Sdk sdk, @Nullable Module module, @NotNull ProcessListener listener, @NotNull RubyCommandLine commandLine) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(29);
        }
        if (listener == null) {
            GemRunner.$$$reportNull$$$0(30);
        }
        if (commandLine == null) {
            GemRunner.$$$reportNull$$$0(31);
        }
        LOG.info("Installation command for the gem: " + commandLine.getCommandLineString());
        try {
            RubyAbstractRunner runner = (RubyAbstractRunner)RubySdkUtil.getRubySdkAdditionalData(sdk).getRunner(module);
            ProcessHandler handler = runner.createProcessHandler(commandLine, null);
            handler.addProcessListener(listener);
            handler.startNotify();
            ExecutionHelper.executeExternalProcess((Project)RModuleUtil.getInstance().getProject(module), (ProcessHandler)handler, (ExecutionMode)new ExecutionModes.SameThreadMode(null), (GeneralCommandLine)commandLine);
        }
        catch (ExecutionException e) {
            LOG.error(RBundle.message((String)"gems.running.command.error", (Object[])new Object[]{"install"}), (Throwable)e);
        }
    }

    @Nullable
    private static List<String> createGemInvocationCommand(@NotNull Sdk sdk, @NotNull List<String> args, @Nullable Module module) {
        String scriptPath;
        String binPath;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(32);
        }
        if (args == null) {
            GemRunner.$$$reportNull$$$0(33);
        }
        if (!GemRunner.checkPaths(sdk, binPath = RubySdkAdditionalData.getInterpreterDir(sdk), scriptPath = GemRunner.getGemExecutableName(sdk, binPath))) {
            return null;
        }
        String rubyExecutable = RubySdkAdditionalData.getInterpreterPathFor(sdk);
        ArrayList<String> fullArgs = new ArrayList<String>();
        boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
        boolean shouldAddJrubyDebugOptions = isTestMode && JRubySdkUtil.isJRubySDK(sdk);
        RubyVersionManagerHandler rubyVersionManagerHandler = RubyVersionManagerHandler.notNullFrom(sdk);
        if (!ShimsBasedVersionManagerHandler.is(rubyVersionManagerHandler)) {
            fullArgs.add(rubyExecutable);
            if (shouldAddJrubyDebugOptions) {
                fullArgs.add(JRUBY_LOG_EXCEPTIONS_OPTION);
            }
        }
        fullArgs.add(RubySdkUtil.convertToRemote(sdk, module, rubyVersionManagerHandler.getAdjustedGemScriptPathForExecution(scriptPath)));
        fullArgs.add("install");
        fullArgs.addAll(args);
        if (isTestMode) {
            fullArgs.addAll(Arrays.asList("--backtrace", "--verbose", "--debug"));
        }
        return fullArgs;
    }

    @NotNull
    public static String getGemExecutableName(@NotNull Sdk sdk, @Nullable String binPath) {
        String path;
        String path2;
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(34);
        }
        RubySdkSystemAccessor accessor = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor();
        String prefix = binPath + accessor.getFileSeparator();
        if (JRubySdkUtil.isJRubySDK(sdk) && (path2 = GemRunner.gemExecutableExistingPath(prefix, JGEM_EXECUTABLE_NAME)) != null) {
            String string = path2;
            if (string == null) {
                GemRunner.$$$reportNull$$$0(35);
            }
            return string;
        }
        if (RubySdkUtil.isIronRuby(sdk) && (path2 = GemRunner.gemExecutableExistingPath(prefix, IGEM_EXECUTABLE_NAME)) != null) {
            String string = path2;
            if (string == null) {
                GemRunner.$$$reportNull$$$0(36);
            }
            return string;
        }
        String version = sdk.getVersionString();
        if (version != null && version.contains(RUBY19_VERSION_SIGNATURE)) {
            path = GemRunner.gemExecutableExistingPath(prefix, GEM19_EXECUTABLE_NAME);
            if (path != null) {
                String string = path;
                if (string == null) {
                    GemRunner.$$$reportNull$$$0(37);
                }
                return string;
            }
            path = GemRunner.gemExecutableExistingPath(prefix, GEM1DOT9_EXECUTABLE_NAME);
            if (path != null) {
                String string = path;
                if (string == null) {
                    GemRunner.$$$reportNull$$$0(38);
                }
                return string;
            }
            if (accessor.isWindows() && (path = GemRunner.gemExecutableExistingPath(prefix, GEMBAT_EXECUTABLE_NAME)) != null && GemRunner.gemExecutableExistingPath(prefix, GEM_EXECUTABLE_NAME) == null) {
                String string = path;
                if (string == null) {
                    GemRunner.$$$reportNull$$$0(39);
                }
                return string;
            }
        }
        if (version != null && version.contains(RUBY18_VERSION_SIGNATURE)) {
            path = GemRunner.gemExecutableExistingPath(prefix, GEM18_EXECUTABLE_NAME);
            if (path != null) {
                String string = path;
                if (string == null) {
                    GemRunner.$$$reportNull$$$0(40);
                }
                return string;
            }
            path = GemRunner.gemExecutableExistingPath(prefix, GEM1DOT8_EXECUTABLE_NAME);
            if (path != null) {
                String string = path;
                if (string == null) {
                    GemRunner.$$$reportNull$$$0(41);
                }
                return string;
            }
        }
        if (version != null && StringUtil.toLowerCase((String)version).contains(MACRUBY_VERSION_SIGNATURE) && (path = GemRunner.gemExecutableExistingPath(prefix, MACGEM_EXECUTABLE_NAME)) != null) {
            String string = path;
            if (string == null) {
                GemRunner.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = prefix + GEM_EXECUTABLE_NAME;
        if (string == null) {
            GemRunner.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Nullable
    private static String gemExecutableExistingPath(String prefix, String gemExecutableName) {
        String path = prefix + gemExecutableName;
        File file = new File(path);
        return file.exists() && file.isFile() ? path : null;
    }

    private static boolean shouldUseStripNonRubyTextOption(Sdk sdk) {
        return !JRubySdkUtil.isJRubySDK(sdk) && !RubySdkUtil.isIronRuby(sdk) && !RubySdkUtil.isMacRuby(sdk) && !RubySdkUtil.isRubinius(sdk) && !RubySdkUtil.isMaglev(sdk);
    }

    private static void runBundler(final Module module, final @NotNull Sdk sdk, final @Nullable Runnable postFlightAction, final AtomicBoolean postFlightActionNewTab, @Nullable VirtualFile workingDir, final String ... scriptParameters) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(44);
        }
        try {
            VirtualFile parent;
            WriteAction.run(() -> FileDocumentManager.getInstance().saveAllDocuments());
            final Ref localHistoryAction = new Ref();
            final VirtualFile gemFile = BundlerUtil.getGemfile(module);
            VirtualFile virtualFile = parent = gemFile != null ? gemFile.getParent() : null;
            String path = workingDir == null ? (parent != null ? VfsUtilCore.urlToPath((String)parent.getUrl()) : null) : workingDir.getPath();
            final VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (path == null && contentRoots.length > 0) {
                path = contentRoots[0].getPath();
            }
            ProcessListener listener = new ProcessListener(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    @NlsSafe String historyActionTitle = "bundle " + StringUtil.join((String[])scriptParameters, (String)" ");
                    localHistoryAction.set((Object)LocalHistory.getInstance().startAction(historyActionTitle));
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, module, true);
                    Runnable runnable = () -> {
                        if (module.isDisposed()) {
                            return;
                        }
                        for (VirtualFile root : contentRoots) {
                            if (root == null) continue;
                            root.refresh(false, true);
                        }
                        RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
                        RbenvGemsetManager.refreshAttachedGemsetSdks(module);
                        if (gemFile != null) {
                            GemRequirementsChangeWatcher.getInstance(module).addFileScan(gemFile);
                        }
                        postFlightActionNewTab.set(event.getExitCode() != 0);
                        if (postFlightAction != null) {
                            postFlightAction.run();
                        }
                        GemManager.updateGemset(module);
                    };
                    WriteAction.runAndWait(() -> runnable.run());
                    ((LocalHistoryAction)localHistoryAction.get()).finish();
                    localHistoryAction.set(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            @NlsSafe String title = module.getName() + ": bundler";
            HashMap<String, String> env = new HashMap<String, String>();
            String proxy = GemRunner.getCurrentHttpProxy();
            if (proxy != null) {
                env.put("HTTP_PROXY", proxy);
            }
            if (gemFile != null) {
                BundlerUtil.addBundlerEnvironment(env, sdk, module, gemFile);
            }
            MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(scriptParameters, null, null, env);
            ConsoleRunnerOptions consoleRunnerOptions = ConsoleRunnerOptions.builder(module, title).withProcessListeners(listener).withWorkingDirectory(path).withReuseProhibited(postFlightActionNewTab).build();
            RubyScriptRunner.runRubyScriptInConsole(provider, sdk, consoleRunnerOptions);
        }
        catch (Exception exp) {
            RunnerUtil.showErrorMessage(module.getProject(), RBundle.message((String)"gems.gem.installing.error.running.bundler"), exp);
        }
    }

    private static String convertFromConsoleEncoding(String value) {
        if (!SystemInfo.isWindows) {
            return value;
        }
        try {
            Method declaredMethod = Console.class.getDeclaredMethod("encoding", new Class[0]);
            declaredMethod.setAccessible(true);
            value = new String(value.getBytes(StandardCharsets.UTF_8), (String)declaredMethod.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @TestOnly
    public static void runWithPrereleaseGemsAllowed(@NotNull Runnable runnable) {
        if (runnable == null) {
            GemRunner.$$$reportNull$$$0(45);
        }
        boolean oldValue = ALLOW_PRE_RELEASE_IN_TESTS;
        ALLOW_PRE_RELEASE_IN_TESTS = true;
        try {
            runnable.run();
        }
        finally {
            ALLOW_PRE_RELEASE_IN_TESTS = oldValue;
        }
    }

    public static void installInConsole(@NotNull Module module, @NotNull Sdk sdk, @NotNull Collection<GemDependency> dependencies, @Nullable ProcessListener installationListener, @NotNull GemInstallCommandOptions options, @NlsSafe @NotNull String gemInstallationTitle) {
        if (module == null) {
            GemRunner.$$$reportNull$$$0(46);
        }
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(47);
        }
        if (dependencies == null) {
            GemRunner.$$$reportNull$$$0(48);
        }
        if (options == null) {
            GemRunner.$$$reportNull$$$0(49);
        }
        if (gemInstallationTitle == null) {
            GemRunner.$$$reportNull$$$0(50);
        }
        Pair<List<String>, String> argsAndWorkingDir = GemRunner.prepareGemInstallArguments(module, sdk, dependencies, options);
        List<String> command = GemRunner.createGemInvocationCommand(sdk, (List)argsAndWorkingDir.first, module);
        if (command == null) {
            LOG.debug("Failed to create gem invocation command");
            return;
        }
        String[] commandStr = new String[command.size()];
        MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(command.toArray(commandStr), null, null, null);
        ConsoleRunnerOptions consoleRunnerOptions = ConsoleRunnerOptions.builder(module, gemInstallationTitle).withProcessListeners(installationListener).withWorkingDirectory((String)argsAndWorkingDir.second).build();
        LOG.debug("Executing " + StringUtil.join((String[])((RubyCommandLineArgumentsProvider)provider).getArguments(), (String)" ") + " in console.");
        ConsoleRunner.run(consoleRunnerOptions, provider, sdk);
    }

    @NotNull
    private static Pair<List<String>, String> prepareGemInstallArguments(@Nullable Module module, @NotNull Sdk sdk, @NotNull Collection<GemDependency> dependencies, @NotNull GemInstallCommandOptions options) {
        if (sdk == null) {
            GemRunner.$$$reportNull$$$0(51);
        }
        if (dependencies == null) {
            GemRunner.$$$reportNull$$$0(52);
        }
        if (options == null) {
            GemRunner.$$$reportNull$$$0(53);
        }
        ArrayList gemsNamesAndArgs = new ArrayList();
        String workingDir = null;
        for (GemDependency dep : dependencies) {
            Pair<List<String>, String> argsAndWorkDir = GemRunner.computeInstallOptionsAndWorkDir(module, sdk, dep, options);
            workingDir = (String)argsAndWorkDir.second;
            gemsNamesAndArgs.addAll((Collection)argsAndWorkDir.first);
        }
        return new Pair(gemsNamesAndArgs, workingDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 11, 26, 35, 36, 37, 38, 39, 40, 41, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postFlightActionNewTab";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemVersion";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsToUninstall";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalArguments";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 23: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemInstallationTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGemSpecErrors";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "query";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInstallOptionsAndWorkDir";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemExecutableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bundle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRawEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkGemEnvironmentOutputPresence";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "query";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkPaths";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeInstallOptionsAndWorkDir";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createProcessAdapter";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runInstall";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createGemInvocationCommand";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGemExecutableName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "runBundler";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "runWithPrereleaseGemsAllowed";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "installInConsole";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "prepareGemInstallArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 11, 26, 35, 36, 37, 38, 39, 40, 41, 42, 43 -> new IllegalStateException(string);
        };
    }

    static class InvalidGemsNotification
    extends Notification {
        InvalidGemsNotification(@NotNull String groupDisplayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type, final @NotNull Project project, final @NotNull List<GemspecError> gemspecErrors) {
            if (groupDisplayId == null) {
                InvalidGemsNotification.$$$reportNull$$$0(0);
            }
            if (title == null) {
                InvalidGemsNotification.$$$reportNull$$$0(1);
            }
            if (content == null) {
                InvalidGemsNotification.$$$reportNull$$$0(2);
            }
            if (type == null) {
                InvalidGemsNotification.$$$reportNull$$$0(3);
            }
            if (project == null) {
                InvalidGemsNotification.$$$reportNull$$$0(4);
            }
            if (gemspecErrors == null) {
                InvalidGemsNotification.$$$reportNull$$$0(5);
            }
            super(groupDisplayId, title, content, type);
            if (gemspecErrors.isEmpty()) {
                return;
            }
            this.addAction((AnAction)new DumbAwareAction(this, RBundle.message((String)"action.fix.gemspec.errors.text")){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (GemspecError error : gemspecErrors) {
                        String attribute;
                        String canonicalPath = FileUtil.toCanonicalPath((String)error.getPath());
                        File file = new File(canonicalPath);
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                        if (virtualFile == null) {
                            LOG.warn("Failed to fix " + String.valueOf(error) + "; unable to find file: " + String.valueOf(file));
                            continue;
                        }
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
                        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                        if (psiFile == null) {
                            LOG.warn("Failed to fix " + String.valueOf(error) + "; unable to find psi file for: " + String.valueOf(virtualFile));
                            continue;
                        }
                        String text = psiFile.getText();
                        int offset = text.indexOf(attribute = error.getAttribute());
                        if (offset <= 0 || editor == null) continue;
                        editor.getCaretModel().moveToOffset(offset);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/gem/gem/GemRunner$InvalidGemsNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gemspecErrors";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/gem/gem/GemRunner$InvalidGemsNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GemspecError {
        private final String myPath;
        private final String myAttribute;

        GemspecError(String path, String attribute) {
            this.myPath = path;
            this.myAttribute = attribute;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getAttribute() {
            return this.myAttribute;
        }
    }
}

