/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.gem;

import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemSpecContext;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

public final class GemListParser {
    @NonNls
    private static final Pattern GEM_LINE_MATCHER = Pattern.compile("^(\\S+)\\s*\\((.*)\\)$");
    @NonNls
    private static final Pattern AUTHOR_LINE_MATCHER = Pattern.compile("^\\s*Author:\\s*(.*)$");
    @NonNls
    private static final Pattern HOMEPAGE_LINE_MATCHER = Pattern.compile("^\\s*Homepage:\\s*(.*)$");
    @NonNls
    private static final Pattern VERSION_CUTTER = Pattern.compile("([0-9]+(\\.[0-9A-z]+)*)");

    private GemListParser() {
    }

    @NotNull
    public static List<GemInfo> parse(@NotNull String list, @NotNull String url, boolean withDetails) {
        if (list == null) {
            GemListParser.$$$reportNull$$$0(0);
        }
        if (url == null) {
            GemListParser.$$$reportNull$$$0(1);
        }
        ArrayList<GemInfo> result = new ArrayList<GemInfo>();
        String[] lines = list.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = GemListParser.getLine(lines, i);
            Matcher matcher = GEM_LINE_MATCHER.matcher(line);
            if (!matcher.matches()) continue;
            GemSpecContext context = new GemSpecContext();
            String name = matcher.group(1);
            context.putData(GemsSpecKeys.NAME, name);
            context.putData(GemsSpecKeys.REMOTE, true);
            String[] versions = matcher.group(2).split(",");
            if (withDetails) {
                i = GemListParser.parseDescription(lines, i, context);
            }
            for (String versionLine : versions) {
                GemInfo gem;
                Matcher m = VERSION_CUTTER.matcher(versionLine);
                if (m.find()) {
                    context.putData(GemsSpecKeys.VERSION, m.group(1));
                }
                if ((gem = GemInfo.create(context, url, (String)GemsSpecKeys.SUMMARY.get((UserDataHolder)context))) == null) continue;
                result.add(gem);
            }
        }
        ArrayList<GemInfo> arrayList = result;
        if (arrayList == null) {
            GemListParser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static int parseDescription(String[] lines, int i, GemSpecContext context) {
        String line;
        do {
            Matcher authorMatcher;
            if ((authorMatcher = AUTHOR_LINE_MATCHER.matcher(line = GemListParser.getLine(lines, ++i))).matches()) {
                context.putData(GemsSpecKeys.AUTHORS, authorMatcher.group(1));
                continue;
            }
            Matcher homepageMatcher = HOMEPAGE_LINE_MATCHER.matcher(line);
            if (!homepageMatcher.matches()) continue;
            context.putData(GemsSpecKeys.HOMEPAGE, homepageMatcher.group(1));
        } while (!line.isEmpty());
        StringBuilder builder2 = new StringBuilder();
        do {
            line = GemListParser.getLine(lines, ++i);
            builder2.append(line.replaceFirst("    ", "")).append("\n");
        } while (!line.isEmpty());
        String summary = builder2.toString().trim();
        if (!"\n".equals(summary)) {
            context.putData(GemsSpecKeys.SUMMARY, summary);
        }
        return i;
    }

    private static String getLine(String[] lines, int i) {
        return i < lines.length ? TextUtil.chomp((String)lines[i]) : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/gem/GemListParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/gem/GemListParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

