/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.detector;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemSpecContext;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.detector.ImplicitRequireGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyGemDetector
implements GemDetector {
    private static final Logger LOG = Logger.getInstance(RubyGemDetector.class);
    @NonNls
    private static final String GEM = "gem";
    @NonNls
    public static final String GEMSPEC = "gemspec";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String RUN = "run";
    @NonNls
    private static final String ENV = "env";
    @NonNls
    private static final String PLATFORM = "platform";
    @NonNls
    private static final String PLATFORMS = "platforms";
    private static final Set<String> GEM_CONTAINING_BLOCKS = Set.of("group", "run", "env", "platform", "platforms", "path");

    @Override
    @NotNull
    public Set<GemDependency> detect(@NotNull Project project, @Nullable Sdk sdk, @Nullable VirtualFile file) {
        if (project == null) {
            RubyGemDetector.$$$reportNull$$$0(0);
        }
        if (file == null || !(file.getFileType() instanceof AbstractRubyFileType)) {
            Set<GemDependency> set = Collections.emptySet();
            if (set == null) {
                RubyGemDetector.$$$reportNull$$$0(1);
            }
            return set;
        }
        LinkedHashMap result = new LinkedHashMap();
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed() || !file.isValid()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof RFile)) {
                return;
            }
            List<String> ignoredGroups = RubyGemDetector.getIgnoredGroups(psiFile);
            interpreter.interpret((PsiElement)psiFile, new DetectorCallable(result, sdk, ignoredGroups));
            for (ImplicitRequireGemProvider provider : ImplicitRequireGemProvider.EP_NAME.getExtensionList()) {
                result.putAll(provider.getImplicitDependency((RFile)psiFile));
            }
            if (!result.containsKey("bundler") && BundlerUtil.isGemfile(project, file)) {
                result.put("bundler", GemDependency.any("bundler"));
            }
        });
        return new HashSet<GemDependency>(result.values());
    }

    @NotNull
    private static List<String> getIgnoredGroups(PsiFile file) {
        Module module;
        List<String> ignoredGroups = BundlerUtil.isGemfile((PsiFileSystemItem)file) ? ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null ? BundlerUtil.getIgnoredGroupsFromConfig(module) : Collections.emptyList()) : Collections.emptyList();
        List<String> list = ignoredGroups;
        if (list == null) {
            RubyGemDetector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static GemDependency buildRequirement(String gemName, List<? extends RPsiElement> arguments, List<String> platforms, List<String> groups, String path, boolean canIgnoreLocker, @NotNull List<String> ignoredGroups) {
        Module module;
        if (ignoredGroups == null) {
            RubyGemDetector.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)arguments.get(0)))) == null || RubyGemDetector.isTotallyIgnored(groups, ignoredGroups)) {
            return null;
        }
        BundlerGitLockReader reader = BundlerGitLockReader.getInstance(module);
        GemDependency dep = reader.getDependency(gemName);
        if (reader.isLocked() && BundlerUtil.isGemfile((PsiFileSystemItem)arguments.get(0).getContainingFile())) {
            if (dep != null) {
                return GemDependency.create(dep.getName(), dep.getBounds(), dep.getUrl(), dep.getLibScript(), dep.isGit(), dep.getRef(), dep.doRequire(), dep.isFromPath(), dep.getPlatforms(), groups);
            }
            if (!canIgnoreLocker) {
                return dep;
            }
        }
        ArrayList<String> deps = new ArrayList<String>();
        for (int i = 1; i < arguments.size(); ++i) {
            RPsiElement element = arguments.get(i);
            if (!(element instanceof RStringLiteral)) continue;
            deps.add(TextUtil.removeQuoting((String)element.getText()));
        }
        return GemDependency.create(gemName, RubyGemDetector.toNullableStringArray(deps), path, null, false, null, true, path != null, RubyGemDetector.toNullableStringArray(platforms), groups);
    }

    private static boolean isTotallyIgnored(List<String> groups, List<String> ignoredGroups) {
        if (groups == null) {
            return false;
        }
        return ignoredGroups.containsAll(groups);
    }

    @Nullable
    private static GemDependency buildRailsRequirement(List<? extends RPsiElement> args, int length, String name, List<String> platforms, List<String> groups, String defaultPath, boolean canIgnoreLocker, @NotNull List<String> ignoredGroups) {
        Module module;
        if (ignoredGroups == null) {
            RubyGemDetector.$$$reportNull$$$0(4);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)args.get(0)))) == null) {
            return null;
        }
        BundlerGitLockReader reader = BundlerGitLockReader.getInstance(module);
        GemDependency dep = reader.getDependency(name);
        if (!canIgnoreLocker && reader.isLocked() && dep == null && BundlerUtil.isGemfile((PsiFileSystemItem)args.get(0).getContainingFile())) {
            return null;
        }
        String version = dep != null ? dep.getVersionString() : null;
        String url = null;
        String lib = null;
        boolean isGit = dep != null && dep.isGit();
        boolean isFromPath = false;
        boolean doRequire = true;
        String ref = dep != null ? dep.getRef() : null;
        for (int i = 1; i < length; ++i) {
            String text;
            RPsiElement element = args.get(i);
            if (!(element instanceof RAssoc)) continue;
            RAssoc assoc = (RAssoc)element;
            RPsiElement key = assoc.getKey();
            RPsiElement value = assoc.getValue();
            if (key == null || value == null) continue;
            String string = text = key instanceof RSymbol ? ((RSymbol)key).getValue() : key.getText();
            if ("version".equals(text)) {
                version = dep != null ? dep.getVersionString() : value.getText();
                continue;
            }
            if ("source".equals(text)) {
                url = value.getText();
                continue;
            }
            if (PATH.equals(text)) {
                PsiFile file = assoc.getContainingFile();
                VirtualFile vFile = file.getVirtualFile();
                String path = TextUtil.trimTrailingSlashes((String)RFileUtil.evaluateRequirement(vFile, (PsiElement)value));
                if (path.isEmpty()) {
                    path = defaultPath;
                }
                url = path.isEmpty() && dep != null ? dep.getUrl() : GemUtil.getGemUrlFromPath(path, vFile.getParent());
                isFromPath = true;
                continue;
            }
            if ("lib".equals(text) || "require".equals(text) || "require_as".equals(text)) {
                String valueText = value.getText();
                if ("false".equals(valueText)) {
                    doRequire = false;
                    continue;
                }
                if ("true".equals(valueText)) continue;
                lib = valueText;
                continue;
            }
            if ("git".equals(text) || "github".equals(text)) {
                isGit = true;
                continue;
            }
            if ("ref".equals(text) || "branch".equals(text) || "tag".equals(text)) {
                if (ref != null) continue;
                ref = value.getText();
                continue;
            }
            if (PLATFORM.equals(text) || PLATFORMS.equals(text)) {
                platforms = RubyGemDetector.extractPlatforms(value);
                continue;
            }
            if (!GROUP.equals(text) && !"groups".equals(text)) continue;
            groups = RubyGemDetector.extractPlatforms(value);
        }
        if (RubyGemDetector.isTotallyIgnored(groups, ignoredGroups)) {
            return null;
        }
        if (version == null) {
            return GemDependency.any(name, TextUtil.removeQuoting(url), TextUtil.removeQuoting(lib), isGit, TextUtil.removeQuoting((String)ref), doRequire, isFromPath, RubyGemDetector.toNullableStringArray(platforms), groups);
        }
        return GemDependency.create(name, new String[]{TextUtil.removeQuoting((String)version)}, TextUtil.removeQuoting(url), TextUtil.removeQuoting(lib), isGit, TextUtil.removeQuoting((String)ref), doRequire, isFromPath, RubyGemDetector.toNullableStringArray(platforms), groups);
    }

    private static List<String> extractPlatforms(RPsiElement value) {
        if (value instanceof RArray) {
            return ContainerUtil.mapNotNull((Collection)((RArray)value).getElements(), element -> RubyPsiUtilCore.getElementText((PsiElement)element));
        }
        return ContainerUtil.createMaybeSingletonList((Object)RubyPsiUtilCore.getElementText((PsiElement)value));
    }

    @Nullable
    public static GemDependency buildRequirement(@NotNull RPossibleCall possibleCall, boolean canIgnoreLocker, @Nullable List<String> ignoredGroups) {
        List args;
        if (possibleCall == null) {
            RubyGemDetector.$$$reportNull$$$0(5);
        }
        if ((args = possibleCall.getArguments()).isEmpty()) {
            return null;
        }
        String name = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)args.get(0));
        if (StringUtil.isEmpty((String)name) || !GemUtil.NAME_PATTERN.matcher(name).matches()) {
            return null;
        }
        if (ignoredGroups == null) {
            PsiFile file = possibleCall.getContainingFile();
            ignoredGroups = RubyGemDetector.getIgnoredGroups(file);
        }
        boolean hasAssoc = false;
        for (RPsiElement arg : args) {
            hasAssoc |= arg instanceof RAssoc;
        }
        List<String> platforms = RubyGemDetector.getPlatforms(possibleCall);
        List<String> groups = RubyGemDetector.getGroups(possibleCall);
        String path = RubyGemDetector.getPath(possibleCall);
        if (hasAssoc) {
            return RubyGemDetector.buildRailsRequirement(args, args.size(), name, platforms, groups, path != null ? path : "", canIgnoreLocker, ignoredGroups);
        }
        return RubyGemDetector.buildRequirement(name, args, platforms, groups, path, canIgnoreLocker, ignoredGroups);
    }

    @Nullable
    private static List<String> getBlockArguments(RPossibleCall possibleCall, String singular, String plural) {
        RBlockCall parent = RubyPsiUtil.getContainingRBlockCall((PsiElement)possibleCall);
        while (parent != null) {
            RCall rCall;
            RPossibleCall rPossibleCall = parent.getCall();
            if (rPossibleCall instanceof RCall && (singular.equals((rCall = (RCall)rPossibleCall).getCommand()) || plural.equals(rCall.getCommand()))) {
                return ContainerUtil.mapNotNull((Collection)rCall.getArguments(), element -> RubyPsiUtilCore.getElementText((PsiElement)element));
            }
            parent = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)parent, RBlockCall.class, (boolean)true);
        }
        return null;
    }

    @Nullable
    private static List<String> getPlatforms(RPossibleCall call) {
        return RubyGemDetector.getBlockArguments(call, PLATFORM, PLATFORMS);
    }

    @Nullable
    private static List<String> getGroups(RPossibleCall call) {
        return RubyGemDetector.getBlockArguments(call, GROUP, GROUP);
    }

    @Nullable
    private static String getPath(RPossibleCall call) {
        List<String> args = RubyGemDetector.getBlockArguments(call, PATH, PATH);
        return args != null && args.size() == 1 ? args.get(0) : null;
    }

    @Override
    public boolean accepts(@NotNull VirtualFile providerCandidate) {
        if (providerCandidate == null) {
            RubyGemDetector.$$$reportNull$$$0(6);
        }
        return providerCandidate.getFileType() instanceof AbstractRubyFileType;
    }

    @Contract(value="null -> null; !null -> !null")
    private static String[] toNullableStringArray(@Nullable List<String> strings) {
        return (String[])ObjectUtils.doIfNotNull(strings, s -> ArrayUtilRt.toStringArray((Collection)s));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredGroups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/detector/RubyGemDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildRequirement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRailsRequirement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    protected static class DetectorCallable
    implements PsiCallable {
        private final Map<String, GemDependency> myDeps;
        private final Sdk mySdk;
        private final List<String> myIgnoredGroups;

        public DetectorCallable(Map<String, GemDependency> deps, @Nullable Sdk sdk, List<String> ignoredGroups) {
            this.myDeps = deps;
            this.mySdk = sdk;
            this.myIgnoredGroups = ignoredGroups;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            String command = arguments.getCommand();
            if (arguments.hasBlock() && GEM_CONTAINING_BLOCKS.contains(command)) {
                arguments.interpretBlockWithGivenSelf(this, new PsiCallable[0]);
                return;
            }
            switch (command) {
                case "gem": {
                    GemDependency dep = null;
                    PsiElement element = arguments.getRCallElement();
                    if (element instanceof RPossibleCall) {
                        dep = RubyGemDetector.buildRequirement((RPossibleCall)element, false, this.myIgnoredGroups);
                    }
                    if (dep == null) {
                        return;
                    }
                    if (!dep.isSupportedBySdk(this.mySdk)) {
                        return;
                    }
                    LOG.debug("Detected requirement : " + String.valueOf(dep));
                    this.myDeps.put(dep.getName(), dep);
                    break;
                }
                case "gemspec": {
                    this.parseGemspec(arguments);
                    break;
                }
                case "require": {
                    this.findCorrespondingGem(arguments);
                }
            }
        }

        private void findCorrespondingGem(RCallArguments arguments) {
            String path;
            PsiElement element = arguments.getRCallElement();
            VirtualFile file = element.getContainingFile().getVirtualFile();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (file == null || BundlerUtil.isGemfile(element.getProject(), file) || module == null) {
                return;
            }
            String string = path = element instanceof RCall ? RFileUtil.evaluateRequirePath(file, (RCall)element) : null;
            if (path == null) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            Collection<GemInfo> gems = GemManager.getInstance().getAllGems(sdk, module);
            for (GemInfo gem : gems) {
                VirtualFile folder = gem.getLibFolder();
                if (folder == null || !folder.isValid()) continue;
                VirtualFile child = folder.findFileByRelativePath(path + RFileUtilCore.RB_FILE_SUFFIX);
                if (child != null && !child.isDirectory()) {
                    this.myDeps.put(gem.getName(), GemDependency.any(gem.getName()));
                    return;
                }
                child = folder.findFileByRelativePath(path);
                if (child != null && !child.isDirectory()) {
                    this.myDeps.put(gem.getName(), GemDependency.any(gem.getName()));
                    return;
                }
                child = folder.findFileByRelativePath(path + ".so");
                if (child == null || child.isDirectory()) continue;
                this.myDeps.put(gem.getName(), GemDependency.any(gem.getName()));
                return;
            }
        }

        private void parseGemspec(RCallArguments arguments) {
            VirtualFile parent;
            PsiElement element = arguments.getCallElement();
            VirtualFile gemfile = element.getContainingFile().getVirtualFile();
            VirtualFile virtualFile = parent = gemfile != null ? gemfile.getParent() : null;
            if (parent != null) {
                List<RPsiElement> args = arguments.getArguments();
                String name = null;
                String path = null;
                if (!args.isEmpty()) {
                    for (RPsiElement arg : args) {
                        if (!(arg instanceof RAssoc)) continue;
                        RAssoc assoc = (RAssoc)arg;
                        RPsiElement key = assoc.getKey();
                        RPsiElement value = assoc.getValue();
                        if (key == null || value == null) continue;
                        String text = key.getText();
                        if (":name".equals(text)) {
                            name = value.getText();
                            continue;
                        }
                        if (!":path".equals(text)) continue;
                        path = value.getText();
                    }
                }
                VirtualFile gemDir = parent;
                if (path != null) {
                    VirtualFile file = parent.findFileByRelativePath(path);
                    if (file == null) {
                        file = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl(path));
                    }
                    if (file != null) {
                        gemDir = file;
                    }
                }
                VirtualFile specFile = name == null ? GemUtil.findGemspecFile(gemDir) : GemUtil.findGemspecFile(gemDir, name);
                GemSpecContext spec = GemSpecParser.getInstance().getGemSpec(parent, specFile, true);
                Set dependencies = spec != null ? (Set)GemsSpecKeys.DEPENDENCIES.get((UserDataHolder)spec) : null;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (dependencies != null && module != null) {
                    for (GemDependency dep : dependencies) {
                        if (dep == null || !dep.isSupportedBySdk(this.mySdk)) continue;
                        GemDependency lockDep = BundlerGitLockReader.getInstance(module).getDependency(name);
                        dep = lockDep != null ? lockDep : dep;
                        LOG.debug("Detected requirement from gemspec: " + String.valueOf(dep));
                        this.myDeps.put(dep.getName(), dep);
                    }
                }
            }
        }
    }
}

