/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerActionType;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerAdditionalOptionsStorage;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.statistic.BundlerActionArgsNotEmptyCollector;

public class BundlerAdditionalOptionsDialog
extends DialogWrapper {
    private RawCommandLineEditor scriptArgsEditor;
    @NotNull
    private final Project myProject;
    private final BundlerActionType myActionType;

    protected BundlerAdditionalOptionsDialog(@NotNull Project project, @NotNull Module module, BundlerActionType actionType) {
        if (project == null) {
            BundlerAdditionalOptionsDialog.$$$reportNull$$$0(0);
        }
        if (module == null) {
            BundlerAdditionalOptionsDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myActionType = actionType;
        if (RModuleUtil.getInstance().isInMultiProject(module)) {
            this.setTitle(RBundle.message((String)"bundler.cmd.options.dialog.title.ex", (Object[])new Object[]{StringUtil.capitalize((String)this.myActionType.getCommand()), module.getName()}));
        } else {
            this.setTitle(RBundle.message((String)"bundler.cmd.options.dialog.title", (Object[])new Object[]{StringUtil.capitalize((String)this.myActionType.getCommand())}));
        }
        this.setOKButtonText(RBundle.message((String)"bundler.action.run"));
        this.init();
    }

    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        Ref scriptArgsEditorWrapper = new Ref();
        String text = RBundle.message((String)"bundler.cmd.options.dialog.additional.cmdline.parameters", (Object[])new Object[]{this.myActionType.getCommand()});
        LabeledComponent<RawCommandLineEditor> editorComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)scriptArgsEditorWrapper, text);
        this.scriptArgsEditor = (RawCommandLineEditor)scriptArgsEditorWrapper.get();
        BundlerAdditionalOptionsStorage bundlerAdditionalOptionsStorage = BundlerAdditionalOptionsStorage.getInstance(this.myProject);
        this.scriptArgsEditor.setText(bundlerAdditionalOptionsStorage.options.get(this.myActionType.getCommand()));
        this.scriptArgsEditor.setMinimumSize(new Dimension(350, -1));
        mainPanel.add((Component)editorComponent, "North");
        JCheckBox rememberChoiceCheckbox = new JCheckBox(RBundle.message((String)"bundler.additional.options.dialog.remember.choice"));
        rememberChoiceCheckbox.addChangeListener(e -> {
            boolean rememberChoice = rememberChoiceCheckbox.isSelected();
            BundlerService.getInstance(this.myProject).setUseDefaultArguments(rememberChoice);
            if (rememberChoice) {
                BundlerService.getInstance(this.myProject).setDefaultArguments(this.scriptArgsEditor.getText());
            }
        });
        mainPanel.add(rememberChoiceCheckbox);
        return mainPanel;
    }

    protected void doOKAction() {
        BundlerAdditionalOptionsStorage.getInstance((Project)this.myProject).options.put(this.myActionType.getCommand(), this.getAdditionalArguments());
        BundlerActionArgsNotEmptyCollector.logBundlerActionDialogExecuted(this.myActionType, this.getAdditionalArguments().isEmpty());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.scriptArgsEditor.getTextField();
    }

    public String getAdditionalArguments() {
        return this.scriptArgsEditor.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/gem/bundler/actions/BundlerAdditionalOptionsDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

