/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerActionType;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerAdditionalOptionsDialog;
import org.jetbrains.plugins.ruby.gem.bundler.actions.BundlerService;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public abstract class AbstractBundlerAction
extends DumbAwareAction {
    private static String ourBundlerOptions = null;
    protected static final Logger LOG = Logger.getInstance(AbstractBundlerAction.class);
    @Nullable
    private Computable<Boolean> myPreFlightAction;
    @Nullable
    private Runnable myPostFlightAction;
    @NotNull
    private AtomicBoolean myPostFlightActionNewTab = new AtomicBoolean(false);
    @TestOnly
    private static CompletableFuture<Boolean> ourBundleActionFinishedFuture = new CompletableFuture();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractBundlerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractBundlerAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        GemInfo gem = RubyGemSearchUtil.findGem(module, sdk, "bundler");
        LOG.debug("Look for a bundler in the context of ", new Object[]{module, "; ", sdk, " got ", gem});
        e.getPresentation().setEnabledAndVisible(module != null && gem != null && this.isEnabled(module, gem));
    }

    protected abstract boolean isEnabled(Module var1, GemInfo var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractBundlerAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        this.runBundlerAction(module);
    }

    public void runBundlerAction(@Nullable Module module) {
        Project project;
        Sdk sdk = module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null;
        Project project2 = project = module != null ? module.getProject() : null;
        if (sdk == null) {
            LOG.debug("No sdk found for a module: ", new Object[]{module});
            new Notification("Gem Manager", RBundle.message((String)"bundler.action.no.sdk.title"), RBundle.message((String)"bundler.action.no.sdk.message"), NotificationType.INFORMATION).notify(project);
            return;
        }
        Runnable installActionDispatcher = () -> ApplicationManager.getApplication().invokeAndWait(() -> this.runBundleAction(module, project, sdk));
        if (!AbstractBundlerAction.checkBundlerVersion(module, sdk)) {
            BundlerUtil.installBundlerInConsole(module, sdk, installActionDispatcher);
            return;
        }
        installActionDispatcher.run();
    }

    @RequiresEdt
    private void runBundleAction(@NotNull Module module, @NotNull Project project, @NotNull Sdk sdk) {
        BundlerAdditionalOptionsDialog dialog;
        if (module == null) {
            AbstractBundlerAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AbstractBundlerAction.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            AbstractBundlerAction.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        boolean isOk = true;
        String additionalArguments = (String)ObjectUtils.notNull((Object)ourBundlerOptions, (Object)"");
        if (this.hasAdditionalOptions() && !ApplicationManager.getApplication().isUnitTestMode() && !BundlerService.getInstance(project).isUseDefaultArguments() && (isOk = (dialog = new BundlerAdditionalOptionsDialog(project, module, this.getActionType())).showAndGet())) {
            additionalArguments = dialog.getAdditionalArguments();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && BundlerService.getInstance(project).isUseDefaultArguments()) {
            additionalArguments = BundlerService.getInstance(project).getDefaultArguments();
        }
        if (isOk) {
            if (this.myPreFlightAction != null) {
                boolean isSucceeded = (Boolean)this.myPreFlightAction.compute();
                this.myPreFlightAction = null;
                if (!isSucceeded) {
                    return;
                }
            }
            Runnable callback = () -> {
                Runnable postFlightAction = this.getPostFlightAction(module);
                if (postFlightAction != null) {
                    postFlightAction.run();
                    this.setPostFlightAction(null);
                }
                ourBundleActionFinishedFuture.complete(true);
                LOG.debug("Bundle action finished noted");
            };
            GemRunner.bundle(module, sdk, this.getActionType().getCommand(), null, null, callback, this.myPostFlightActionNewTab, additionalArguments);
        }
    }

    @TestOnly
    public static void resetBundleActionFinishedState() {
        LOG.debug("Resetting bundle action finished state");
        ourBundleActionFinishedFuture = new CompletableFuture();
    }

    @TestOnly
    public static void awaitBundleActionFinished() throws ExecutionException, InterruptedException, TimeoutException {
        ourBundleActionFinishedFuture.get(5L, TimeUnit.MINUTES);
    }

    private static boolean checkBundlerVersion(@NotNull Module module, @NotNull Sdk sdk) {
        GemDependency expected;
        if (module == null) {
            AbstractBundlerAction.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            AbstractBundlerAction.$$$reportNull$$$0(7);
        }
        GemInfo actual = (expected = BundlerGitLockReader.getInstance(module).getDependency("bundler")) != null ? RubyGemSearchUtil.findGem(module, sdk, expected) : RubyGemSearchUtil.findGem(module, sdk, "bundler");
        return expected == null && actual != null || expected != null && actual != null && expected.isSatisfied(actual);
    }

    protected boolean hasAdditionalOptions() {
        return false;
    }

    @Nullable
    protected Runnable getPostFlightAction(@Nullable Module module) {
        return this.myPostFlightAction;
    }

    public void setPreFlightAction(@Nullable Computable<Boolean> preFlightAction) {
        this.myPreFlightAction = preFlightAction;
    }

    public void setPostFlightAction(@Nullable Runnable postFlightAction) {
        this.myPostFlightAction = postFlightAction;
    }

    public void setPostFlightActionNewTab(@NotNull AtomicBoolean postFlightActionInNewTab) {
        if (postFlightActionInNewTab == null) {
            AbstractBundlerAction.$$$reportNull$$$0(8);
        }
        this.myPostFlightActionNewTab = postFlightActionInNewTab;
    }

    @NonNls
    @NotNull
    public abstract BundlerActionType getActionType();

    @TestOnly
    public static void doWithBundlerOptions(@NotNull Runnable runnable, @Nullable String bundlerOptions) {
        if (runnable == null) {
            AbstractBundlerAction.$$$reportNull$$$0(9);
        }
        ourBundlerOptions = bundlerOptions;
        try {
            runnable.run();
        }
        finally {
            ourBundlerOptions = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/actions/AbstractBundlerAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postFlightActionInNewTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/actions/AbstractBundlerAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runBundleAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkBundlerVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPostFlightActionNewTab";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWithBundlerOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

