/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LazyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.GemfileLockKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 !2\u00020\u0001:\n!\"#$%&'()*B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003J\b\u0010 \u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\bR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0015\u0010\u0012R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0019\u0010\bR!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001d\u0010\b\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock;", "", "sections", "", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "<init>", "(Ljava/util/List;)V", "getSections", "()Ljava/util/List;", "section", "title", "", "platforms", "getPlatforms", "platforms$delegate", "Lkotlin/Lazy;", "bundledWith", "getBundledWith", "()Ljava/lang/String;", "bundledWith$delegate", "rubyVersion", "getRubyVersion", "rubyVersion$delegate", "dependencies", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec;", "getDependencies", "dependencies$delegate", "specSections", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "getSpecSections", "specSections$delegate", "resolvedDependencies", "toString", "Companion", "Section", "DefaultSection", "SpecSection", "GemSpec", "GitSection", "GemSection", "PathSection", "PluginSection", "DependenciesSection", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nGemfileLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,297:1\n1#2:298\n1#2:321\n1374#3:299\n1460#3,5:300\n1208#3,2:305\n1236#3,4:307\n1617#3,9:311\n1869#3:320\n1870#3:322\n1626#3:323\n808#3,11:325\n19#4:324\n*S KotlinDebug\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock\n*L\n50#1:321\n49#1:299\n49#1:300,5\n49#1:305,2\n49#1:307,4\n50#1:311,9\n50#1:320\n50#1:322\n50#1:323\n42#1:325,11\n40#1:324\n*E\n"})
public final class GemfileLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Section> sections;
    @NotNull
    private final Lazy platforms$delegate;
    @NotNull
    private final Lazy bundledWith$delegate;
    @NotNull
    private final Lazy rubyVersion$delegate;
    @NotNull
    private final Lazy dependencies$delegate;
    @NotNull
    private final Lazy specSections$delegate;

    private GemfileLock(List<? extends Section> sections) {
        this.sections = CollectionsKt.toList((Iterable)sections);
        this.platforms$delegate = LazyKt.lazyPub(() -> GemfileLock.platforms_delegate$lambda$0(this));
        this.bundledWith$delegate = LazyKt.lazyPub(() -> GemfileLock.bundledWith_delegate$lambda$0(this));
        this.rubyVersion$delegate = LazyKt.lazyPub(() -> GemfileLock.rubyVersion_delegate$lambda$0(this));
        this.dependencies$delegate = LazyKt.lazyPub(() -> GemfileLock.dependencies_delegate$lambda$0(this));
        this.specSections$delegate = LazyKt.lazyPub(() -> GemfileLock.specSections_delegate$lambda$0(sections));
    }

    @NotNull
    public final List<Section> getSections() {
        return this.sections;
    }

    private final Section section(String title) {
        Object v0;
        block1: {
            Iterable iterable = this.sections;
            for (Object t : iterable) {
                Section it = (Section)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)title, (Object)it.getTitle())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final List<String> getPlatforms() {
        Lazy lazy = this.platforms$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public final String getBundledWith() {
        Lazy lazy = this.bundledWith$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getRubyVersion() {
        Lazy lazy = this.rubyVersion$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<GemSpec> getDependencies() {
        Lazy lazy = this.dependencies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<SpecSection> getSpecSections() {
        Lazy lazy = this.specSections$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GemSpec> resolvedDependencies() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getSpecSections();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SpecSection it = (SpecSection)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSpecs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            GemSpec bl = (GemSpec)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map specsMap = destination$iv$iv2;
        Object $this$mapNotNull$iv = this.getDependencies();
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GemSpec it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GemSpec it = (GemSpec)element$iv$iv;
            boolean bl3 = false;
            if ((GemSpec)specsMap.get(it.getName()) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List dependencies = (List)destination$iv$iv2;
        $this$mapNotNull$iv = this.getBundledWith();
        if ($this$mapNotNull$iv == null || StringsKt.isBlank((CharSequence)$this$mapNotNull$iv)) {
            return dependencies;
        }
        GemSpec bundlerSpec = GemSpec.Companion.create("bundler (" + this.getBundledWith() + ")");
        return bundlerSpec == null ? dependencies : CollectionsKt.plus((Collection)dependencies, (Object)bundlerSpec);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.sections, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final List platforms_delegate$lambda$0(GemfileLock this$0) {
        Object object = this$0.section("PLATFORMS");
        if (object == null || (object = object.getLines()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final String bundledWith_delegate$lambda$0(GemfileLock this$0) {
        Object object = this$0.section("BUNDLED WITH");
        return object != null && (object = object.getLines()) != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
    }

    private static final String rubyVersion_delegate$lambda$0(GemfileLock this$0) {
        Object object = this$0.section("RUBY VERSION");
        return object != null && (object = object.getLines()) != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
    }

    private static final List dependencies_delegate$lambda$0(GemfileLock this$0) {
        Object object;
        Section $this$asSafely$iv = this$0.section("DEPENDENCIES");
        boolean $i$f$asSafely = false;
        Section section = $this$asSafely$iv;
        if (!(section instanceof DependenciesSection)) {
            section = null;
        }
        if ((object = (DependenciesSection)section) == null || (object = ((DependenciesSection)object).getSpecs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List specSections_delegate$lambda$0(List $sections) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $sections;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SpecSection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @Nullable
    public static final GemfileLock from(@Nullable VirtualFile lockFile) {
        return Companion.from(lockFile);
    }

    @JvmStatic
    @Nullable
    public static final GemfileLock from(@NotNull CharSequence contents) {
        return Companion.from(contents);
    }

    public /* synthetic */ GemfileLock(List sections, DefaultConstructorMarker $constructor_marker) {
        this(sections);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock;", "lockFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "contents", "", "parseContent", "", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nGemfileLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final GemfileLock from(@Nullable VirtualFile lockFile) {
            GemfileLock gemfileLock;
            VirtualFile virtualFile = lockFile;
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)it);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadText(...)");
                gemfileLock = Companion.from(charSequence);
            } else {
                gemfileLock = null;
            }
            return gemfileLock;
        }

        @JvmStatic
        @Nullable
        public final GemfileLock from(@NotNull CharSequence contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            Collection collection = this.parseContent(contents);
            if (collection.isEmpty()) {
                boolean bl = false;
                return null;
            }
            List lockFileSections = (List)collection;
            return new GemfileLock(lockFileSections, null);
        }

        private final List<Section> parseContent(CharSequence contents) {
            List sections = new ArrayList();
            String sectionTitle = null;
            List sectionLines = new ArrayList();
            for (String line : StringsKt.lineSequence((CharSequence)contents)) {
                if (((CharSequence)line).length() == 0) continue;
                if (StringsKt.startsWith$default((String)line, (String)"  ", (boolean)false, (int)2, null)) {
                    if (sectionTitle == null) {
                        GemfileLockKt.access$getLog$p().warn("Orphan line in the lockfile: " + line);
                        continue;
                    }
                    Collection collection = sectionLines;
                    String string = line.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.add(string);
                    continue;
                }
                if (sectionTitle != null) {
                    ((Collection)sections).add(Section.Companion.create(sectionTitle, CollectionsKt.toList((Iterable)sectionLines)));
                    sectionLines.clear();
                }
                sectionTitle = line;
            }
            if (!sectionLines.isEmpty() && sectionTitle != null) {
                ((Collection)sections).add(Section.Companion.create(sectionTitle, CollectionsKt.toList((Iterable)sectionLines)));
            }
            return sections;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$DefaultSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "title", "", "lines", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "getLines", "()Ljava/util/List;", "toString", "intellij.ruby.backend"})
    public static final class DefaultSection
    implements Section {
        @NotNull
        private final String title;
        @NotNull
        private final List<String> lines;

        public DefaultSection(@NotNull String title, @NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.title = title;
            this.lines = CollectionsKt.toList((Iterable)lines);
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        @NotNull
        public List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public String toString() {
            List<String> list = this.getLines();
            String string = this.getTitle() + "\n";
            return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", (CharSequence)string, null, (int)0, null, DefaultSection::toString$lambda$0, (int)28, null);
        }

        private static final CharSequence toString$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "  " + it;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$DependenciesSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "title", "getTitle", "()Ljava/lang/String;", "getLines", "()Ljava/util/List;", "specs", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec;", "getSpecs", "toString", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nGemfileLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$DependenciesSection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1617#2,9:298\n1869#2:307\n1870#2:309\n1626#2:310\n1#3:308\n*S KotlinDebug\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$DependenciesSection\n*L\n285#1:298,9\n285#1:307\n285#1:309\n285#1:310\n285#1:308\n*E\n"})
    public static final class DependenciesSection
    implements Section {
        @NotNull
        private final String title;
        @NotNull
        private final List<String> lines;
        @NotNull
        private final List<GemSpec> specs;

        /*
         * WARNING - void declaration
         */
        public DependenciesSection(@NotNull List<String> lines) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.title = "DEPENDENCIES";
            this.lines = CollectionsKt.emptyList();
            Iterable iterable = lines;
            DependenciesSection dependenciesSection = this;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                GemSpec it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (GemSpec.Companion.create(((Object)StringsKt.trim((CharSequence)it)).toString()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            dependenciesSection.specs = (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        @NotNull
        public List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public final List<GemSpec> getSpecs() {
            return this.specs;
        }

        @NotNull
        public String toString() {
            return StringsKt.trimIndent((String)("\n        " + this.getTitle() + "\n          specs:\n        ")) + (String)(this.specs.isEmpty() ? "" : "\n" + StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)this.specs, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (String)"    "));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "intellij.ruby.backend"})
    public static final class GemSection
    extends SpecSection {
        public GemSection(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            super("GEM", lines);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0013\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec;", "", "name", "", "version", "platform", "isPinned", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getVersion", "getPlatform", "()Z", "toString", "equals", "other", "hashCode", "", "Companion", "intellij.ruby.backend"})
    public static final class GemSpec {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @Nullable
        private final String version;
        @Nullable
        private final String platform;
        private final boolean isPinned;
        private static final Pattern SPEC_PATTERN = Pattern.compile("([^\\s!]+)(?: \\(([^-]+)(?:-(\\S+))?\\))?(!)?");

        private GemSpec(String name, String version, String platform, boolean isPinned) {
            this.name = name;
            this.version = version;
            this.platform = platform;
            this.isPinned = isPinned;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getPlatform() {
            return this.platform;
        }

        public final boolean isPinned() {
            return this.isPinned;
        }

        @NotNull
        public String toString() {
            return this.name + ", " + this.version + ", " + this.platform + ", " + this.isPinned;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GemSpec)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)((GemSpec)other).name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)((GemSpec)other).version)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.platform, (Object)((GemSpec)other).platform)) {
                return false;
            }
            return this.isPinned == ((GemSpec)other).isPinned;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            String string = this.version;
            result = 31 * result + (string != null ? string.hashCode() : 0);
            String string2 = this.platform;
            result = 31 * result + (string2 != null ? string2.hashCode() : 0);
            result = 31 * result + Boolean.hashCode(this.isPinned);
            return result;
        }

        public /* synthetic */ GemSpec(String name, String version, String platform, boolean isPinned, DefaultConstructorMarker $constructor_marker) {
            this(name, version, platform, isPinned);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec$Companion;", "", "<init>", "()V", "SPEC_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "create", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec;", "line", "", "intellij.ruby.backend"})
        @SourceDebugExtension(value={"SMAP\nGemfileLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final GemSpec create(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (charSequence.length() == 0) {
                    boolean bl = false;
                    return null;
                }
                String trimmedLine = (String)charSequence;
                Matcher matcher = SPEC_PATTERN.matcher(trimmedLine);
                if (!matcher.matches()) {
                    GemfileLockKt.access$getLog$p().warn("Unable to parse spec from " + line);
                    return null;
                }
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                return new GemSpec(string, matcher.group(2), matcher.group(3), matcher.group(4) != null, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GitSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "revision", "getRevision", "()Ljava/lang/String;", "revision$delegate", "Lkotlin/Lazy;", "branch", "getBranch", "branch$delegate", "shortRevision", "getShortRevision", "intellij.ruby.backend"})
    @SourceDebugExtension(value={"SMAP\nGemfileLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GemfileLock.kt\norg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GitSection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
    public static final class GitSection
    extends SpecSection {
        @NotNull
        private final Lazy revision$delegate;
        @NotNull
        private final Lazy branch$delegate;

        public GitSection(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            super("GIT", lines);
            this.revision$delegate = LazyKt.lazyPub(() -> GitSection.revision_delegate$lambda$0(this));
            this.branch$delegate = LazyKt.lazyPub(() -> GitSection.branch_delegate$lambda$0(this));
        }

        @Nullable
        public final String getRevision() {
            Lazy lazy = this.revision$delegate;
            return (String)lazy.getValue();
        }

        @Nullable
        public final String getBranch() {
            Lazy lazy = this.branch$delegate;
            return (String)lazy.getValue();
        }

        @Nullable
        public final String getShortRevision() {
            String string;
            String string2 = this.getRevision();
            if (string2 != null) {
                String string3 = string2.substring(0, 12);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = null;
            }
            return string;
        }

        private static final String revision_delegate$lambda$0(GitSection this$0) {
            String string;
            Object v0;
            block3: {
                Iterable iterable = this$0.getLines();
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"revision: ", (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            String string2 = v0;
            if (string2 != null) {
                String string3 = string2.substring(10);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = null;
            }
            return string;
        }

        private static final String branch_delegate$lambda$0(GitSection this$0) {
            String string;
            Object v0;
            block3: {
                Iterable iterable = this$0.getLines();
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"branch: ", (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            String string2 = v0;
            if (string2 != null) {
                String string3 = string2.substring(8);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$PathSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "intellij.ruby.backend"})
    public static final class PathSection
    extends SpecSection {
        public PathSection(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            super("PATH", lines);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$PluginSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "lines", "", "", "<init>", "(Ljava/util/List;)V", "intellij.ruby.backend"})
    public static final class PluginSection
    extends SpecSection {
        public PluginSection(@NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            super("PLUGIN SOURCE", lines);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u0000 \n2\u00020\u0001:\u0001\nR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "", "title", "", "getTitle", "()Ljava/lang/String;", "lines", "", "getLines", "()Ljava/util/List;", "Companion", "intellij.ruby.backend"})
    public static interface Section {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public String getTitle();

        @NotNull
        public List<String> getLines();

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "title", "", "lines", "", "intellij.ruby.backend"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Section create(@NotNull String title, @NotNull List<String> lines) {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(lines, (String)"lines");
                return switch (title) {
                    case "GIT" -> new GitSection(lines);
                    case "GEM" -> new GemSection(lines);
                    case "PATH" -> new PathSection(lines);
                    case "PLUGIN SOURCE" -> new PluginSection(lines);
                    case "DEPENDENCIES" -> new DependenciesSection(lines);
                    default -> new DefaultSection(title, lines);
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$SpecSection;", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$Section;", "title", "", "allLines", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "remote", "getRemote", "specs", "Lorg/jetbrains/plugins/ruby/gem/bundler/GemfileLock$GemSpec;", "getSpecs", "()Ljava/util/List;", "lines", "getLines", "toString", "intellij.ruby.backend"})
    public static abstract class SpecSection
    implements Section {
        @NotNull
        private final String title;
        @Nullable
        private final String remote;
        @NotNull
        private final List<GemSpec> specs;
        @NotNull
        private final List<String> lines;

        public SpecSection(@NotNull String title, @NotNull List<String> allLines) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(allLines, (String)"allLines");
            this.title = title;
            String remote = null;
            List specs = new ArrayList();
            List lines = new ArrayList();
            boolean inSpecs = false;
            for (String line : allLines) {
                if (((CharSequence)line).length() == 0) continue;
                if (StringsKt.startsWith$default((String)line, (String)"specs:", (boolean)false, (int)2, null)) {
                    inSpecs = true;
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"  ", (boolean)false, (int)2, null)) {
                    if (inSpecs) {
                        GemSpec gemSpec;
                        if (StringsKt.startsWith$default((String)line, (String)"    ", (boolean)false, (int)2, null) || (gemSpec = GemSpec.Companion.create(line)) == null) continue;
                        ((Collection)specs).add(gemSpec);
                        continue;
                    }
                    GemfileLockKt.access$getLog$p().warn("Orphan spec line: " + line);
                    continue;
                }
                inSpecs = false;
                if (StringsKt.startsWith$default((String)line, (String)"remote: ", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)line.substring(8), (String)"substring(...)");
                    continue;
                }
                ((Collection)lines).add(line);
            }
            this.remote = remote;
            this.specs = CollectionsKt.toList((Iterable)specs);
            this.lines = CollectionsKt.toList((Iterable)lines);
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public final String getRemote() {
            return this.remote;
        }

        @NotNull
        public final List<GemSpec> getSpecs() {
            return this.specs;
        }

        @Override
        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public String toString() {
            return StringsKt.trimIndent((String)("\n        " + this.getTitle() + "\n          remote: " + this.remote + "\n          specs:\n        ")) + (String)(this.specs.isEmpty() ? "" : "\n" + StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)this.specs, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (String)"    ")) + (String)(this.lines.isEmpty() ? "" : "\n" + StringsKt.prependIndent((String)CollectionsKt.joinToString$default((Iterable)this.lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (String)"  "));
        }
    }
}

