/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.GemRefParam;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.GroupRefParam;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionConvertable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefProviderBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyHashParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class BundlerParamDefProvider
extends ParamDefProviderBase {
    public static final FQN BUNDLER_CONTEXT_FQN = FQN.of((String)"Bundler::Dsl");

    @Override
    protected void registerParamDefs() {
        this.paramDef("gem", BundlerParamDefProvider.gemRef(), ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.maybe(null), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("group"), ParamDefExpressionUtil.array(BundlerParamDefProvider.groupRef())).add(ParamDefExpressionUtil.s("groups"), ParamDefExpressionUtil.array(BundlerParamDefProvider.groupRef())).add(ParamDefExpressionUtil.s("git"), null).add(ParamDefExpressionUtil.s("path"), null).add(ParamDefExpressionUtil.s("require"), ParamDefExpressionUtil.either(ParamDefExpressionUtil.bool(), null)).add(ParamDefExpressionUtil.s("platform"), BundlerParamDefProvider.platforms()).add(ParamDefExpressionUtil.s("platforms"), BundlerParamDefProvider.platforms()).merge(BundlerParamDefProvider.gitOptions()));
        this.paramDef("source", ParamDefExpressionUtil.either(ParamDefExpressionUtil.oneOf(ParamDefExpressionUtil.s("gemcutter"), ParamDefExpressionUtil.s("rubygems"), ParamDefExpressionUtil.s("rubyforge"), "http://gemcutter.org", "https://rubygems.org", "http://gems.rubyforge.org"), null), ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("prepend"), ParamDefExpressionUtil.bool()));
        this.paramDef("git", ParamDefExpressionUtil.nil(), BundlerParamDefProvider.gitOptions());
        this.paramDef("group", ParamDefExpressionUtil.array(BundlerParamDefProvider.groupRef()));
        this.paramDef("platform", BundlerParamDefProvider.platforms());
        this.paramDef("platforms", BundlerParamDefProvider.platforms());
        this.paramDef("gemspec", ParamDefExpressionUtil.hash().add(ParamDefExpressionUtil.s("name"), null).add(ParamDefExpressionUtil.s("path"), null));
    }

    private static ParamDefExpressionConvertable gemRef() {
        return new GemRefParam();
    }

    private static ParamDefExpressionConvertable groupRef() {
        return ParamDefExpressionUtil.either(new GroupRefParam(), null);
    }

    private static ParamDefExpressionConvertable platforms() {
        ArrayList<String> platforms = new ArrayList<String>(Arrays.asList("ruby", "mri", "mingw", "x64_mingw", "rbx", "jruby", "truffleruby", "mswin"));
        List versions = ContainerUtil.map((Object[])LanguageLevel.values(), LanguageLevel::getCode);
        versions.stream().map(version -> "ruby_" + version).forEach(platforms::add);
        versions.stream().map(version -> "mri_" + version).forEach(platforms::add);
        versions.stream().map(version -> "mingw_" + version).forEach(platforms::add);
        List<Integer> x64MingwVersions = Arrays.stream(LanguageLevel.values()).filter(arg_0 -> ((LanguageLevel)LanguageLevel.RUBY19).isLessThan(arg_0)).map(LanguageLevel::getCode).toList();
        x64MingwVersions.stream().map(version -> "x64_mingw_" + version).forEach(platforms::add);
        ContainerUtil.sort(platforms);
        return ParamDefExpressionUtil.array(ParamDefExpressionUtil.oneOf(ContainerUtil.map(platforms, ParamDefExpressionUtil::s).toArray()));
    }

    private void paramDef(String methodName, ParamDefExpressionConvertable ... expressions) {
        this.paramDef(BUNDLER_CONTEXT_FQN.getFullPath(), methodName, expressions);
    }

    private static RubyHashParamDef gitOptions() {
        return ParamDefExpressionUtil.hash().add("branch", null).add("ref", null).add("tag", null);
    }
}

