/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;
import org.jetbrains.plugins.ruby.gem.bundler.GemfileLock;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.util.StreamUtil;

public final class BundlerGitLockReader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(BundlerGitLockReader.class);
    private Map<String, @NotNull GemDependency> myGemToDep;
    private VirtualFile myLockFile;
    private long myTimestamp = -1L;
    private final Module myModule;

    public BundlerGitLockReader(Module module) {
        this.myModule = module;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES_BG, (Object)new BulkFileListenerBackgroundable(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (1.isBundleConfigDirUpdated(events) || 1.isBundleConfigFileUpdated(events)) {
                    BundleConfigServiceImpl.getInstance(BundlerGitLockReader.this.myModule.getProject()).queueUpdate();
                    BundlerGitLockReader.this.myTimestamp = -1L;
                }
            }

            private static boolean isBundleConfigDirUpdated(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                return events.stream().mapMulti(StreamUtil.select(VFileCreateEvent.class, (Class[])new Class[]{VFileMoveEvent.class, VFileDeleteEvent.class})).map(VFileEvent::getFile).filter(Objects::nonNull).flatMap(vFile -> vFile.isDirectory() && vFile.getName().equals(".bundle") ? Arrays.stream(vFile.getChildren()) : Stream.of(vFile)).anyMatch(BundleConfig::isConfig);
            }

            private static boolean isBundleConfigFileUpdated(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(2);
                }
                return events.stream().mapMulti(StreamUtil.select(VFileContentChangeEvent.class, (Class[])new Class[]{VFileMoveEvent.class, VFileDeleteEvent.class})).map(VFileEvent::getFile).filter(Objects::nonNull).anyMatch(BundleConfig::isConfig);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGitLockReader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isBundleConfigDirUpdated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isBundleConfigFileUpdated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public Map<String, @NotNull GemDependency> getDependencies() {
        return Collections.unmodifiableMap(this.myGemToDep);
    }

    public void dispose() {
    }

    public static BundlerGitLockReader getInstance(@NotNull Module module) {
        if (module == null) {
            BundlerGitLockReader.$$$reportNull$$$0(0);
        }
        return (BundlerGitLockReader)module.getService(BundlerGitLockReader.class);
    }

    @Nullable
    public GemDependency getDependency(String gemName) {
        this.checkReload();
        return this.myGemToDep.get(gemName);
    }

    public boolean isLocked() {
        this.checkReload();
        return this.myLockFile != null;
    }

    private void checkReload() {
        ReadAction.run(() -> {
            if (this.myGemToDep == null || this.myLockFile == null || !this.myLockFile.isValid() || this.myLockFile.getTimeStamp() != this.myTimestamp) {
                this.myGemToDep = this.reload();
            }
        });
    }

    @NotNull
    private @NotNull Map<String, @NotNull GemDependency> reload() {
        this.myLockFile = BundlerUtil.getGemfileLock(this.myModule);
        long l = this.myTimestamp = this.myLockFile != null ? this.myLockFile.getTimeStamp() : -1L;
        if (this.myLockFile == null || !this.myLockFile.isValid()) {
            Map<String, GemDependency> map = Collections.emptyMap();
            if (map == null) {
                BundlerGitLockReader.$$$reportNull$$$0(1);
            }
            return map;
        }
        GemfileLock lockFile = GemfileLock.Companion.from(this.myLockFile);
        if (lockFile == null) {
            LOG.warn("Unable to parse the lockfile: " + String.valueOf(this.myLockFile));
            Map<String, GemDependency> map = Collections.emptyMap();
            if (map == null) {
                BundlerGitLockReader.$$$reportNull$$$0(2);
            }
            return map;
        }
        return BundlerGitLockReader.buildDependenciesMap(lockFile, this.myLockFile.getParent());
    }

    @ApiStatus.Internal
    @NotNull
    public static @NotNull Map<String, @NotNull GemDependency> buildDependenciesMap(@NotNull GemfileLock lockFile, @Nullable VirtualFile relativeRoot) {
        if (lockFile == null) {
            BundlerGitLockReader.$$$reportNull$$$0(3);
        }
        HashMap<String, @NotNull GemDependency> result = new HashMap<String, GemDependency>();
        String[] platformsArray = BundlerGitLockReader.computePlatformsArrays(lockFile);
        for (GemfileLock.SpecSection specSection : lockFile.getSpecSections()) {
            String ref = null;
            boolean inGit = false;
            if (specSection instanceof GemfileLock.GitSection) {
                GemfileLock.GitSection gitSection = (GemfileLock.GitSection)specSection;
                ref = gitSection.getShortRevision();
                inGit = true;
            }
            String url = null;
            boolean inPath = false;
            if (specSection instanceof GemfileLock.PathSection) {
                inPath = true;
                url = GemUtil.getGemUrlFromPath(specSection.getRemote(), relativeRoot);
            }
            for (GemfileLock.GemSpec gemSpec : specSection.getSpecs()) {
                if (gemSpec.getVersion() == null) continue;
                GemDependency dependency = GemDependency.create(gemSpec.getName(), new String[]{gemSpec.getVersion()}, url, null, inGit, ref, true, inPath, platformsArray, null);
                if (dependency == null) continue;
                result.put(gemSpec.getName(), dependency);
            }
        }
        String bundledWith = lockFile.getBundledWith();
        if (bundledWith != null) {
            GemDependency bundlerDependency = GemDependency.create("bundler", "=" + bundledWith);
            if (bundlerDependency != null) {
                result.put("bundler", bundlerDependency);
            } else {
                LOG.error("Unable to create a bundler dependency from: " + bundledWith);
            }
        }
        HashMap<String, GemDependency> hashMap = result;
        if (hashMap == null) {
            BundlerGitLockReader.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static String @NotNull [] computePlatformsArrays(@NotNull GemfileLock lockFile) {
        if (lockFile == null) {
            BundlerGitLockReader.$$$reportNull$$$0(5);
        }
        SmartList platforms = null;
        for (String platform : lockFile.getPlatforms()) {
            if (platforms == null) {
                platforms = new SmartList();
            }
            if (platform.contains("java")) {
                platforms.add("java");
                continue;
            }
            if (!platform.contains("ruby")) break;
            platforms.add("ruby");
        }
        String[] stringArray = ArrayUtilRt.toStringArray(platforms);
        if (stringArray == null) {
            BundlerGitLockReader.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGitLockReader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lockFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGitLockReader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reload";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDependenciesMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePlatformsArrays";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildDependenciesMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformsArrays";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

