/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigDataService;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public final class BundleConfig {
    public static final String CONFIG_FILE_NAME = "config";
    private static final String BUNDLE_CONFIG_RELATIVE_PATH = FileUtil.join((String[])new String[]{".bundle", "config"});
    private static final String BUNDLE_ENV_PREFIX = "BUNDLE_";
    static final String PATH_TO_USER_BUNDLE_FOLDER = FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), ".bundle"});
    static final String PATH_TO_USER_BUNDLE_CONFIG = FileUtil.join((String[])new String[]{PATH_TO_USER_BUNDLE_FOLDER, "config"});
    private static final String LOCAL_GEM_PREFIX_CANONICAL = "local.";
    private static final String LOCAL_GEM_PREFIX_ENV = BundleConfig.buildEnvKey("local.");
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final VirtualFile myRoot;

    private BundleConfig(@NotNull VirtualFile configFile, @NotNull VirtualFile root) {
        if (configFile == null) {
            BundleConfig.$$$reportNull$$$0(0);
        }
        if (root == null) {
            BundleConfig.$$$reportNull$$$0(1);
        }
        this.myConfigFile = configFile;
        this.myRoot = root;
    }

    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            BundleConfig.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            BundleConfig.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public Map<String, String> getValues() {
        Map<String, String> map = BundleConfigDataService.getInstance().getValues(this.myConfigFile);
        if (map == null) {
            BundleConfig.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Contract(value="null->null")
    @Nullable
    public String getValue(@Nullable String key) {
        return this.getValues().get(key);
    }

    @NotNull
    public Map<String, String> getLocalGemsPathNamesMap() {
        Ref resultRef = Ref.create();
        this.getValues().forEach((key, val) -> {
            if (!StringUtil.startsWith((CharSequence)key, (CharSequence)LOCAL_GEM_PREFIX_ENV)) {
                return;
            }
            if (resultRef.isNull()) {
                resultRef.set(new HashMap());
            }
            ((Map)resultRef.get()).put(StringUtil.toLowerCase((String)StringUtil.trimStart((String)key, (String)LOCAL_GEM_PREFIX_ENV)), val);
        });
        Map map = resultRef.isNull() ? Collections.emptyMap() : (Map)resultRef.get();
        if (map == null) {
            BundleConfig.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Contract(value="null->null")
    @Nullable
    public String getPathValue(@Nullable String key) {
        return (String)ObjectUtils.doIfNotNull((Object)this.getValue(key), path -> OSAgnosticPathUtil.expandUserHome((String)path));
    }

    @Contract(value="null->null")
    @Nullable
    public VirtualFile getPathValueVirtualFile(@Nullable String key) {
        return (VirtualFile)ReadAction.nonBlocking(() -> {
            if (!this.myRoot.isValid() || !this.myRoot.isDirectory() || key == null) {
                return null;
            }
            String pathName = this.getPathValue(key);
            if (StringUtil.isEmpty((String)pathName)) {
                return null;
            }
            return FileUtil.isAbsolute((String)pathName) ? VfsUtil.findFileByIoFile((File)new File(pathName), (boolean)false) : this.myRoot.findFileByRelativePath(pathName);
        }).executeSynchronously();
    }

    @Nullable
    public VirtualFile getBundlePathVirtualFile() {
        return this.getPathValueVirtualFile("BUNDLE_PATH");
    }

    @Nullable
    public List<String> getBundleWithout() {
        return (List)ObjectUtils.doIfNotNull((Object)this.getValue("BUNDLE_WITHOUT"), it -> Arrays.asList(it.split(":")));
    }

    @Nullable
    public VirtualFile getBundleGemfileVirtualFile() {
        return this.getPathValueVirtualFile("BUNDLE_GEMFILE");
    }

    @NotNull
    private static String buildEnvKey(@NotNull String canonicalKey) {
        if (canonicalKey == null) {
            BundleConfig.$$$reportNull$$$0(6);
        }
        String string = BUNDLE_ENV_PREFIX + StringUtil.replace((String)canonicalKey, (String)".", (String)"__").toUpperCase(Locale.getDefault());
        if (string == null) {
            BundleConfig.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    @Nullable
    private static BundleConfig create(@Nullable VirtualFile configFile, @Nullable VirtualFile configRoot) {
        return (BundleConfig)ReadAction.nonBlocking(() -> {
            if (!(configFile != null && configRoot != null && configRoot.isValid() && configFile.isValid() && BundleConfig.isConfig(configFile))) {
                return null;
            }
            return new BundleConfig(configFile, configRoot);
        }).executeSynchronously();
    }

    @Contract(value="null -> null")
    @Nullable
    static BundleConfig createConfig(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        Ref configRef = Ref.create();
        RModuleUtil.processFilesInModuleRoot(module, false, false, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(file, root) -> {
            configRef.set((Object)BundleConfig.create(file, root));
            return false;
        }), BUNDLE_CONFIG_RELATIVE_PATH);
        return (BundleConfig)configRef.get();
    }

    @Contract(value="null -> null")
    @Nullable
    static BundleConfig createUserConfig(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = RModuleUtil.getContentRoots(module);
        return roots.length == 0 ? null : BundleConfig.createUserConfig(roots[0]);
    }

    @Nullable
    private static BundleConfig createUserConfig(@NotNull VirtualFile configRoot) {
        if (configRoot == null) {
            BundleConfig.$$$reportNull$$$0(8);
        }
        return BundleConfig.create(VfsUtil.findFileByIoFile((File)new File(PATH_TO_USER_BUNDLE_CONFIG), (boolean)false), configRoot);
    }

    public static boolean isConfig(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && CONFIG_FILE_NAME.equals(file.getName()) && BundlerUtil.isBundlerDir(file.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsPathNamesMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEnvKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildEnvKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createUserConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

