/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunner;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class GemsRunner {
    private GemsRunner() {
    }

    public static void runGemScriptInConsoleAndRefreshModule(final @NotNull Module module, final @NotNull Sdk sdk, @NlsContexts.TabTitle @NotNull String consoleTitle, AnAction @Nullable [] userActions, @NotNull String gemName, @Nullable String gemVersion, @NotNull String gemExecutableScriptName, @Nullable String workingDir, @Nullable RubyCommandLineArgumentsProvider provider, @Nullable RunContentDescriptorFactory descriptorFactory, Filter[] filters, final @Nullable Runnable onDone, boolean viaBundler, final @Nullable String rubyOpt) {
        String[] scriptCommands;
        if (module == null) {
            GemsRunner.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            GemsRunner.$$$reportNull$$$0(1);
        }
        if (consoleTitle == null) {
            GemsRunner.$$$reportNull$$$0(2);
        }
        if (gemName == null) {
            GemsRunner.$$$reportNull$$$0(3);
        }
        if (gemExecutableScriptName == null) {
            GemsRunner.$$$reportNull$$$0(4);
        }
        try {
            scriptCommands = ((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, gemName).withModule(module)).withGemVersion(gemVersion).withGemScriptName(gemExecutableScriptName).getScriptExecutionCommands();
        }
        catch (ExecutionException e) {
            return;
        }
        if (scriptCommands == null) {
            return;
        }
        if (scriptCommands.length > 1) {
            scriptCommands[scriptCommands.length - 1] = RubySdkUtil.convertToRemote(sdk, module, scriptCommands[scriptCommands.length - 1]);
        }
        ProcessListener processListener = new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module.isDisposed()) {
                    return;
                }
                RubySdkGemLibraryManager.getInstance().refreshRoots(sdk);
                if (onDone != null) {
                    onDone.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/gem/GemsRunner$1", "processTerminated"));
            }
        };
        MergingCommandLineArgumentsProvider resultProvider = new MergingCommandLineArgumentsProvider(scriptCommands, provider, null, null);
        CmdlinePreprocessor cmdlinePreprocessor = null;
        if (viaBundler) {
            cmdlinePreprocessor = BundlerUtil.getBundlerPreprocessor(sdk, module);
        }
        if (StringUtil.isNotEmpty((String)rubyOpt)) {
            final CmdlinePreprocessor preprocessor = cmdlinePreprocessor;
            cmdlinePreprocessor = new CmdlinePreprocessor(){

                @Override
                public void preprocess(@NotNull GeneralCommandLine cmdline) {
                    Map environment;
                    String currentRubyOpt;
                    if (cmdline == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String resultRubyOpt = StringUtil.isEmpty((String)(currentRubyOpt = (String)(environment = cmdline.getEnvironment()).get("RUBYOPT"))) ? rubyOpt : currentRubyOpt + " " + rubyOpt;
                    environment.put("RUBYOPT", resultRubyOpt);
                    if (preprocessor != null) {
                        preprocessor.preprocess(cmdline);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdline", "org/jetbrains/plugins/ruby/gem/GemsRunner$2", "preprocess"));
                }
            };
        }
        ConsoleRunnerOptions runnerOptions = ConsoleRunnerOptions.builder(module, consoleTitle).withCmdlinePreprocessor(cmdlinePreprocessor).withProcessListeners(processListener).withFilters(filters).withUserActions(userActions).withWorkingDirectory(workingDir).withRunContentDescriptorFactory(descriptorFactory).build();
        ConsoleRunner.run(runnerOptions, resultProvider, sdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consoleTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "gemName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "gemExecutableScriptName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/gem/GemsRunner";
        objectArray[2] = "runGemScriptInConsoleAndRefreshModule";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

