/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtilBase;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class GemUtil {
    public static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z0-9\\-_.]*");
    private static final String GEMSPEC_EXTENSION = "gemspec";
    public static final String GEM = "gem";
    private static final Logger LOG = Logger.getInstance(GemUtil.class);
    @NonNls
    private static final Pattern GEM_DIR_PATTERN = Pattern.compile("(.+)-([\\d.]+)");
    @NonNls
    private static final String README = "readme";

    private GemUtil() {
    }

    @Nullable
    public static String findScriptInBinDir(@NotNull String rubyScriptName, @Nullable VirtualFile gemRootBinDir) {
        if (rubyScriptName == null) {
            GemUtil.$$$reportNull$$$0(0);
        }
        return gemRootBinDir == null ? null : GemUtil.findExecutableRubyScriptPath(rubyScriptName, gemRootBinDir.getPath());
    }

    @Nullable
    static String findExecutableRubyScriptPath(@NotNull String rubyScriptName, @NotNull String dir) {
        Path path;
        if (rubyScriptName == null) {
            GemUtil.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            GemUtil.$$$reportNull$$$0(2);
        }
        if (Files.isRegularFile(path = Paths.get(dir, rubyScriptName), new LinkOption[0])) {
            return FileUtil.toSystemDependentName((String)path.toString());
        }
        Path cmdPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".cmd");
        if (Files.isRegularFile(cmdPath, new LinkOption[0])) {
            return FileUtil.toSystemDependentName((String)cmdPath.toString());
        }
        Path rbPath = path.resolveSibling(String.valueOf(path.getFileName()) + "." + RubyFileType.RUBY.getDefaultExtension());
        if (Files.isRegularFile(rbPath, new LinkOption[0])) {
            return FileUtil.toSystemDependentName((String)rbPath.toString());
        }
        return null;
    }

    public static boolean isGemExecutableRubyScriptExists(@Nullable Module module, @Nullable Sdk sdk, @NotNull String gemName, @NotNull String rubyScriptName) {
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(3);
        }
        if (rubyScriptName == null) {
            GemUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.isNotEmpty((String)RubyGemExecutionContext.getScriptPath(sdk, module, gemName, rubyScriptName));
    }

    @NotNull
    public static String getGemUrlFromPath(@Nullable String path, @Nullable VirtualFile relativeRoot) {
        VirtualFile dir;
        path = StringUtil.startsWithChar((CharSequence)(path = TextUtil.trimTrailingSlashes((String)path)), (char)'~') ? SystemProperties.getUserHome() + path.substring(1) : path;
        VirtualFile virtualFile = dir = relativeRoot != null ? relativeRoot.findFileByRelativePath(path) : null;
        if (dir != null) {
            String string = dir.getUrl();
            if (string == null) {
                GemUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = VfsUtilCore.pathToUrl((String)FileUtil.toCanonicalPath((String)path));
        if (string == null) {
            GemUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static List<VirtualFile> getAllGemsLibUrls(@NotNull VirtualFile gemRoot) {
        if (gemRoot == null) {
            GemUtil.$$$reportNull$$$0(7);
        }
        HashMap<String, Pair> gems = new HashMap<String, Pair>();
        ArrayList<VirtualFile> gemsUrls = new ArrayList<VirtualFile>();
        for (VirtualFile file : gemRoot.getChildren()) {
            VirtualFile child = file.findChild("lib");
            if (child != null) {
                Matcher m = GEM_DIR_PATTERN.matcher(file.getName());
                if (m.find()) {
                    String gemName = m.group(1);
                    String gemVersion = m.group(2);
                    Pair oldGem = (Pair)gems.get(gemName);
                    if (oldGem != null && VersionComparatorUtil.compare((String)((String)oldGem.first), (String)gemVersion) >= 0) continue;
                    gems.put(gemName, Pair.create((Object)gemVersion, (Object)child));
                    continue;
                }
                gemsUrls.add(child);
                continue;
            }
            LOG.debug("No 'lib' dir found for gem " + file.getPath());
        }
        for (Pair gemInfo : gems.values()) {
            gemsUrls.add((VirtualFile)gemInfo.second);
        }
        ArrayList<VirtualFile> arrayList = gemsUrls;
        if (arrayList == null) {
            GemUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static boolean isGemsRootUrl(@NotNull String url) {
        if (url == null) {
            GemUtil.$$$reportNull$$$0(9);
        }
        return url.endsWith("/gems");
    }

    @NotNull
    public static Set<String> determineGemUrlsForSDK(@Nullable Sdk sdk) {
        if (sdk == null) {
            return new LinkedHashSet<String>();
        }
        SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
        if (!(additionalData instanceof RubySdkAdditionalData)) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!RubySdkUtil.isMockSdk(sdk) && !(RubySdkAdditionalData.from(sdk) instanceof RubyRemoteSdkAdditionalData)) {
            result.add(VirtualFileUtil.constructLocalUrl(RubyImplementationHandler.notNullFrom(sdk).getDefaultGemBoxPath()));
        }
        result.addAll(GemUtil.computeGemUrlsForSDK(sdk));
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            GemUtil.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<String> determineGemUrlsForSdkConsideringRbenvGemsets(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemUtil.$$$reportNull$$$0(11);
        }
        Set<String> urls = GemUtil.determineGemUrlsForSDK(sdk);
        if (!RbenvGemsetManager.isRbenvSdk(sdk) || RbenvGemsetManager.isRootRbenvSdk(sdk)) {
            Set<String> set = Collections.unmodifiableSet(urls);
            if (set == null) {
                GemUtil.$$$reportNull$$$0(12);
            }
            return set;
        }
        Collection<String> collection = GemManager.filterGemsetBoxUrls(urls, ContainerUtil.createMaybeSingletonList((Object)RbenvGemsetManager.getRbenvGemset(sdk)));
        if (collection == null) {
            GemUtil.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    private static Set<String> computeGemUrlsForSDK(@NotNull Sdk sdk) {
        RubySdkAdditionalData additionalData;
        LinkedHashSet<String> result;
        if (sdk == null) {
            GemUtil.$$$reportNull$$$0(14);
        }
        if (!(result = new LinkedHashSet<String>(GemUtil.getSavedGemRootUrls(additionalData = RubySdkAdditionalData.notNullFrom(sdk)))).isEmpty()) {
            LinkedHashSet<String> linkedHashSet = result;
            if (linkedHashSet == null) {
                GemUtil.$$$reportNull$$$0(15);
            }
            return linkedHashSet;
        }
        result.addAll(GemUtil.determineRvmSdkGemUrls(sdk));
        if (!result.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = result;
            if (linkedHashSet == null) {
                GemUtil.$$$reportNull$$$0(16);
            }
            return linkedHashSet;
        }
        result.addAll(RbenvGemsetManager.getGemsetGemsURLs(sdk));
        if (!result.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = result;
            if (linkedHashSet == null) {
                GemUtil.$$$reportNull$$$0(17);
            }
            return linkedHashSet;
        }
        try {
            for (String rootPath : RubyGemsEnvironment.getGemPaths(sdk)) {
                result.add(VirtualFileUtil.constructLocalUrl(rootPath + "/gems"));
            }
            BundlerUtil.addBundlerPaths(sdk, result);
        }
        catch (Exception e) {
            LOG.info("Problem with gem urls", (Throwable)e);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            GemUtil.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<String> getSavedGemRootUrls(@NotNull RubySdkAdditionalData data) {
        List<String> urls;
        if (data == null) {
            GemUtil.$$$reportNull$$$0(19);
        }
        if ((urls = data.getGemsRootUrls()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GemUtil.$$$reportNull$$$0(20);
            }
            return set;
        }
        List<String> list = urls;
        if (list == null) {
            GemUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static Set<String> determineRvmSdkGemUrls(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemUtil.$$$reportNull$$$0(22);
        }
        if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GemUtil.$$$reportNull$$$0(23);
            }
            return set;
        }
        Set<String> paths = RVMSupportUtil.determineGemRootsPaths(sdk);
        String bundlerGemUrl = BundlerUtil.addRVMBundleUrl(sdk);
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (bundlerGemUrl != null) {
            urls.add(bundlerGemUrl);
        }
        for (String path : paths) {
            urls.add(VirtualFileUtil.constructLocalUrl(path));
        }
        LinkedHashSet<String> linkedHashSet = urls;
        if (linkedHashSet == null) {
            GemUtil.$$$reportNull$$$0(24);
        }
        return linkedHashSet;
    }

    @Nullable
    public static String getGemReadme(@NotNull VirtualFile gemFile) {
        if (gemFile == null) {
            GemUtil.$$$reportNull$$$0(25);
        }
        VirtualFile readme = null;
        for (VirtualFile file : gemFile.getChildren()) {
            if (!README.equals(StringUtil.toLowerCase((String)file.getNameWithoutExtension()))) continue;
            readme = file;
            break;
        }
        if (readme != null) {
            try {
                return VfsUtilCore.loadText(readme);
            }
            catch (IOException e) {
                LOG.warn("Failed to read description", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getSpecFolder(VirtualFile parent) {
        VirtualFile grandParent = parent != null ? parent.getParent() : null;
        return grandParent != null ? grandParent.findChild("specifications") : null;
    }

    public static boolean isGemOrRailsPluginSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk, String @NotNull [] gemNames, String @NotNull [] pluginsNames) {
        if (module == null) {
            GemUtil.$$$reportNull$$$0(26);
        }
        if (sdk == null) {
            GemUtil.$$$reportNull$$$0(27);
        }
        if (gemNames == null) {
            GemUtil.$$$reportNull$$$0(28);
        }
        if (pluginsNames == null) {
            GemUtil.$$$reportNull$$$0(29);
        }
        for (String gemName : gemNames) {
            if (RubyProjectGemSearchService.Companion.findGem(module, gemName) == null && RubyGemSearchUtil.findGem(module, sdk, gemName) == null) continue;
            return true;
        }
        return GemUtil.isPluginSupportEnabled(module, pluginsNames);
    }

    public static boolean isGemOrRailsPluginSupportEnabled(@NotNull Module module, String @NotNull [] gemNames, String @NotNull [] pluginsNames) {
        if (module == null) {
            GemUtil.$$$reportNull$$$0(30);
        }
        if (gemNames == null) {
            GemUtil.$$$reportNull$$$0(31);
        }
        if (pluginsNames == null) {
            GemUtil.$$$reportNull$$$0(32);
        }
        for (String gemName : gemNames) {
            GemInfo gem = RubyProjectGemSearchService.Companion.findGem(module, gemName);
            if (gem == null) continue;
            return true;
        }
        return GemUtil.isPluginSupportEnabled(module, pluginsNames);
    }

    private static boolean isPluginSupportEnabled(@NotNull Module module, String @NotNull [] pluginsNames) {
        if (module == null) {
            GemUtil.$$$reportNull$$$0(33);
        }
        if (pluginsNames == null) {
            GemUtil.$$$reportNull$$$0(34);
        }
        if (pluginsNames.length == 0 || !RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        for (VirtualFile pluginsRoot : RailsPaths.getInstance(module).findFiles("vendor", "plugins")) {
            if (!pluginsRoot.isValid()) continue;
            for (String name : pluginsNames) {
                if (pluginsRoot.findChild(name) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static VirtualFile getGemOrRailsPluginLibDir(@NotNull Module module, @NotNull String gemName, String @NotNull [] pluginsNames) {
        GemInfo gem;
        if (module == null) {
            GemUtil.$$$reportNull$$$0(35);
        }
        if (gemName == null) {
            GemUtil.$$$reportNull$$$0(36);
        }
        if (pluginsNames == null) {
            GemUtil.$$$reportNull$$$0(37);
        }
        if ((gem = RubyProjectGemSearchService.Companion.findGem(module, gemName)) != null) {
            return gem.getLibFolder();
        }
        for (VirtualFile pluginsRoot : RailsPaths.getInstance(module).findFiles("vendor", "plugins")) {
            if (!pluginsRoot.isValid()) continue;
            for (String name : pluginsNames) {
                VirtualFile pluginRootDir = pluginsRoot.findChild(name);
                if (pluginRootDir == null) continue;
                return pluginRootDir.findChild("lib");
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findGemspecFile(@NotNull VirtualFile gemDir, @NotNull String specNameFileName) {
        if (gemDir == null) {
            GemUtil.$$$reportNull$$$0(38);
        }
        if (specNameFileName == null) {
            GemUtil.$$$reportNull$$$0(39);
        }
        return gemDir.findChild(specNameFileName + ".gemspec");
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findGemspecFileInSpecOrCurrent(@Nullable VirtualFile gemDir) {
        VirtualFile gemPath = gemDir != null ? gemDir.getParent() : null;
        VirtualFile specFolder = gemPath != null ? GemUtil.getSpecFolder(gemPath) : null;
        VirtualFile spec = specFolder != null ? GemUtil.findGemspecFile(specFolder, gemDir.getName()) : null;
        return spec != null ? spec : GemUtil.findGemspecFile(gemDir);
    }

    public static Set<GemDependency> getMissingDependencies(Sdk sdk, Module module, Set<GemDependency> requirements) {
        HashSet<GemInfo> gems = new HashSet<GemInfo>(GemManager.getInstance().getAllGems(sdk, module));
        GemManager.addModuleGems(module, gems);
        HashSet<GemDependency> toInstall = new HashSet<GemDependency>();
        for (GemDependency requirement : requirements) {
            if (ContainerUtil.exists(gems, requirement::isSatisfied)) continue;
            toInstall.add(requirement);
        }
        return toInstall;
    }

    @Contract(value="null->false")
    public static boolean isGemModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!GemUtil.doesLookLikeGemRoot(root)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean doesLookLikeGemRoot(@Nullable VirtualFile root) {
        if (root == null) {
            return false;
        }
        for (VirtualFile file : root.getChildren()) {
            if (GemUtil.isGemspecFile(file)) {
                return true;
            }
            if (!RakeUtilBase.isRakeFileByNamingConventions(file)) continue;
            try {
                String text = VfsUtilCore.loadText((VirtualFile)file);
                if (!text.contains("Gem::Specification")) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean isGemspecFile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && GEMSPEC_EXTENSION.equals(virtualFile.getExtension());
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findGemLibDirectory(@Nullable VirtualFile gemRoot) {
        if (gemRoot == null) {
            return null;
        }
        VirtualFile libDirectory = gemRoot.findChild("lib");
        if (libDirectory != null && libDirectory.isDirectory()) {
            return libDirectory;
        }
        libDirectory = gemRoot.findChild("ext");
        return libDirectory != null && libDirectory.isDirectory() ? libDirectory : null;
    }

    @Contract(value="null->null")
    @Nullable
    public static VirtualFile findGemspecFile(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile gemSpecFile = GemUtil.findGemspecFile(root);
            if (gemSpecFile == null) continue;
            return gemSpecFile;
        }
        return null;
    }

    @Contract(value="null->null")
    @Nullable
    public static VirtualFile findGemspecFile(@Nullable VirtualFile rootDirectory) {
        if (rootDirectory == null) {
            return null;
        }
        for (VirtualFile file : rootDirectory.getChildren()) {
            if (!GemUtil.isGemspecFile(file) || file.getName().startsWith(".")) continue;
            return file;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 10, 12, 13, 15, 16, 17, 18, 20, 21, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyScriptName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: 
            case 14: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 26: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemNames";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsNames";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemDir";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specNameFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemUrlFromPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGemsLibUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGemUrlsForSDK";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "determineGemUrlsForSdkConsideringRbenvGemsets";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeGemUrlsForSDK";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavedGemRootUrls";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "determineRvmSdkGemUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScriptInBinDir";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableRubyScriptPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGemExecutableRubyScriptExists";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllGemsLibUrls";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isGemsRootUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "determineGemUrlsForSdkConsideringRbenvGemsets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeGemUrlsForSDK";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSavedGemRootUrls";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "determineRvmSdkGemUrls";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGemReadme";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isGemOrRailsPluginSupportProbablyEnabled";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isGemOrRailsPluginSupportEnabled";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isPluginSupportEnabled";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getGemOrRailsPluginLibDir";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findGemspecFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 10, 12, 13, 15, 16, 17, 18, 20, 21, 23, 24 -> new IllegalStateException(string);
        };
    }
}

