/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemSpecContext;
import org.jetbrains.plugins.ruby.gem.GemsSpecKeys;
import org.jetbrains.plugins.ruby.ruby.RubyFileSystemUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.yaml.snakeyaml.error.YAMLException;

public final class GemSpecParser
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GemSpecParser.class);
    @NonNls
    static final String NAME_ATTRIBUTE = "name";
    @NonNls
    static final String VERSION_ATTRIBUTE = "version";
    @NonNls
    static final String AUTHORS_ATTRIBUTE = "authors";
    @NonNls
    static final String EMAIL_ATTRIBUTE = "email";
    @NonNls
    static final String HOMEPAGE_ATTRIBUTE = "homepage";
    @NonNls
    static final String SUMMARY_ATTRIBUTE = "summary";
    @NonNls
    static final String DESCRIPTION_ATTRIBUTE = "description";
    @NonNls
    static final String DEPENDENCIES_ATTRIBUTE = "add_dependency";
    @NonNls
    static final String RUNTIME_DEPENDENCIES_ATTRIBUTE = "add_runtime_dependency";
    @NonNls
    static final String DEVELOPMENT_DEPENDENCIES_ATTRIBUTE = "add_development_dependency";
    @NonNls
    static final String REQUIRE_PATHS = "require_paths";
    @NonNls
    static final String GIT_ATTRIBUTE = "git";
    @NonNls
    static final String REF_ATTRIBUTE = "ref";
    @NonNls
    static final String DOT_FREEZE_SUFFIX = ".freeze";
    @NonNls
    static final String FREEZE_SUFFIX = "\".freeze";
    private final Map<String, GemSpecContext> mySpecs = new HashMap<String, GemSpecContext>();
    private final Set<VirtualFile> myWatchRequests = ConcurrentCollectionFactory.createConcurrentSet();
    @NonNls
    private static final Pattern VERSION_VERIFIER = Pattern.compile("([0-9]+(\\.[0-9A-z]+)*)");

    @NotNull
    public static String unquoteString(@NotNull String rawValue) {
        if (rawValue == null) {
            GemSpecParser.$$$reportNull$$$0(0);
        }
        String string = GemSpecParser.isFrozenQuoted(rawValue) ? GemSpecParser.unfreezeQuoted(rawValue) : TextUtil.removeQuoting((String)rawValue);
        if (string == null) {
            GemSpecParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String unfreezeQuoted(@NotNull String valueText) {
        if (valueText == null) {
            GemSpecParser.$$$reportNull$$$0(2);
        }
        String string = valueText.substring(1, valueText.length() - FREEZE_SUFFIX.length());
        if (string == null) {
            GemSpecParser.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isFrozenQuoted(String valueText) {
        return valueText.startsWith("\"") && valueText.endsWith(FREEZE_SUFFIX);
    }

    @Nullable
    private static String unfreeze(@Nullable String valueText) {
        return valueText == null ? null : valueText.substring(0, valueText.length() - FREEZE_SUFFIX.length() + 1);
    }

    public GemSpecParser() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent.getFile() == null || !(vFileEvent instanceof VFileDeleteEvent)) continue;
                    GemSpecParser.this.mySpecs.remove(vFileEvent.getFile().getPath());
                }
            }

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent.getFile() == null || !(vFileEvent instanceof VFileDeleteEvent)) continue;
                    GemSpecParser.this.mySpecs.remove(vFileEvent.getFile().getPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static GemSpecParser getInstance() {
        return (GemSpecParser)ApplicationManager.getApplication().getService(GemSpecParser.class);
    }

    @Nullable
    public GemSpecContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile) {
        return this.getGemSpec(gemFile, specFile, false);
    }

    @Nullable
    public GemSpecContext getGemSpec(@Nullable VirtualFile gemFile, @Nullable VirtualFile specFile, boolean isProjectGemSpec) {
        GemSpecContext spec;
        if (specFile == null || gemFile == null) {
            return null;
        }
        String path = specFile.getPath();
        if ((!this.mySpecs.containsKey(path) || isProjectGemSpec) && (spec = GemSpecParser.parseGemSpec(gemFile, specFile, isProjectGemSpec)) != null) {
            this.mySpecs.put(path, spec);
            this.registerWatchRootIfNeeded(specFile);
        }
        return this.mySpecs.get(path);
    }

    @Nullable
    private static GemSpecContext parseGemSpec(@NotNull VirtualFile gemFile, @NotNull VirtualFile file, boolean includeDevDependencies) {
        if (gemFile == null) {
            GemSpecParser.$$$reportNull$$$0(4);
        }
        if (file == null) {
            GemSpecParser.$$$reportNull$$$0(5);
        }
        return (GemSpecContext)ReadAction.nonBlocking(() -> {
            if (!file.isValid() || !gemFile.isValid()) {
                return null;
            }
            try {
                String contents = VfsUtilCore.loadText((VirtualFile)file);
                contents = contents.replace("\r", "");
                GemSpecContext result = new GemSpecContext();
                result.putData(GemsSpecKeys.SPEC_NAME, file.getNameWithoutExtension());
                GemSpecParser.addGitSpecs(file, result);
                GemSpecParser.parseSpec(contents, result);
                Set dev = (Set)GemsSpecKeys.DEVELOPMENT_DEPENDENCIES.get((UserDataHolder)result);
                Set dep = (Set)GemsSpecKeys.DEPENDENCIES.get((UserDataHolder)result);
                if (dev != null) {
                    if (includeDevDependencies) {
                        if (dep != null) {
                            dep.addAll(dev);
                        } else {
                            result.putData(GemsSpecKeys.DEPENDENCIES, dev);
                        }
                    } else if (dep != null) {
                        dep.removeAll(dev);
                    }
                }
                GemSpecParser.fixVersionConstant(gemFile, result);
                String version = (String)GemsSpecKeys.VERSION.get((UserDataHolder)result);
                if (version != null && !VERSION_VERIFIER.matcher(version).matches()) {
                    result.putData(GemsSpecKeys.VERSION, null);
                }
                return result;
            }
            catch (NoSuchFileException contents) {
            }
            catch (IOException e) {
                LOG.warn("Failed to read description", (Throwable)e);
            }
            return null;
        }).executeSynchronously();
    }

    public static void parseSpec(String contents, @NotNull GemSpecContext result) {
        if (result == null) {
            GemSpecParser.$$$reportNull$$$0(6);
        }
        GemSpecParser.parseRubySpec(contents, result);
        if (GemSpecParser.isIncomplete(result)) {
            GemSpecParser.tryParseYamlSpec(contents, result);
        }
    }

    private static boolean isIncomplete(@NotNull GemSpecContext result) {
        if (result == null) {
            GemSpecParser.$$$reportNull$$$0(7);
        }
        return StringUtil.isEmpty((String)((String)GemsSpecKeys.NAME.get((UserDataHolder)result)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryParseYamlSpec(String contents, GemSpecContext result) {
        Map map = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
            map = RubyUtil.loadYaml(in);
            if (map == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        catch (YAMLException e) {
            LOG.debug((Throwable)e);
            return false;
        }
        catch (RuntimeException e) {
            LOG.debug((Throwable)e);
        }
        if (map == null) return true;
        Object name = map.get(NAME_ATTRIBUTE);
        result.putData(GemsSpecKeys.NAME, name != null ? name.toString() : null);
        Map versionMap = (Map)map.get(VERSION_ATTRIBUTE);
        Object version = versionMap.get(VERSION_ATTRIBUTE);
        result.putData(GemsSpecKeys.VERSION, version != null ? version.toString() : null);
        Object email = map.get(EMAIL_ATTRIBUTE);
        result.putData(GemsSpecKeys.EMAIL, email != null ? email.toString() : null);
        Object homepage = map.get(HOMEPAGE_ATTRIBUTE);
        result.putData(GemsSpecKeys.HOMEPAGE, homepage != null ? homepage.toString() : null);
        Object summary = map.get(SUMMARY_ATTRIBUTE);
        result.putData(GemsSpecKeys.SUMMARY, summary != null ? summary.toString() : null);
        Object authors = map.get(AUTHORS_ATTRIBUTE);
        if (authors instanceof List) {
            String authorsStr = ((List)authors).stream().map(obj -> obj.toString()).reduce((a, b) -> a + ", " + b).orElse("");
            result.putData(GemsSpecKeys.AUTHORS, authorsStr);
        } else if (authors != null) {
            result.putData(GemsSpecKeys.AUTHORS, authors.toString());
        }
        Object require_paths = map.get(REQUIRE_PATHS);
        if (require_paths instanceof List) {
            List paths = ContainerUtil.map((Collection)((List)require_paths), obj -> obj.toString());
            result.putData(GemsSpecKeys.REQUIRE_PATHS, paths);
        } else if (require_paths != null) {
            result.putData(GemsSpecKeys.REQUIRE_PATHS, Collections.singletonList(require_paths.toString()));
        }
        GemSpecParser.addDependenciesFromYamlSpec(result, map.get("dependencies"), false);
        GemSpecParser.addDependenciesFromYamlSpec(result, map.get("runtime_dependencies"), false);
        GemSpecParser.addDependenciesFromYamlSpec(result, map.get("development_dependencies"), true);
        return true;
    }

    private static void addDependenciesFromYamlSpec(GemSpecContext result, Object dependencies, boolean isDevelopment) {
        if (dependencies instanceof Map) {
            Map depMap = (Map)dependencies;
            Set<GemDependency> deps = GemSpecParser.getDependencySet(result, isDevelopment);
            for (Map.Entry keyValue : depMap.entrySet()) {
                List depList;
                String depName = keyValue.getKey().toString();
                Object depValue = keyValue.getValue();
                if (depValue instanceof String) {
                    depList = ContainerUtil.map((Object[])((String)depValue).split(","), s -> s.trim());
                } else if (depValue instanceof List) {
                    depList = ContainerUtil.map((Collection)((List)depValue), obj -> obj.toString().trim());
                } else {
                    return;
                }
                deps.add(GemDependency.create(depName, ArrayUtilRt.toStringArray((Collection)depList)));
            }
        }
    }

    private static Set<GemDependency> getDependencySet(GemSpecContext result, boolean isDevelopment) {
        LinkedHashSet deps;
        Set set = deps = isDevelopment ? (LinkedHashSet)GemsSpecKeys.DEVELOPMENT_DEPENDENCIES.get((UserDataHolder)result) : (Set)GemsSpecKeys.DEPENDENCIES.get((UserDataHolder)result);
        if (deps == null) {
            deps = new LinkedHashSet();
            result.putData(isDevelopment ? GemsSpecKeys.DEVELOPMENT_DEPENDENCIES : GemsSpecKeys.DEPENDENCIES, deps);
        }
        return deps;
    }

    static void parseRubySpec(String contents, GemSpecContext result) {
        RFile rFile = RubyElementFactoryCore.createRubyFile((Project)ProjectManager.getInstance().getDefaultProject(), (String)contents);
        if (rFile == null) {
            return;
        }
        RubyPsiInterpreter interpreter = new RubyPsiInterpreter(true);
        final GemSpecCallable self = new GemSpecCallable(result);
        interpreter.registerCallable(new PsiCallable(){

            @Override
            public void processCall(RCallArguments arguments) {
                ProgressManager.checkCanceled();
                arguments.interpretBlock(self);
            }
        }, "Gem::Specification.new");
        interpreter.interpret((PsiElement)rFile, null);
    }

    private static void fixVersionConstant(VirtualFile file, GemSpecContext data) {
        String version = (String)GemsSpecKeys.VERSION.get((UserDataHolder)data);
        if (version == null || !version.contains("::")) {
            return;
        }
        VirtualFile lib = file.findChild("lib");
        if (lib == null) {
            data.putData(GemsSpecKeys.VERSION, null);
            return;
        }
        int index = version.lastIndexOf("::");
        String path = NamingConventions.toUnderscoreCase((String)version, (boolean)false) + ".rb";
        String constantName = version.substring(index + 2);
        VirtualFile versionFile = lib.findFileByRelativePath(path);
        if (versionFile == null) {
            path = NamingConventions.toUnderscoreCase((String)version.substring(0, index), (boolean)false) + ".rb";
            versionFile = lib.findFileByRelativePath(path);
        }
        if (versionFile == null) {
            data.putData(GemsSpecKeys.VERSION, null);
            return;
        }
        try {
            String contents = VfsUtilCore.loadText((VirtualFile)versionFile);
            Pattern pattern = Pattern.compile("^\\s*" + constantName + "\\s*=\\s*['\"](.*)['\"].*$", 8);
            Matcher matcher = pattern.matcher(contents);
            if (matcher.find() && matcher.groupCount() > 0) {
                data.putData(GemsSpecKeys.VERSION, GemSpecParser.unquoteString(matcher.group(1)));
            } else {
                data.putData(GemsSpecKeys.VERSION, null);
            }
        }
        catch (IOException e) {
            data.putData(GemsSpecKeys.VERSION, null);
            LOG.warn("Failed to read version file", (Throwable)e);
        }
    }

    private static void addGitSpecs(VirtualFile file, GemSpecContext result) {
        VirtualFile parent;
        for (parent = file.getParent(); parent != null && parent.findChild(".git") == null; parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        VirtualFile gemsDir = parent.getParent();
        if (gemsDir == null || !"gems".equals(gemsDir.getName())) {
            return;
        }
        VirtualFile bundlerDir = gemsDir.getParent();
        if (bundlerDir == null || !"bundler".equals(bundlerDir.getName())) {
            return;
        }
        String name = parent.getName();
        int right = name.lastIndexOf(45);
        if (right == -1) {
            return;
        }
        String ref = name.substring(right + 1);
        if (!GemSpecParser.looksLikeRealHash(ref)) {
            return;
        }
        result.putData(GemsSpecKeys.GIT, true);
        result.putData(GemsSpecKeys.REF, ref);
    }

    private static boolean looksLikeRealHash(@Nullable String ref) {
        if (ref == null || ref.length() < 6) {
            return false;
        }
        for (int i = ref.length() - 1; i >= 0; --i) {
            if (StringUtil.isHexDigit((char)ref.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<String> parseArrayOfStrings(@NotNull RArray array) {
        if (array == null) {
            GemSpecParser.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.map((Collection)array.getElements(), it -> GemSpecParser.unquoteString(it.getText()));
        if (list == null) {
            GemSpecParser.$$$reportNull$$$0(9);
        }
        return list;
    }

    private void registerWatchRootIfNeeded(VirtualFile file) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!file.isValid()) {
                return;
            }
            VirtualFile parent = file.getParent();
            if (parent == null) {
                return;
            }
            if (this.myWatchRequests.add(parent)) {
                RubyFileSystemUtil.addRootToWatch(VfsUtilCore.urlToPath((String)parent.getPath()), true, this);
            }
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawValue";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemSpecParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unfreezeQuoted";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayOfStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unfreezeQuoted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseGemSpec";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseSpec";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayOfStrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 9 -> new IllegalStateException(string);
        };
    }

    private static class GemSpecCallable
    implements PsiCallable {
        private final GemSpecContext mySpec;

        GemSpecCallable(GemSpecContext spec) {
            this.mySpec = spec;
        }

        @Override
        public void processCall(RCallArguments args) {
            RPsiElement value;
            RAssignmentExpression assign = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)args.getCallElement());
            String command = args.getCommand();
            RPsiElement rPsiElement = value = assign != null ? assign.getValue() : null;
            if (value == null) {
                if (GemSpecCallable.isDependencyCommand(command)) {
                    this.parseDependencies(args);
                }
                return;
            }
            String valueText = value.getText();
            if (Comparing.strEqual((String)GemSpecParser.NAME_ATTRIBUTE, (String)command)) {
                String name;
                if (value instanceof RStringLiteral) {
                    name = GemSpecParser.unquoteString(valueText);
                } else {
                    int delimiterPos;
                    String specName;
                    name = specName = (String)GemsSpecKeys.SPEC_NAME.get((UserDataHolder)this.mySpec);
                    if (specName != null && (delimiterPos = specName.lastIndexOf(45)) > 0) {
                        String suffix = specName.substring(delimiterPos + 1);
                        if (suffix.matches("([0-9]+(\\.[0-9A-z]+)*)")) {
                            name = specName.substring(0, delimiterPos);
                        } else if (GemSpecParser.isFrozenQuoted(valueText)) {
                            name = GemSpecParser.unfreezeQuoted(valueText);
                        }
                    }
                }
                this.mySpec.putData(GemsSpecKeys.NAME, name);
            } else if (Comparing.strEqual((String)GemSpecParser.VERSION_ATTRIBUTE, (String)command)) {
                this.mySpec.putData(GemsSpecKeys.VERSION, GemSpecParser.unquoteString(value.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.EMAIL_ATTRIBUTE, (String)command)) {
                if (value instanceof RArray) {
                    this.mySpec.putData(GemsSpecKeys.EMAIL, TextUtil.arrayToString((RArray)((RArray)value)));
                } else {
                    this.mySpec.putData(GemsSpecKeys.EMAIL, GemSpecParser.unquoteString(value.getText()));
                }
            } else if (Comparing.strEqual((String)GemSpecParser.HOMEPAGE_ATTRIBUTE, (String)command)) {
                this.mySpec.putData(GemsSpecKeys.HOMEPAGE, GemSpecParser.unquoteString(value.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.SUMMARY_ATTRIBUTE, (String)command)) {
                this.mySpec.putData(GemsSpecKeys.SUMMARY, GemSpecParser.unquoteString(value.getText()));
            } else if (Comparing.strEqual((String)GemSpecParser.AUTHORS_ATTRIBUTE, (String)command) && value instanceof RArray) {
                this.mySpec.putData(GemsSpecKeys.AUTHORS, TextUtil.arrayToString((RArray)((RArray)value)));
            } else if (Comparing.strEqual((String)GemSpecParser.REQUIRE_PATHS, (String)command)) {
                if (value instanceof RArray) {
                    this.mySpec.putData(GemsSpecKeys.REQUIRE_PATHS, GemSpecParser.parseArrayOfStrings((RArray)value));
                } else if (value instanceof RWords) {
                    ArrayList result = new ArrayList();
                    TextUtil.flatten((RPsiElement)value, result);
                    this.mySpec.putData(GemsSpecKeys.REQUIRE_PATHS, result);
                } else {
                    this.mySpec.putData(GemsSpecKeys.REQUIRE_PATHS, Collections.singletonList("lib"));
                }
            }
        }

        private void parseDependencies(RCallArguments args) {
            boolean isDevelopment = GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE.equals(args.getCommand());
            Set<GemDependency> deps = GemSpecParser.getDependencySet(this.mySpec, isDevelopment);
            List<RPsiElement> arguments = args.getArguments();
            if (!arguments.isEmpty()) {
                String text = arguments.get(0).getText();
                if (text != null) {
                    text = text.replace(GemSpecParser.DOT_FREEZE_SUFFIX, "");
                }
                GemSpecCallable.createDependencies(TextUtil.removeQuoting((String)text), arguments, deps);
            }
        }

        private static void createDependencies(String name, List<RPsiElement> arguments, Set<GemDependency> result) {
            GemDependency dependency;
            RPsiElement rPsiElement;
            ArrayList<String> deps = new ArrayList<String>();
            if (arguments.size() == 2 && (rPsiElement = arguments.get(1)) instanceof RArray) {
                Object object;
                RArray array = (RArray)rPsiElement;
                PsiElement[] elements = array.getChildren();
                if (elements.length == 0 || !((object = elements[0]) instanceof RListOfExpressions)) {
                    result.add(GemDependency.any(name));
                    return;
                }
                RListOfExpressions expressions = (RListOfExpressions)object;
                for (RPsiElement argument : expressions.getElements()) {
                    deps.add(GemSpecParser.unquoteString(argument.getText()));
                }
            } else {
                int size = arguments.size();
                for (int i = 1; i < size; ++i) {
                    RPsiElement argument = arguments.get(i);
                    if (!(argument instanceof RStringLiteral)) continue;
                    deps.add(GemSpecParser.unquoteString(argument.getText()));
                }
            }
            GemDependency gemDependency = dependency = deps.isEmpty() ? GemDependency.any(name) : GemDependency.create(name, deps.toArray(new String[0]));
            if (dependency != null) {
                result.add(dependency);
            }
        }

        private static boolean isDependencyCommand(String command) {
            return Comparing.strEqual((String)command, (String)GemSpecParser.DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)command, (String)GemSpecParser.RUNTIME_DEPENDENCIES_ATTRIBUTE) || Comparing.strEqual((String)command, (String)GemSpecParser.DEVELOPMENT_DEPENDENCIES_ATTRIBUTE);
        }
    }
}

